###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_itunes_bof_vuln_jun09.nasl 2615 2009-06-02 18:09:12Z june $
#
# Apple iTunes 'itms:' URI Stack Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800804);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0950");
  script_bugtraq_id(35157);
  script_name("Apple iTunes 'itms:' URI Stack Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has Apple iTunes installed, which is prone to stack
  based Buffer Overflow vulnerability.

  Vulnerability Insight:
  Error occurs when application fails to perform adequate boundary checks
  before copying user-supplied data to an insufficiently-sized buffer while
  processing a specially crafted 'itms:' URL.

  Impact:
  Successful attacks will lead to buffer overflow or denial of service to
  legitimate users.

  Impact Level: Application

  Affected Software/OS:
  Apple iTunes version prior to 8.2 on Windows.

  Fix: Upgrade to Apple iTunes Version 8.2
  http://www.apple.com/itunes/download

  References:
  http://support.apple.com/kb/HT3592
  http://www.securitytracker.com/alerts/2009/Jun/1022313.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Apple iTunes");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_apple_itunes_detection_win_900123.nasl");
  script_require_keys("iTunes/Win/Ver");
  exit(0);
}


include("version_func.inc");

itunesVer = get_kb_item("iTunes/Win/Ver");
if(!itunesVer){
  exit(0);
}

# Check for iTunes version prior to 8.2 => 8.2.0.23
if(version_is_less(version:itunesVer, test_version:"8.2.0.23")){
  security_hole(0);
}
