# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0867 (DevIL)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63265);
 script_cve_id("CVE-2008-5262");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-0867 (DevIL)";
 script_name(name);

 desc = "The remote host is missing an update to DevIL
announced via advisory FEDORA-2009-0867.

Update Information:

- Fix missing symbols (rh 480269)  - Fix off by one error in CVE-2008-5262 check
(rh 479864)

References:

[ 1 ] Bug #479864 - CVE-2008-5262 DevIL: RGBE buffer overflow vulnerabilities
https://bugzilla.redhat.com/show_bug.cgi?id=479864

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update DevIL' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0867

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-0867 (DevIL)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"DevIL", rpm:"DevIL~1.7.5~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"DevIL-ILUT", rpm:"DevIL-ILUT~1.7.5~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"DevIL-ILUT-devel", rpm:"DevIL-ILUT-devel~1.7.5~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"DevIL-devel", rpm:"DevIL-devel~1.7.5~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"DevIL-debuginfo", rpm:"DevIL-debuginfo~1.7.5~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
