# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1766-1 (krb5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63793);
 script_cve_id("CVE-2009-0844", "CVE-2009-0845", "CVE-2009-0847", "CVE-2009-0846");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1766-1 (krb5)";
 script_name(name);

 desc = "The remote host is missing an update to krb5
announced via advisory DSA 1766-1.

Several vulnerabilities have been found in the MIT reference implementation
of Kerberos V5, a system for authenticating users and services on a network.
The Common Vulnerabilities and Exposures project identified the following
problems:

The Apple Product Security team discovered that the SPNEGO GSS-API mechanism
suffers of a missing bounds check when reading a network input buffer which
results in an invalid read crashing the application or possibly leaking
information (CVE-2009-0844).

Under certain conditions the SPNEGO GSS-API mechanism references a null pointer
which crashes the application using the library (CVE-2009-0845).

An incorrect length check inside the ASN.1 decoder of the MIT krb5
implementation allows an unauthenticated remote attacker to crash of the kinit
or KDC program (CVE-2009-0847).

Under certain conditions the the ASN.1 decoder of the MIT krb5 implementation
frees an uninitialized pointer which could lead to denial of service and
possibly arbitrary code execution (CVE-2009-0846).


For the oldstable distribution (etch), this problem has been fixed in
version 1.4.4-7etch7.

For the stable distribution (lenny), this problem has been fixed in
version 1.6.dfsg.4~beta1-5lenny1.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 1.6.dfsg.4~beta1-13.


We recommend that you upgrade your krb5 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201766-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1766-1 (krb5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.4-7etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc-ldap", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-pkinit", ver:"1.6.dfsg.4~beta1-5lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
