# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1712-1 (rt2400)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63298);
 script_cve_id("CVE-2009-0282");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1712-1 (rt2400)";
 script_name(name);

 desc = "The remote host is missing an update to rt2400
announced via advisory DSA 1712-1.

It was discovered that an integer overflow in the Probe Request packet
parser of the Ralinktech wireless drivers might lead to remote denial of
service or the execution of arbitrary code.

Please note that you need to rebuild your driver from the source
package in order to set this update into effect. Detailed
instructions can be found in /usr/share/doc/rt2400-source/README.Debian

For the stable distribution (etch), this problem has been fixed in
version 1.2.2+cvs20060620-4+etch1.

For the upcoming stable distribution (lenny) and the unstable
distribution (sid), this problem has been fixed in version
1.2.2+cvs20080623-3.

We recommend that you upgrade your rt2400 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201712-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1712-1 (rt2400)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rt2400-source", ver:"1.2.2+cvs20060620-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt2400", ver:"1.2.2+cvs20060620-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
