# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1668-1 (hf)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61906);
 script_cve_id("CVE-2008-2378");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1668-1 (hf)";
 script_name(name);

 desc = "The remote host is missing an update to hf
announced via advisory DSA 1668-1.

Steve Kemp discovered that hf, an amateur-radio protocol suite using
a soundcard as a modem, insecurely tried to execute an external command
which could lead to the elevation of privileges for local users.

For the stable distribution (etch), this problem has been fixed in version
0.7.3-4etch1.

For the unstable distribution (sid), this problem has been fixed in
version 0.8-8.1.

We recommend that you upgrade your hf package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201668-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1668-1 (hf)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hf", ver:"0.7.3-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
