# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1206-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57567);
 script_cve_id("CVE-2005-3353", "CVE-2006-3017", "CVE-2006-4482", "CVE-2006-5465");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1206-1 (php4)";
 script_name(name);

 desc = "The remote host is missing an update to php4
announced via advisory DSA 1206-1.

Several remote vulnerabilities have been discovered in PHP, a
server-side, HTML-embedded scripting language, which may lead to the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2005-3353

Tim Starling discovered that missing input sanitising in the EXIF
module could lead to denial of service.

CVE-2006-3017

Stefan Esser discovered a security-critical programming error in the
hashtable implementation of the internal Zend engine.

CVE-2006-4482

It was discovered that str_repeat() and wordwrap() functions perform
insufficient checks for buffer boundaries on 64 bit systems, which
might lead to the execution of arbitrary code.

CVE-2006-5465

Stefan Esser discovered a buffer overflow in the htmlspecialchars()
and htmlentities(), which might lead to the execution of arbitrary
code.

For the stable distribution (sarge) these problems have been fixed in
version 4:4.3.10-18. Builds for hppa and m68k will be provided later
once they are available.

For the unstable distribution (sid) these problems have been fixed in
version 4:4.4.4-4 of php4 and version 5.1.6-6 of php5.

We recommend that you upgrade your php4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201206-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1206-1 (php4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4-pear", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php4", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php4", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cli", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-common", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-curl", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-dev", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-domxml", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcal", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-odbc", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-recode", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-sybase", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xslt", ver:"4.3.10-18", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
