/* openvas-libraries/base
 * $Id$
 * Description: Definitions for GPGME utilities.
 *
 * Authors:
 * Werner Koch <wk@gnupg.org>
 *
 * Copyright:
 * Copyright (C) 2013 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * @file gpgme_util.h
 * @brief Protos and data structures for GPGME utilities.
 *
 * This file contains the protos for \ref gpgme_util.c
 */

#ifndef _OPENVAS_LIBRARIES_GPGME_UTIL_H
#define _OPENVAS_LIBRARIES_GPGME_UTIL_H

#include <gpgme.h>

gpgme_ctx_t openvas_init_gpgme_ctx (const gchar *);
gpgme_ctx_t openvas_init_gpgme_sysconf_ctx (void);
void set_gpghome (const char *);


#endif /*_OPENVAS_LIBRARIES_GPGME_UTIL_H*/
