char volume_accumulateSamples_lit_frag[] = "#version 110\n"
                                           "\n"
                                           "uniform sampler3D volumeTexture;\n"
                                           "\n"
                                           "uniform float AlphaFuncValue;\n"
                                           "uniform float TransparencyValue;\n"
                                           "\n"
                                           "varying vec3 lightDirection;\n"
                                           "\n"
                                           "vec4 accumulateSamples(vec4 fragColor, vec3 ts, vec3 te, vec3 dt, float scale, float cutoff, int num_iterations)\n"
                                           "{\n"
                                           "    vec3 texcoord = te.xyz;\n"
                                           "\n"
                                           "    float normalSampleDistance = length(dt);\n"
                                           "    vec3 deltaX = vec3(normalSampleDistance, 0.0, 0.0);\n"
                                           "    vec3 deltaY = vec3(0.0, normalSampleDistance, 0.0);\n"
                                           "    vec3 deltaZ = vec3(0.0, 0.0, normalSampleDistance);\n"
                                           "\n"
                                           "    float transmittance = 1.0;\n"
                                           "    float t_cutoff = 1.0-cutoff;\n"
                                           "    while(num_iterations>0 && transmittance>=t_cutoff)\n"
                                           "    {\n"
                                           "        vec4 color = texture3D( volumeTexture, texcoord);\n"
                                           "\n"
                                           "        if (color.a>=AlphaFuncValue)\n"
                                           "        {\n"
                                           "\n"
                                           "            float px = texture3D( volumeTexture, texcoord + deltaX).a;\n"
                                           "            float py = texture3D( volumeTexture, texcoord + deltaY).a;\n"
                                           "            float pz = texture3D( volumeTexture, texcoord + deltaZ).a;\n"
                                           "\n"
                                           "            float nx = texture3D( volumeTexture, texcoord - deltaX).a;\n"
                                           "            float ny = texture3D( volumeTexture, texcoord - deltaY).a;\n"
                                           "            float nz = texture3D( volumeTexture, texcoord - deltaZ).a;\n"
                                           "\n"
                                           "            vec3 grad = vec3(px-nx, py-ny, pz-nz);\n"
                                           "            if (grad.x!=0.0 || grad.y!=0.0 || grad.z!=0.0)\n"
                                           "            {\n"
                                           "                vec3 normal = normalize(grad);\n"
                                           "                float lightScale = 0.1 +  max(0.0, dot(normal.xyz, lightDirection))*0.9;\n"
                                           "\n"
                                           "                color.r *= lightScale;\n"
                                           "                color.g *= lightScale;\n"
                                           "                color.b *= lightScale;\n"
                                           "            }\n"
                                           "\n"
                                           "            float ca = clamp(color.a*TransparencyValue, 0.0, 1.0);\n"
                                           "            float new_transmitance = transmittance*pow(1.0-ca, scale);\n"
                                           "            float r = transmittance-new_transmitance;\n"
                                           "            fragColor.rgb += color.rgb*r;\n"
                                           "            transmittance = new_transmitance;\n"
                                           "        }\n"
                                           "\n"
                                           "        texcoord += dt;\n"
                                           "\n"
                                           "        --num_iterations;\n"
                                           "    }\n"
                                           "\n"
                                           "    fragColor.a = clamp(1.0-transmittance, 0.0, 1.0);\n"
                                           "    if (num_iterations>0) fragColor.a = 1.0;\n"
                                           "\n"
                                           "    return fragColor;\n"
                                           "}\n"
                                           "\n";
