/**********************************************************************
 *
 *    FILE:            PrimitiveSet.cpp
 *
 *    DESCRIPTION:    Read/Write osg::PrimitiveSet in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 18.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "Object.h"
#include "PrimitiveSet.h"

using namespace ive;

void PrimitiveSet::write(DataOutputStream* out){
    // Write PrimitiveSet's identification.
    out->writeInt(IVEPRIMITIVESET);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("PrimitiveSet::write(): Could not cast this osg::PrimitiveSet to an osg::Object.");


    if ( out->getVersion() >= VERSION_0038 )
    {
        out->writeInt(getNumInstances());
    }

    // Write PrimitiveSet's properties.
    out->writeInt(getMode());
}

void PrimitiveSet::read(DataInputStream* in){
    // Read PrimitiveSet's identification.
    int id = in->peekInt();
    if(id == IVEPRIMITIVESET){
        // Code to read PrimitiveSet's properties.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("PrimitiveSet::read(): Could not cast this osg::PrimitiveSet to an osg::Object.");


        if ( in->getVersion() >= VERSION_0038 )
        {
            setNumInstances(in->readInt());
        }

        // Read in primitiveset properties.
        setMode(in->readInt());
    }
    else{
        in_THROW_EXCEPTION("PrimitiveSet::read(): Expected PrimitiveSet identification.");
    }
}
