/*
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2005 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart, 
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * Copyright (c) 2012-2013 Los Alamos National Security, Inc.  All rights reserved. 
 * Copyright (c) 2014      Research Organization for Information Science
 *                         and Technology (RIST). All rights reserved.
 * $COPYRIGHT$
 * 
 * Additional copyrights may follow
 * 
 * $HEADER$
 */

#include "ompi_config.h"

#include <stdio.h>

#include "ompi/constants.h"
#include "opal/class/opal_list.h"
#include "opal/util/output.h"
#include "opal/mca/mca.h"
#include "opal/mca/base/base.h"


#include "ompi/mca/topo/base/base.h"

/*
 * The static-component.h is generated by the configure script. It contains
 * statements and the definition of an array of pointers to each component's
 * public mca_base_component_t struct.
 */
#include "ompi/mca/topo/base/static-components.h"

static void mca_topo_base_module_construct(mca_topo_base_module_t * topo) {
    memset(&(topo->mtc), 0, sizeof(topo->mtc));
}

static void mca_topo_base_module_destruct(mca_topo_base_module_t * topo) {
    assert (OMPI_COMM_CART == topo->type ||
            OMPI_COMM_GRAPH == topo->type ||
            OMPI_COMM_DIST_GRAPH == topo->type);

    switch (topo->type) {
        case OMPI_COMM_CART:
            if (NULL != topo->mtc.cart) {
                if (NULL != topo->mtc.cart->dims) {
                    free(topo->mtc.cart->dims);
                }
                if (NULL != topo->mtc.cart->periods) {
                    free(topo->mtc.cart->periods);
                }
                if (NULL != topo->mtc.cart->coords) {
                    free(topo->mtc.cart->coords);
                }
                free(topo->mtc.cart);
            }
            break;
        case OMPI_COMM_GRAPH: 
            if (NULL != topo->mtc.graph) {
                if (NULL != topo->mtc.graph->index) {
                    free(topo->mtc.graph->index);
                }
                if (NULL != topo->mtc.graph->edges) {
                    free(topo->mtc.graph->edges);
                }
                free(topo->mtc.graph);
            }
            break;
        case OMPI_COMM_DIST_GRAPH: 
            if (NULL != topo->mtc.dist_graph) {
                if (NULL != topo->mtc.dist_graph->in) {
                    free(topo->mtc.dist_graph->in);
                }
                if (NULL != topo->mtc.dist_graph->inw) {
                    free(topo->mtc.dist_graph->inw);
                }
                if (NULL != topo->mtc.dist_graph->out) {
                    free(topo->mtc.dist_graph->out);
                }
                if (NULL != topo->mtc.dist_graph->outw) {
                    free(topo->mtc.dist_graph->outw);
                }
                free(topo->mtc.dist_graph);
            }
            break;
    }
}

OBJ_CLASS_INSTANCE(mca_topo_base_module_t, opal_object_t,
                   mca_topo_base_module_construct,
                   mca_topo_base_module_destruct);

static int mca_topo_base_close(void) 
{
    return mca_base_framework_components_close(&ompi_topo_base_framework, NULL);
}

/**
 * Function for finding and opening either all the MCA topo components, or
 * the one that specifically requested via a MCA parameter.
 */
static int mca_topo_base_open(mca_base_open_flag_t flags) 
{
    return mca_base_framework_components_open(&ompi_topo_base_framework, flags);
}

MCA_BASE_FRAMEWORK_DECLARE(ompi, topo, "OMPI Topo", NULL,
                           mca_topo_base_open, mca_topo_base_close,
                           mca_topo_base_static_components, 0);

