/*
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javafx.scene.control;

/**
Builder class for javafx.scene.control.MultipleSelectionModel
@see javafx.scene.control.MultipleSelectionModel
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public abstract class MultipleSelectionModelBuilder<T, B extends javafx.scene.control.MultipleSelectionModelBuilder<T, B>> {
    protected MultipleSelectionModelBuilder() {
    }


    private int __set;
    public void applyTo(javafx.scene.control.MultipleSelectionModel<T> x) {
        int set = __set;
        if ((set & (1 << 0)) != 0) x.getSelectedIndices().addAll(this.selectedIndices);
        if ((set & (1 << 1)) != 0) x.getSelectedItems().addAll(this.selectedItems);
        if ((set & (1 << 2)) != 0) x.setSelectionMode(this.selectionMode);
    }

    private java.util.Collection<? extends java.lang.Integer> selectedIndices;
    /**
    Add the given items to the List of items in the {@link javafx.scene.control.MultipleSelectionModel#getSelectedIndices() selectedIndices} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B selectedIndices(java.util.Collection<? extends java.lang.Integer> x) {
        this.selectedIndices = x;
        __set |= 1 << 0;
        return (B) this;
    }

    /**
    Add the given items to the List of items in the {@link javafx.scene.control.MultipleSelectionModel#getSelectedIndices() selectedIndices} property for the instance constructed by this builder.
    */
    public B selectedIndices(java.lang.Integer... x) {
        return selectedIndices(java.util.Arrays.asList(x));
    }

    private java.util.Collection<? extends T> selectedItems;
    /**
    Add the given items to the List of items in the {@link javafx.scene.control.MultipleSelectionModel#getSelectedItems() selectedItems} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B selectedItems(java.util.Collection<? extends T> x) {
        this.selectedItems = x;
        __set |= 1 << 1;
        return (B) this;
    }

    /**
    Add the given items to the List of items in the {@link javafx.scene.control.MultipleSelectionModel#getSelectedItems() selectedItems} property for the instance constructed by this builder.
    */
    public B selectedItems(T... x) {
        return selectedItems(java.util.Arrays.asList(x));
    }

    private javafx.scene.control.SelectionMode selectionMode;
    /**
    Set the value of the {@link javafx.scene.control.MultipleSelectionModel#getSelectionMode() selectionMode} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B selectionMode(javafx.scene.control.SelectionMode x) {
        this.selectionMode = x;
        __set |= 1 << 2;
        return (B) this;
    }

}
