/*
 * Copyright (c) 2004, 2015, Oracle and/or its affiliates. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 *   - Neither the name of Oracle nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This source code is provided to illustrate the usage of a given feature
 * or technique and has been deliberately simplified. Additional steps
 * required for a production-quality application, such as security checks,
 * input validation and proper error handling, might not be present in
 * this sample code.
 */


#ifndef AGENT_UTIL_H
#define AGENT_UTIL_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <stdarg.h>

#include "jni.h"
#include "jvmti.h"

#ifdef __cplusplus
extern "C" {
#endif

void  stdout_message(const char * format, ...);
void  fatal_error(const char * format, ...);
char *get_token(char *str, char *seps, char *buf, int max);
int   interested(char *cname, char *mname,
                    char *include_list, char *exclude_list);

void  check_jvmti_error(jvmtiEnv *jvmti, jvmtiError errnum, const char *str);
void  deallocate(jvmtiEnv *jvmti, void *ptr);
void *allocate(jvmtiEnv *jvmti, jint len);
void  add_demo_jar_to_bootclasspath(jvmtiEnv *jvmti, char *demo_name);

#ifdef STATIC_BUILD
/* Macros for handling declaration of static/dynamic
 * Agent library Load/Attach/Unload functions
 *
 * DEF_Agent_OnLoad, DEF_Agent_OnAttach or DEF_Agent_OnUnload
 * generate the appropriate entrypoint names based on static
 * versus dynamic builds.
 *
 * STATIC_BUILD must be defined to build static versions of these libraries.
 * LIBRARY_NAME must be set to the name of the library for static builds.
 */
#define ADD_LIB_NAME3(name, lib) name ## lib
#define ADD_LIB_NAME2(name, lib) ADD_LIB_NAME3(name, lib)
#define ADD_LIB_NAME(entry) ADD_LIB_NAME2(entry, LIBRARY_NAME)

#define DEF_Agent_OnLoad \
ADD_LIB_NAME(Agent_OnLoad_)(JavaVM *vm, char *options, void *reserved) \
{ \
  jint JNICALL ADD_LIB_NAME(Agent_OnLoad_dynamic_)(JavaVM *vm, char *options, void *reserved); \
  return ADD_LIB_NAME(Agent_OnLoad_dynamic_)(vm, options, reserved); \
} \
jint JNICALL ADD_LIB_NAME(Agent_OnLoad_dynamic_)

#define DEF_Agent_OnAttach \
ADD_LIB_NAME(Agent_OnAttach_)(JavaVM *vm, char *options, void *reserved) \
{ \
  jint JNICALL ADD_LIB_NAME(Agent_OnAttach_dynamic_)(JavaVM *vm, char *options, void *reserved); \
  return ADD_LIB_NAME(Agent_OnAttach_dynamic_)(vm, options, reserved); \
} \
jint JNICALL ADD_LIB_NAME(Agent_OnAttach_dynamic_)

#define DEF_Agent_OnUnload \
ADD_LIB_NAME(Agent_OnUnload_)(JavaVM *vm) \
{ \
  void JNICALL ADD_LIB_NAME(Agent_OnUnload_dynamic_)(JavaVM *vm); \
  ADD_LIB_NAME(Agent_OnUnload_dynamic_)(vm); \
} \
void JNICALL ADD_LIB_NAME(Agent_OnUnload_dynamic_)

#else
#define DEF_Agent_OnLoad Agent_OnLoad
#define DEF_Agent_OnAttach Agent_OnAttach
#define DEF_Agent_OnUnload Agent_OnUnload
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif
