/* == Start of generated table == */
/*
 * The following table is generated by running:
 *
 *   ./gen-arabic-table.py ArabicShaping.txt UnicodeData.txt Blocks.txt
 *
 * on files with these headers:
 *
 * # ArabicShaping-14.0.0.txt
 * # Date: 2021-05-21, 01:54:00 GMT [KW, RP]
 * # Blocks-14.0.0.txt
 * # Date: 2021-01-22, 23:29:00 GMT [KW]
 * UnicodeData.txt does not have a header.
 */

#ifndef HB_OT_SHAPER_ARABIC_TABLE_HH
#define HB_OT_SHAPER_ARABIC_TABLE_HH


#define A       JOINING_GROUP_ALAPH
#define DR      JOINING_GROUP_DALATH_RISH
#define C       JOINING_TYPE_C
#define D       JOINING_TYPE_D
#define L       JOINING_TYPE_L
#define R       JOINING_TYPE_R
#define T       JOINING_TYPE_T
#define U       JOINING_TYPE_U
#define X       JOINING_TYPE_X

static const uint8_t joining_table[] =
{

#define joining_offset_0x0600u 0

  /* Arabic */

  /* 0600 */ U,U,U,U,U,U,X,X,U,X,X,U,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0620 */ D,U,R,R,R,R,D,R,D,R,D,D,D,D,D,R,R,R,R,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 0640 */ C,D,D,D,D,D,D,D,R,D,D,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0660 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,D,D,X,R,R,R,U,R,R,R,D,D,D,D,D,D,D,D,
  /* 0680 */ D,D,D,D,D,D,D,D,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,D,D,D,D,D,D,
  /* 06A0 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 06C0 */ R,D,D,R,R,R,R,R,R,R,R,R,D,R,D,R,D,D,R,R,X,R,X,X,X,X,X,X,X,U,X,X,
  /* 06E0 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,R,R,X,X,X,X,X,X,X,X,X,X,D,D,D,X,X,D,

  /* Syriac */

  /* 0700 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,T,A,X,D,D,D,DR,DR,R,R,R,D,D,D,D,R,D,
  /* 0720 */ D,D,D,D,D,D,D,D,R,D,DR,D,R,D,D,DR,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0740 */ X,X,X,X,X,X,X,X,X,X,X,X,X,R,D,D,

  /* Arabic Supplement */

  /* 0740 */                                 D,D,D,D,D,D,D,D,D,R,R,R,D,D,D,D,
  /* 0760 */ D,D,D,D,D,D,D,D,D,D,D,R,R,D,D,D,D,R,D,R,R,D,D,D,R,R,D,D,D,D,D,D,

  /* FILLER */

  /* 0780 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 07A0 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* NKo */

  /* 07C0 */ X,X,X,X,X,X,X,X,X,X,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 07E0 */ D,D,D,D,D,D,D,D,D,D,D,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,C,X,X,X,X,X,

  /* FILLER */

  /* 0800 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 0820 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* Mandaic */

  /* 0840 */ R,D,D,D,D,D,R,R,D,R,D,D,D,D,D,D,D,D,D,D,R,D,R,R,R,X,X,X,X,X,X,X,

  /* Syriac Supplement */

  /* 0860 */ D,U,D,D,D,D,U,R,D,R,R,X,X,X,X,X,

  /* Arabic Extended-B */

  /* 0860 */                                 R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,R,
  /* 0880 */ R,R,R,C,C,C,D,U,U,D,D,D,D,D,R,X,U,U,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* Arabic Extended-A */

  /* 08A0 */ D,D,D,D,D,D,D,D,D,D,R,R,R,U,R,D,D,R,R,D,D,D,D,D,D,R,D,D,D,D,D,D,
  /* 08C0 */ D,D,D,D,D,D,D,D,D,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 08E0 */ X,X,U,

#define joining_offset_0x1806u 739

  /* Mongolian */

  /* 1800 */             U,D,X,X,C,X,X,X,U,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 1820 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 1840 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 1860 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,X,X,X,X,X,X,X,
  /* 1880 */ U,U,U,U,U,T,T,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 18A0 */ D,D,D,D,D,D,D,D,D,X,D,

#define joining_offset_0x200cu 904

  /* General Punctuation */

  /* 2000 */                         U,C,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 2020 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,U,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 2040 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 2060 */ X,X,X,X,X,X,U,U,U,U,

#define joining_offset_0xa840u 998

  /* Phags-pa */

  /* A840 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* A860 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,L,U,

#define joining_offset_0x10ac0u 1050

  /* Manichaean */

  /* 10AC0 */ D,D,D,D,D,R,U,R,U,R,R,U,U,L,R,R,R,R,R,D,D,D,D,L,D,D,D,D,D,R,D,D,
  /* 10AE0 */ D,R,U,U,R,X,X,X,X,X,X,D,D,D,D,R,

#define joining_offset_0x10b80u 1098

  /* Psalter Pahlavi */

  /* 10B80 */ D,R,D,R,R,R,D,D,D,R,D,D,R,D,R,R,D,R,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 10BA0 */ X,X,X,X,X,X,X,X,X,R,R,R,R,D,D,U,

#define joining_offset_0x10d00u 1146

  /* Hanifi Rohingya */

  /* 10D00 */ L,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 10D20 */ D,D,R,D,

#define joining_offset_0x10f30u 1182

  /* Sogdian */

  /* 10F20 */                                 D,D,D,R,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 10F40 */ D,D,D,D,D,U,X,X,X,X,X,X,X,X,X,X,X,D,D,D,R,X,X,X,X,X,X,X,X,X,X,X,
  /* 10F60 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* Old Uyghur */

  /* 10F60 */                                 D,D,D,D,R,R,D,D,D,D,D,D,D,D,D,D,
  /* 10F80 */ D,D,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
  /* 10FA0 */ X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,

  /* Chorasmian */

  /* 10FA0 */                                 D,U,D,D,R,R,R,U,D,R,R,D,D,R,D,D,
  /* 10FC0 */ U,D,R,R,D,U,U,U,U,R,D,L,

#define joining_offset_0x110bdu 1338

  /* Kaithi */

  /* 110A0 */                                                           U,X,X,
  /* 110C0 */ X,X,X,X,X,X,X,X,X,X,X,X,X,U,

#define joining_offset_0x1e900u 1355

  /* Adlam */

  /* 1E900 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 1E920 */ D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,
  /* 1E940 */ D,D,D,D,X,X,X,X,X,X,X,T,

}; /* Table items: 1431; occupancy: 57% */


static unsigned int
joining_type (hb_codepoint_t u)
{
  switch (u >> 12)
  {
    case 0x0u:
      if (hb_in_range<hb_codepoint_t> (u, 0x0600u, 0x08E2u)) return joining_table[u - 0x0600u + joining_offset_0x0600u];
      break;

    case 0x1u:
      if (hb_in_range<hb_codepoint_t> (u, 0x1806u, 0x18AAu)) return joining_table[u - 0x1806u + joining_offset_0x1806u];
      break;

    case 0x2u:
      if (hb_in_range<hb_codepoint_t> (u, 0x200Cu, 0x2069u)) return joining_table[u - 0x200Cu + joining_offset_0x200cu];
      break;

    case 0xAu:
      if (hb_in_range<hb_codepoint_t> (u, 0xA840u, 0xA873u)) return joining_table[u - 0xA840u + joining_offset_0xa840u];
      break;

    case 0x10u:
      if (hb_in_range<hb_codepoint_t> (u, 0x10AC0u, 0x10AEFu)) return joining_table[u - 0x10AC0u + joining_offset_0x10ac0u];
      if (hb_in_range<hb_codepoint_t> (u, 0x10B80u, 0x10BAFu)) return joining_table[u - 0x10B80u + joining_offset_0x10b80u];
      if (hb_in_range<hb_codepoint_t> (u, 0x10D00u, 0x10D23u)) return joining_table[u - 0x10D00u + joining_offset_0x10d00u];
      if (hb_in_range<hb_codepoint_t> (u, 0x10F30u, 0x10FCBu)) return joining_table[u - 0x10F30u + joining_offset_0x10f30u];
      break;

    case 0x11u:
      if (hb_in_range<hb_codepoint_t> (u, 0x110BDu, 0x110CDu)) return joining_table[u - 0x110BDu + joining_offset_0x110bdu];
      break;

    case 0x1Eu:
      if (hb_in_range<hb_codepoint_t> (u, 0x1E900u, 0x1E94Bu)) return joining_table[u - 0x1E900u + joining_offset_0x1e900u];
      break;

    default:
      break;
  }
  return X;
}

#undef A
#undef DR
#undef C
#undef D
#undef L
#undef R
#undef T
#undef U
#undef X


static const uint16_t shaping_table[][4] =
{
  {0x0000u, 0x0000u, 0x0000u, 0xFE80u}, /* U+0621 ARABIC LETTER HAMZA ISOLATED FORM */
  {0x0000u, 0x0000u, 0xFE82u, 0xFE81u}, /* U+0622 ARABIC LETTER ALEF WITH MADDA ABOVE */
  {0x0000u, 0x0000u, 0xFE84u, 0xFE83u}, /* U+0623 ARABIC LETTER ALEF WITH HAMZA ABOVE */
  {0x0000u, 0x0000u, 0xFE86u, 0xFE85u}, /* U+0624 ARABIC LETTER WAW WITH HAMZA ABOVE */
  {0x0000u, 0x0000u, 0xFE88u, 0xFE87u}, /* U+0625 ARABIC LETTER ALEF WITH HAMZA BELOW */
  {0xFE8Bu, 0xFE8Cu, 0xFE8Au, 0xFE89u}, /* U+0626 ARABIC LETTER YEH WITH HAMZA ABOVE */
  {0x0000u, 0x0000u, 0xFE8Eu, 0xFE8Du}, /* U+0627 ARABIC LETTER ALEF */
  {0xFE91u, 0xFE92u, 0xFE90u, 0xFE8Fu}, /* U+0628 ARABIC LETTER BEH */
  {0x0000u, 0x0000u, 0xFE94u, 0xFE93u}, /* U+0629 ARABIC LETTER TEH MARBUTA */
  {0xFE97u, 0xFE98u, 0xFE96u, 0xFE95u}, /* U+062A ARABIC LETTER TEH */
  {0xFE9Bu, 0xFE9Cu, 0xFE9Au, 0xFE99u}, /* U+062B ARABIC LETTER THEH */
  {0xFE9Fu, 0xFEA0u, 0xFE9Eu, 0xFE9Du}, /* U+062C ARABIC LETTER JEEM */
  {0xFEA3u, 0xFEA4u, 0xFEA2u, 0xFEA1u}, /* U+062D ARABIC LETTER HAH */
  {0xFEA7u, 0xFEA8u, 0xFEA6u, 0xFEA5u}, /* U+062E ARABIC LETTER KHAH */
  {0x0000u, 0x0000u, 0xFEAAu, 0xFEA9u}, /* U+062F ARABIC LETTER DAL */
  {0x0000u, 0x0000u, 0xFEACu, 0xFEABu}, /* U+0630 ARABIC LETTER THAL */
  {0x0000u, 0x0000u, 0xFEAEu, 0xFEADu}, /* U+0631 ARABIC LETTER REH */
  {0x0000u, 0x0000u, 0xFEB0u, 0xFEAFu}, /* U+0632 ARABIC LETTER ZAIN */
  {0xFEB3u, 0xFEB4u, 0xFEB2u, 0xFEB1u}, /* U+0633 ARABIC LETTER SEEN */
  {0xFEB7u, 0xFEB8u, 0xFEB6u, 0xFEB5u}, /* U+0634 ARABIC LETTER SHEEN */
  {0xFEBBu, 0xFEBCu, 0xFEBAu, 0xFEB9u}, /* U+0635 ARABIC LETTER SAD */
  {0xFEBFu, 0xFEC0u, 0xFEBEu, 0xFEBDu}, /* U+0636 ARABIC LETTER DAD */
  {0xFEC3u, 0xFEC4u, 0xFEC2u, 0xFEC1u}, /* U+0637 ARABIC LETTER TAH */
  {0xFEC7u, 0xFEC8u, 0xFEC6u, 0xFEC5u}, /* U+0638 ARABIC LETTER ZAH */
  {0xFECBu, 0xFECCu, 0xFECAu, 0xFEC9u}, /* U+0639 ARABIC LETTER AIN */
  {0xFECFu, 0xFED0u, 0xFECEu, 0xFECDu}, /* U+063A ARABIC LETTER GHAIN */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+063B  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+063C  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+063D  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+063E  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+063F  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0640  */
  {0xFED3u, 0xFED4u, 0xFED2u, 0xFED1u}, /* U+0641 ARABIC LETTER FEH */
  {0xFED7u, 0xFED8u, 0xFED6u, 0xFED5u}, /* U+0642 ARABIC LETTER QAF */
  {0xFEDBu, 0xFEDCu, 0xFEDAu, 0xFED9u}, /* U+0643 ARABIC LETTER KAF */
  {0xFEDFu, 0xFEE0u, 0xFEDEu, 0xFEDDu}, /* U+0644 ARABIC LETTER LAM */
  {0xFEE3u, 0xFEE4u, 0xFEE2u, 0xFEE1u}, /* U+0645 ARABIC LETTER MEEM */
  {0xFEE7u, 0xFEE8u, 0xFEE6u, 0xFEE5u}, /* U+0646 ARABIC LETTER NOON */
  {0xFEEBu, 0xFEECu, 0xFEEAu, 0xFEE9u}, /* U+0647 ARABIC LETTER HEH */
  {0x0000u, 0x0000u, 0xFEEEu, 0xFEEDu}, /* U+0648 ARABIC LETTER WAW */
  {0xFBE8u, 0xFBE9u, 0xFEF0u, 0xFEEFu}, /* U+0649 ARABIC LETTER */
  {0xFEF3u, 0xFEF4u, 0xFEF2u, 0xFEF1u}, /* U+064A ARABIC LETTER YEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+064B  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+064C  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+064D  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+064E  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+064F  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0650  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0651  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0652  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0653  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0654  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0655  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0656  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0657  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0658  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0659  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+065A  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+065B  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+065C  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+065D  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+065E  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+065F  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0660  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0661  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0662  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0663  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0664  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0665  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0666  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0667  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0668  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0669  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+066A  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+066B  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+066C  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+066D  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+066E  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+066F  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0670  */
  {0x0000u, 0x0000u, 0xFB51u, 0xFB50u}, /* U+0671 ARABIC LETTER ALEF WASLA */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0672  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0673  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0674  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0675  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0676  */
  {0x0000u, 0x0000u, 0x0000u, 0xFBDDu}, /* U+0677 ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0678  */
  {0xFB68u, 0xFB69u, 0xFB67u, 0xFB66u}, /* U+0679 ARABIC LETTER TTEH */
  {0xFB60u, 0xFB61u, 0xFB5Fu, 0xFB5Eu}, /* U+067A ARABIC LETTER TTEHEH */
  {0xFB54u, 0xFB55u, 0xFB53u, 0xFB52u}, /* U+067B ARABIC LETTER BEEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+067C  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+067D  */
  {0xFB58u, 0xFB59u, 0xFB57u, 0xFB56u}, /* U+067E ARABIC LETTER PEH */
  {0xFB64u, 0xFB65u, 0xFB63u, 0xFB62u}, /* U+067F ARABIC LETTER TEHEH */
  {0xFB5Cu, 0xFB5Du, 0xFB5Bu, 0xFB5Au}, /* U+0680 ARABIC LETTER BEHEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0681  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0682  */
  {0xFB78u, 0xFB79u, 0xFB77u, 0xFB76u}, /* U+0683 ARABIC LETTER NYEH */
  {0xFB74u, 0xFB75u, 0xFB73u, 0xFB72u}, /* U+0684 ARABIC LETTER DYEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0685  */
  {0xFB7Cu, 0xFB7Du, 0xFB7Bu, 0xFB7Au}, /* U+0686 ARABIC LETTER TCHEH */
  {0xFB80u, 0xFB81u, 0xFB7Fu, 0xFB7Eu}, /* U+0687 ARABIC LETTER TCHEHEH */
  {0x0000u, 0x0000u, 0xFB89u, 0xFB88u}, /* U+0688 ARABIC LETTER DDAL */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0689  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+068A  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+068B  */
  {0x0000u, 0x0000u, 0xFB85u, 0xFB84u}, /* U+068C ARABIC LETTER DAHAL */
  {0x0000u, 0x0000u, 0xFB83u, 0xFB82u}, /* U+068D ARABIC LETTER DDAHAL */
  {0x0000u, 0x0000u, 0xFB87u, 0xFB86u}, /* U+068E ARABIC LETTER DUL */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+068F  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0690  */
  {0x0000u, 0x0000u, 0xFB8Du, 0xFB8Cu}, /* U+0691 ARABIC LETTER RREH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0692  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0693  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0694  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0695  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0696  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0697  */
  {0x0000u, 0x0000u, 0xFB8Bu, 0xFB8Au}, /* U+0698 ARABIC LETTER JEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+0699  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+069A  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+069B  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+069C  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+069D  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+069E  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+069F  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06A0  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06A1  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06A2  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06A3  */
  {0xFB6Cu, 0xFB6Du, 0xFB6Bu, 0xFB6Au}, /* U+06A4 ARABIC LETTER VEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06A5  */
  {0xFB70u, 0xFB71u, 0xFB6Fu, 0xFB6Eu}, /* U+06A6 ARABIC LETTER PEHEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06A7  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06A8  */
  {0xFB90u, 0xFB91u, 0xFB8Fu, 0xFB8Eu}, /* U+06A9 ARABIC LETTER KEHEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06AA  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06AB  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06AC  */
  {0xFBD5u, 0xFBD6u, 0xFBD4u, 0xFBD3u}, /* U+06AD ARABIC LETTER NG */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06AE  */
  {0xFB94u, 0xFB95u, 0xFB93u, 0xFB92u}, /* U+06AF ARABIC LETTER GAF */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B0  */
  {0xFB9Cu, 0xFB9Du, 0xFB9Bu, 0xFB9Au}, /* U+06B1 ARABIC LETTER NGOEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B2  */
  {0xFB98u, 0xFB99u, 0xFB97u, 0xFB96u}, /* U+06B3 ARABIC LETTER GUEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B4  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B5  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B6  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B7  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B8  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06B9  */
  {0x0000u, 0x0000u, 0xFB9Fu, 0xFB9Eu}, /* U+06BA ARABIC LETTER NOON GHUNNA */
  {0xFBA2u, 0xFBA3u, 0xFBA1u, 0xFBA0u}, /* U+06BB ARABIC LETTER RNOON */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06BC  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06BD  */
  {0xFBACu, 0xFBADu, 0xFBABu, 0xFBAAu}, /* U+06BE ARABIC LETTER HEH DOACHASHMEE */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06BF  */
  {0x0000u, 0x0000u, 0xFBA5u, 0xFBA4u}, /* U+06C0 ARABIC LETTER HEH WITH YEH ABOVE */
  {0xFBA8u, 0xFBA9u, 0xFBA7u, 0xFBA6u}, /* U+06C1 ARABIC LETTER HEH GOAL */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06C2  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06C3  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06C4  */
  {0x0000u, 0x0000u, 0xFBE1u, 0xFBE0u}, /* U+06C5 ARABIC LETTER KIRGHIZ OE */
  {0x0000u, 0x0000u, 0xFBDAu, 0xFBD9u}, /* U+06C6 ARABIC LETTER OE */
  {0x0000u, 0x0000u, 0xFBD8u, 0xFBD7u}, /* U+06C7 ARABIC LETTER U */
  {0x0000u, 0x0000u, 0xFBDCu, 0xFBDBu}, /* U+06C8 ARABIC LETTER YU */
  {0x0000u, 0x0000u, 0xFBE3u, 0xFBE2u}, /* U+06C9 ARABIC LETTER KIRGHIZ YU */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06CA  */
  {0x0000u, 0x0000u, 0xFBDFu, 0xFBDEu}, /* U+06CB ARABIC LETTER VE */
  {0xFBFEu, 0xFBFFu, 0xFBFDu, 0xFBFCu}, /* U+06CC ARABIC LETTER FARSI YEH */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06CD  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06CE  */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06CF  */
  {0xFBE6u, 0xFBE7u, 0xFBE5u, 0xFBE4u}, /* U+06D0 ARABIC LETTER E */
  {0x0000u, 0x0000u, 0x0000u, 0x0000u}, /* U+06D1  */
  {0x0000u, 0x0000u, 0xFBAFu, 0xFBAEu}, /* U+06D2 ARABIC LETTER YEH BARREE */
  {0x0000u, 0x0000u, 0xFBB1u, 0xFBB0u}, /* U+06D3 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE */
};

#define SHAPING_TABLE_FIRST     0x0621u
#define SHAPING_TABLE_LAST      0x06D3u


static const struct ligature_set_t {
 uint16_t first;
 struct ligature_pairs_t {
   uint16_t components[1];
   uint16_t ligature;
 } ligatures[14];
} ligature_table[] =
{
  { 0xFE91u, {
    { {0xFEE2u}, 0xFC08u }, /* ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM */
    { {0xFEE4u}, 0xFC9Fu }, /* ARABIC LIGATURE BEH WITH MEEM INITIAL FORM */
    { {0xFEA0u}, 0xFC9Cu }, /* ARABIC LIGATURE BEH WITH JEEM INITIAL FORM */
    { {0xFEA4u}, 0xFC9Du }, /* ARABIC LIGATURE BEH WITH HAH INITIAL FORM */
    { {0xFEA8u}, 0xFC9Eu }, /* ARABIC LIGATURE BEH WITH KHAH INITIAL FORM */
  }},
  { 0xFE92u, {
    { {0xFEAEu}, 0xFC6Au }, /* ARABIC LIGATURE BEH WITH REH FINAL FORM */
    { {0xFEE6u}, 0xFC6Du }, /* ARABIC LIGATURE BEH WITH NOON FINAL FORM */
    { {0xFEF2u}, 0xFC6Fu }, /* ARABIC LIGATURE BEH WITH YEH FINAL FORM */
  }},
  { 0xFE97u, {
    { {0xFEE2u}, 0xFC0Eu }, /* ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM */
    { {0xFEE4u}, 0xFCA4u }, /* ARABIC LIGATURE TEH WITH MEEM INITIAL FORM */
    { {0xFEA0u}, 0xFCA1u }, /* ARABIC LIGATURE TEH WITH JEEM INITIAL FORM */
    { {0xFEA4u}, 0xFCA2u }, /* ARABIC LIGATURE TEH WITH HAH INITIAL FORM */
    { {0xFEA8u}, 0xFCA3u }, /* ARABIC LIGATURE TEH WITH KHAH INITIAL FORM */
  }},
  { 0xFE98u, {
    { {0xFEAEu}, 0xFC70u }, /* ARABIC LIGATURE TEH WITH REH FINAL FORM */
    { {0xFEE6u}, 0xFC73u }, /* ARABIC LIGATURE TEH WITH NOON FINAL FORM */
    { {0xFEF2u}, 0xFC75u }, /* ARABIC LIGATURE TEH WITH YEH FINAL FORM */
  }},
  { 0xFE9Bu, {
    { {0xFEE2u}, 0xFC12u }, /* ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM */
  }},
  { 0xFE9Fu, {
    { {0xFEE4u}, 0xFCA8u }, /* ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM */
  }},
  { 0xFEA3u, {
    { {0xFEE4u}, 0xFCAAu }, /* ARABIC LIGATURE HAH WITH MEEM INITIAL FORM */
  }},
  { 0xFEA7u, {
    { {0xFEE4u}, 0xFCACu }, /* ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM */
  }},
  { 0xFEB3u, {
    { {0xFEE4u}, 0xFCB0u }, /* ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM */
  }},
  { 0xFEB7u, {
    { {0xFEE4u}, 0xFD30u }, /* ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM */
  }},
  { 0xFED3u, {
    { {0xFEF2u}, 0xFC32u }, /* ARABIC LIGATURE FEH WITH YEH ISOLATED FORM */
  }},
  { 0xFEDFu, {
    { {0xFE9Eu}, 0xFC3Fu }, /* ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM */
    { {0xFEA0u}, 0xFCC9u }, /* ARABIC LIGATURE LAM WITH JEEM INITIAL FORM */
    { {0xFEA2u}, 0xFC40u }, /* ARABIC LIGATURE LAM WITH HAH ISOLATED FORM */
    { {0xFEA4u}, 0xFCCAu }, /* ARABIC LIGATURE LAM WITH HAH INITIAL FORM */
    { {0xFEA6u}, 0xFC41u }, /* ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM */
    { {0xFEA8u}, 0xFCCBu }, /* ARABIC LIGATURE LAM WITH KHAH INITIAL FORM */
    { {0xFEE2u}, 0xFC42u }, /* ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM */
    { {0xFEE4u}, 0xFCCCu }, /* ARABIC LIGATURE LAM WITH MEEM INITIAL FORM */
    { {0xFEF2u}, 0xFC44u }, /* ARABIC LIGATURE LAM WITH YEH ISOLATED FORM */
    { {0xFEECu}, 0xFCCDu }, /* ARABIC LIGATURE LAM WITH HEH INITIAL FORM */
    { {0xFE82u}, 0xFEF5u }, /* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM */
    { {0xFE84u}, 0xFEF7u }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM */
    { {0xFE88u}, 0xFEF9u }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM */
    { {0xFE8Eu}, 0xFEFBu }, /* ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM */
  }},
  { 0xFEE0u, {
    { {0xFEF0u}, 0xFC86u }, /* ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM */
    { {0xFE82u}, 0xFEF6u }, /* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM */
    { {0xFE84u}, 0xFEF8u }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM */
    { {0xFE88u}, 0xFEFAu }, /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM */
    { {0xFE8Eu}, 0xFEFCu }, /* ARABIC LIGATURE LAM WITH ALEF FINAL FORM */
  }},
  { 0xFEE3u, {
    { {0xFEA0u}, 0xFCCEu }, /* ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM */
    { {0xFEA4u}, 0xFCCFu }, /* ARABIC LIGATURE MEEM WITH HAH INITIAL FORM */
    { {0xFEA8u}, 0xFCD0u }, /* ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM */
    { {0xFEE4u}, 0xFCD1u }, /* ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM */
  }},
  { 0xFEE7u, {
    { {0xFEE2u}, 0xFC4Eu }, /* ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM */
    { {0xFEE4u}, 0xFCD5u }, /* ARABIC LIGATURE NOON WITH MEEM INITIAL FORM */
    { {0xFEA0u}, 0xFCD2u }, /* ARABIC LIGATURE NOON WITH JEEM INITIAL FORM */
    { {0xFEA4u}, 0xFCD3u }, /* ARABIC LIGATURE NOON WITH HAH INITIAL FORM */
  }},
  { 0xFEE8u, {
    { {0xFEF2u}, 0xFC8Fu }, /* ARABIC LIGATURE NOON WITH YEH FINAL FORM */
  }},
  { 0xFEF3u, {
    { {0xFEA0u}, 0xFCDAu }, /* ARABIC LIGATURE YEH WITH JEEM INITIAL FORM */
    { {0xFEA4u}, 0xFCDBu }, /* ARABIC LIGATURE YEH WITH HAH INITIAL FORM */
    { {0xFEA8u}, 0xFCDCu }, /* ARABIC LIGATURE YEH WITH KHAH INITIAL FORM */
    { {0xFEE4u}, 0xFCDDu }, /* ARABIC LIGATURE YEH WITH MEEM INITIAL FORM */
  }},
  { 0xFEF4u, {
    { {0xFEAEu}, 0xFC91u }, /* ARABIC LIGATURE YEH WITH REH FINAL FORM */
    { {0xFEE6u}, 0xFC94u }, /* ARABIC LIGATURE YEH WITH NOON FINAL FORM */
  }},
};


static const struct ligature_mark_set_t {
 uint16_t first;
 struct ligature_pairs_t {
   uint16_t components[1];
   uint16_t ligature;
 } ligatures[5];
} ligature_mark_table[] =
{
  { 0x0651u, {
    { {0x064Cu}, 0xFC5Eu }, /* ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM */
    { {0x064Eu}, 0xFC60u }, /* ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM */
    { {0x064Fu}, 0xFC61u }, /* ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM */
    { {0x0650u}, 0xFC62u }, /* ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM */
    { {0x064Bu}, 0xF2EEu }, /* PUA ARABIC LIGATURE SHADDA WITH FATHATAN ISOLATED FORM */
  }},
};


static const struct ligature_3_set_t {
 uint16_t first;
 struct ligature_triplets_t {
   uint16_t components[2];
   uint16_t ligature;
 } ligatures[3];
} ligature_3_table[] =
{
  { 0xFEDFu, {
    { {0xFEE4u, 0xFEA4u}, 0xFD88u}, /* ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM */
    { {0xFEE0u, 0xFEEAu}, 0xF201u}, /* PUA ARABIC LIGATURE LELLAH ISOLATED FORM */
    { {0xFEE4u, 0xFEA0u}, 0xF211u}, /* PUA ARABIC LIGATURE LAM WITH MEEM WITH JEEM INITIAL FORM */
  }},
};


#endif /* HB_OT_SHAPER_ARABIC_TABLE_HH */

/* == End of generated table == */
