/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ColorWrap_p.h"

#include <GTLCore/wrappers/Allocate.h>
#include <GTLCore/AbstractColorConverter.h>
#include <GTLCore/ColorConverters.h>
#include <GTLCore/Debug.h>
#include <GTLCore/Type.h>

void wrapColor(ColorWrap& color, float red, float green, float blue, float opacity)
{
  color.red = red;
  color.green = green;
  color.blue = blue;
  color.opacity = opacity;
}

GTLCore::Color colorWrapToGTLCoreColor(const ColorWrap& wrap)
{
  return GTLCore::Color(wrap.red, wrap.green, wrap.blue, wrap.opacity);
}

extern "C" {
  void wrapConvertPixelToColor(const GTLCore::AbstractColorConverter* _acc, const float* _pixel, GTLCore::RgbaF* _rgba, gtl_int32 _nbChannels)
  {
    if(not _acc) _acc = GTLCore::ColorConverters::instance()->guess(GTLCore::Type::Float32, _nbChannels);
    GTL_ASSERT(_acc);
    _acc->vectorToRgba(_pixel, _rgba);
  }
  void wrapConvertColorToPixel(const GTLCore::AbstractColorConverter* _acc, const GTLCore::RgbaF* _rgba, float* _pixel, gtl_int32 _nbChannels)
  {
    _acc = GTLCore::ColorConverters::instance()->guess(GTLCore::Type::Float32, _nbChannels);
    GTL_ASSERT(_acc);
    _acc->rgbaToVector(_rgba, _pixel);
  }
}
