// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepTools_WireExplorer_HeaderFile
#define _BRepTools_WireExplorer_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopTools_DataMapOfShapeListOfShape.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopoDS_Face.hxx>
#include <TopTools_MapOfShape.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
#include <TopAbs_Orientation.hxx>
class Standard_DomainError;
class Standard_NoSuchObject;
class Standard_NoMoreObject;
class TopoDS_Wire;
class TopoDS_Face;
class TopoDS_Edge;
class TopoDS_Vertex;


//! The WireExplorer is a tool to explore the edges of
//! a wire in a connection order.
//!
//! i.e. each edge is connected to the previous one by
//! its origin.
//! If a wire is not closed returns only a segment of edges which
//! length depends on started in exploration edge. If wire has
//! singularities (for example, loops) WireExplorer can return not all
//! edges in a wire. it depends on type of singularity.
class BRepTools_WireExplorer 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs an empty explorer (which can be initialized using Init)
  Standard_EXPORT BRepTools_WireExplorer();
  
  //! IInitializes an exploration  of the wire <W>.
  Standard_EXPORT BRepTools_WireExplorer(const TopoDS_Wire& W);
  
  //! Initializes an exploration  of the wire <W>.
  //! F is used to select the edge connected to the
  //! previous in the parametric representation of <F>.
  Standard_EXPORT BRepTools_WireExplorer(const TopoDS_Wire& W, const TopoDS_Face& F);
  
  //! Initializes an exploration of the wire <W>.
  Standard_EXPORT   void Init (const TopoDS_Wire& W) ;
  
  //! Initializes an exploration of the wire <W>.
  //! F is used to select the edge connected to the
  //! previous in the parametric representation of <F>.
  Standard_EXPORT   void Init (const TopoDS_Wire& W, const TopoDS_Face& F) ;
  
  //! Returns True if there  is a current  edge.
  Standard_EXPORT   Standard_Boolean More()  const;
  
  //! Proceeds to the next edge.
  Standard_EXPORT   void Next() ;
  
  //! Returns the current edge.
  Standard_EXPORT  const  TopoDS_Edge& Current()  const;
  
  //! Returns an Orientation for the current edge.
  Standard_EXPORT   TopAbs_Orientation Orientation()  const;
  
  //! Returns the vertex connecting the current  edge to
  //! the previous one.
  Standard_EXPORT  const  TopoDS_Vertex& CurrentVertex()  const;
  
  //! Clears the content of the explorer.
  Standard_EXPORT   void Clear() ;




protected:





private:



  TopTools_DataMapOfShapeListOfShape myMap;
  TopoDS_Edge myEdge;
  TopoDS_Vertex myVertex;
  TopoDS_Face myFace;
  TopTools_MapOfShape myDoubles;
  Standard_Boolean myReverse;
  Standard_Real myTolU;
  Standard_Real myTolV;


};







#endif // _BRepTools_WireExplorer_HeaderFile
