/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.Comparable;
import org.apache.turbine.util.QuickSort;

public class JobQueue
implements Comparable {
    private Vector queue = new Vector(10);

    public JobEntry getNext() {
        if (this.queue.size() > 0) {
            return (JobEntry)this.queue.elementAt(0);
        }
        return null;
    }

    public JobEntry getJob(JobEntry je) {
        int index = -1;
        if (je != null) {
            index = this.queue.indexOf(je);
        }
        if (index < 0) {
            return null;
        }
        return (JobEntry)this.queue.elementAt(index);
    }

    public Vector list() {
        if (this.queue != null && this.queue.size() > 0) {
            return (Vector)this.queue.clone();
        }
        return null;
    }

    public synchronized void add(JobEntry je) {
        this.queue.addElement(je);
        this.sortQueue();
    }

    public synchronized void batchLoad(List jobEntries) {
        if (jobEntries != null) {
            this.queue.addAll(jobEntries);
            this.sortQueue();
        }
    }

    public synchronized void remove(JobEntry je) {
        this.queue.removeElement(je);
        this.sortQueue();
    }

    public synchronized void modify(JobEntry je) {
        this.sortQueue();
    }

    public synchronized void updateQueue(JobEntry je) throws Exception {
        je.calcRunTime();
        this.sortQueue();
    }

    private void sortQueue() {
        Object[] data = new Object[this.queue.size()];
        this.queue.copyInto(data);
        QuickSort.quickSort(data, 0, data.length - 1, this);
        this.queue.removeAllElements();
        int i = 0;
        while (i < data.length) {
            this.queue.add(data[i]);
            ++i;
        }
    }

    public int compare(Object je1, Object je2) {
        long obj2Time;
        long obj1Time = ((JobEntry)je1).getNextRuntime();
        if (obj1Time > (obj2Time = ((JobEntry)je2).getNextRuntime())) {
            return 1;
        }
        if (obj1Time < obj2Time) {
            return -1;
        }
        return 0;
    }
}

