/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.DigestNotification;
import com.sourceforge.knecs.dsm.resourceobject.IDigestService;
import com.sourceforge.knecs.dsm.resourceobject.IUserService;
import com.sourceforge.knecs.dsm.resourceobject.RISConnection;
import com.sourceforge.knecs.dsm.resourceobject.RISConnectionFactory;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.dsm.resourceobject.User;
import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import com.sourceforge.knecs.util.xml.SimpleTransformer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class RISDigester
implements IDigestService {
    private Logger mLogger = LoggerUtils.getLogger(this);
    private String mMailHost;
    private String mSender;
    private RISConnection mRIS = null;
    private String mUser;
    private String mPassword;
    private IUserService mUserService = null;
    private static final String DIGEST_CN = "com.sourceforge.knecs.dsm.resourceobject.DigestNotification";

    public RISDigester(String mailhost, String sender, String user, String password, IUserService userservice) {
        this.setMailHost(mailhost);
        this.setSender(sender);
        this.mUserService = userservice;
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String pop = props.getProperty("portalobjects");
        this.mUser = user;
        this.mPassword = password;
        try {
            this.mRIS = RISConnectionFactory.getRISConnection(svr + pop);
            this.mRIS.connect(user, password);
        }
        catch (RISException ex) {
            this.mLogger.severe("Unable to connect to RIS Service at " + svr + pop);
        }
    }

    public void setMailHost(String host) {
        this.mMailHost = host;
    }

    public String getMailHost() {
        return this.mMailHost;
    }

    public String getSender() {
        return this.mSender;
    }

    public void setSender(String sender) {
        this.mSender = sender;
    }

    public void startDigester(int hour, int day, boolean now) {
        DigestThread digestthread = new DigestThread(hour, day);
        if (now) {
            digestthread.setInitialTimeout(1000L);
        }
        digestthread.start();
    }

    public void notify(String to, String subject, String body) throws Exception {
        this.mLogger.info("Sending email notification: \n\t " + to + "\n\t " + subject);
        this.sendMessage(this.mMailHost, this.mSender, to, subject, body);
        this.mLogger.info("Email sent successfully.");
    }

    public void addNotification(DigestNotification obj) throws IOException {
        block8: {
            this.mLogger.info("addNotification " + obj.getId());
            try {
                String period = obj.getPeriod();
                this.mLogger.info("Processing notification " + period);
                if (period.equals("IMMEDIATE") || period.equals("ONE_TIME")) {
                    Vector<DigestNotification> curvec = new Vector<DigestNotification>();
                    curvec.add(obj);
                    String body = this.aggregateNotifications(curvec);
                    try {
                        String[] recipients = obj.getRecipients();
                        for (int idx = 0; idx < recipients.length; ++idx) {
                            String email = this.uidToEmail(recipients[idx]);
                            if (email == null) continue;
                            this.notify(email, obj.getSubject(), body);
                        }
                        break block8;
                    }
                    catch (IOException ex) {
                        this.mLogger.info("Error from RISDigest.notify() " + ex.getMessage());
                        break block8;
                    }
                    catch (Exception otherex) {
                        this.mLogger.info("Error sending mail" + otherex.getMessage());
                        break block8;
                    }
                }
                this.mLogger.info("Saving digest " + obj.toString());
                this.mRIS.save(obj);
                this.mLogger.info("Done saving digest " + obj.toString());
            }
            catch (RISException risex) {
                this.mLogger.severe("Unable to save notification " + risex.getMessage());
                throw new IOException(risex.getMessage());
            }
            catch (Exception ex) {
                this.mLogger.severe("Unable to send email " + ex.getMessage() + LoggerUtils.getStackTrace(ex));
                throw new IOException(ex.getMessage());
            }
        }
    }

    public void removeNotification(DigestNotification obj) throws IOException {
        try {
            this.mRIS.remove(obj);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove notification " + risex.getMessage());
        }
    }

    public DigestNotification[] getObjects(String period) throws IOException {
        this.mLogger.info("queryNotification " + period);
        DigestNotification[] ret = null;
        try {
            QueryPredicate qp = new QueryPredicate(new NSProperty("http://purl.oclc.org/NET/cmcs/internal/schema/:notify-interval"), period, "==", true);
            ResourceObject[] tmp = this.mRIS.getResourceObjects(Class.forName(DIGEST_CN), qp);
            if (tmp != null && tmp.length > 0) {
                ret = new DigestNotification[tmp.length];
                for (int idx = 0; idx < tmp.length; ++idx) {
                    ret[idx] = (DigestNotification)tmp[idx];
                }
            } else {
                ret = new DigestNotification[]{};
            }
        }
        catch (ClassNotFoundException ex) {
            this.mLogger.severe("Unable to locate Class for com.sourceforge.knecs.dsm.resourceobject.DigestNotification");
            throw new IOException(ex.getMessage());
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to query for notifications " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return ret;
    }

    public void doDigestProcessing(String interval) {
        this.mLogger.info("\nPerforming digest" + new Date().toString());
        String subject = this.generateSubject(interval);
        DigestNotification[] nots = null;
        try {
            nots = this.getObjects(interval);
            this.mLogger.info("\nGot " + nots.length + " objects of " + interval);
        }
        catch (IOException ex) {
            this.mLogger.info("Error with RISDigest " + ex.getMessage());
        }
        if (nots != null) {
            Hashtable<String, Vector<DigestNotification>> bydest = new Hashtable<String, Vector<DigestNotification>>();
            String[] recipients = null;
            Vector curvec = null;
            for (int idx = 0; idx < nots.length; ++idx) {
                recipients = nots[idx].getRecipients();
                for (int jdx = 0; jdx < recipients.length; ++jdx) {
                    String email = this.uidToEmail(recipients[jdx]);
                    if (email == null) continue;
                    curvec = (Vector)bydest.get(email);
                    if (curvec == null) {
                        curvec = new Vector();
                        bydest.put(email, curvec);
                    }
                    curvec.add(nots[idx]);
                }
            }
            Enumeration tokeys = bydest.keys();
            HashSet<DigestNotification> removeSet = new HashSet<DigestNotification>();
            while (tokeys.hasMoreElements()) {
                String to = (String)tokeys.nextElement();
                curvec = (Vector)bydest.get(to);
                String body = this.aggregateNotifications(curvec);
                try {
                    this.notify(to, subject, new String(body));
                    for (int idx = 0; idx < curvec.size(); ++idx) {
                        removeSet.add((DigestNotification)curvec.elementAt(idx));
                    }
                }
                catch (Exception otherex) {
                    this.mLogger.severe("Error sending mail" + otherex.getMessage());
                }
            }
            Iterator it = removeSet.iterator();
            this.mLogger.info("Removing Digest Notifications: #=" + removeSet.size());
            while (it.hasNext()) {
                try {
                    this.removeNotification((DigestNotification)it.next());
                }
                catch (IOException iox) {
                    this.mLogger.severe("Error removing digest:" + iox.getMessage());
                }
            }
        }
    }

    private String uidToEmail(String uid) {
        String ret = null;
        try {
            User user = this.mUserService.getUser(uid);
            if (user != null) {
                ret = user.getEmail();
            } else {
                this.mLogger.info("User " + uid + " can't be resolved.");
            }
        }
        catch (IOException ex) {
            this.mLogger.severe("Error getting user " + ex.getMessage());
        }
        return ret;
    }

    private String uidToDisplayName(String uid) {
        String ret = uid;
        try {
            User user = this.mUserService.getUser(uid);
            if (user != null) {
                ret = user.getFirstName() + " " + user.getLastName();
            } else {
                this.mLogger.info("User " + uid + " can't be resolved.");
            }
        }
        catch (IOException ex) {
            this.mLogger.severe("Error getting user " + ex.getMessage());
        }
        return ret;
    }

    public String aggregateNotifications(Vector curvec) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String xmlHeader = "<?xml version=\"1.0\"?>";
        StringBuffer data = new StringBuffer();
        data.append(xmlHeader + "\n");
        data.append("<Notifications>\n");
        data.append("<imagepath>");
        data.append(props.getProperty("samserver"));
        data.append(props.getProperty("nedimages"));
        data.append("</imagepath>\n");
        data.append("<portalpath>");
        data.append(props.getProperty("portalserver") + "/portal");
        data.append("</portalpath>\n");
        for (int idx = 0; idx < curvec.size(); ++idx) {
            DigestNotification obj = (DigestNotification)curvec.elementAt(idx);
            String producer = obj.getProducer();
            if (producer != null) {
                obj.setProducer(this.uidToDisplayName(producer));
            }
            data.append(obj.toXML());
            obj.setProducer(producer);
        }
        data.append("</Notifications>\n");
        this.mLogger.info("Notificaion xml is" + new String(data));
        SimpleTransformer st = new SimpleTransformer();
        String result = "";
        try {
            result = st.transform("digest.xsl", new String(data));
        }
        catch (Exception ex) {
            this.mLogger.severe("Digest transformation error:" + ex.toString());
        }
        return result;
    }

    private String generateSubject(String interval) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String portal_title = props.getProperty("portaltitle");
        String subject = portal_title + " Daily Subscription";
        if (interval.equals("WEEKLY")) {
            subject = portal_title + " Weekly Subscription";
        }
        return subject;
    }

    public void sendMessage(String host, String fromAddress, String toAddress, String subject, String body) throws AddressException, SendFailedException, MessagingException {
        Properties p = System.getProperties();
        p.put("mail.host", host);
        MimeMessage message = new MimeMessage(Session.getInstance(p, null));
        message.setFrom(new InternetAddress(fromAddress));
        message.setRecipient(Message.RecipientType.TO, new InternetAddress(toAddress));
        message.setSubject(subject);
        message.setContent(body, "text/html");
        message.setSentDate(new Date());
        Transport.send(message);
    }

    private class DigestThread
    extends Thread {
        private int mDigestHour = 22;
        private int mDigestDay = 6;
        private long mInitialTimeout = -1L;

        public DigestThread(int digesthour, int day) {
            this.mDigestHour = digesthour;
            this.mDigestDay = day;
        }

        public void setInitialTimeout(long mills) {
            this.mInitialTimeout = mills;
        }

        private long computeMillsToHour(int targetHour) {
            long secondsPerHour = 3600L;
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            int min = calendar.get(12);
            int sec = calendar.get(13);
            RISDigester.this.mLogger.fine("\nCurtime: " + hour + " " + " " + min + " " + sec);
            int hours = 0;
            if (targetHour >= hour) {
                hours = targetHour - hour;
            } else {
                hours = 24 - hour;
                hours += targetHour;
            }
            int minutes = 60 - min;
            int seconds = 60 - sec;
            if (min > 0 || sec > 0) {
                --hours;
            }
            if (sec > 0) {
                --minutes;
            }
            RISDigester.this.mLogger.fine("\ncomputed: " + hour + " " + hours + " " + minutes + " " + seconds);
            long sleepInterval = 1000L * ((long)hours * secondsPerHour + (long)(minutes * 60) + (long)seconds);
            RISDigester.this.mLogger.fine("\nInitial sleep interval: " + sleepInterval);
            return sleepInterval;
        }

        public void run() {
            RISDigester.this.mLogger.info("\nDigestThread running");
            long sleepInterval = this.computeMillsToHour(this.mDigestHour);
            long sleepInterval24Hour = 86400000L;
            while (true) {
                try {
                    while (true) {
                        if (this.mInitialTimeout > 0L) {
                            RISDigester.this.mLogger.info("\nInitial timeout: " + this.mInitialTimeout);
                            this.join(this.mInitialTimeout);
                        } else {
                            RISDigester.this.mLogger.info("\nSleep interval: " + sleepInterval);
                            this.join(sleepInterval);
                        }
                        RISDigester.this.mLogger.info("\nDigestThread firing..." + new Date().getTime());
                        long start = new Date().getTime();
                        RISDigester.this.doDigestProcessing("DAILY");
                        Calendar calendar = Calendar.getInstance();
                        if (calendar.get(7) == this.mDigestDay) {
                            RISDigester.this.doDigestProcessing("WEEKLY");
                        }
                        long end = new Date().getTime();
                        if (this.mInitialTimeout >= 0L) {
                            this.mInitialTimeout = -1L;
                            sleepInterval = this.computeMillsToHour(this.mDigestHour);
                        } else {
                            sleepInterval = sleepInterval24Hour - (end - start);
                        }
                        RISDigester.this.mLogger.info("\nDigestThread processing(s): " + (end - start) / 1000L);
                        RISDigester.this.mLogger.info("\nRescheduled for(ms) : " + sleepInterval);
                    }
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }
    }
}

