/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.webservices.clientproxy;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

public class ClientInvocationHandler
implements Runnable {
    public static final String CID_NS = "http://cmcs.org";
    public static final String CID = "CorrelationId";
    protected String mEndPointUrl;
    protected String mNamespace;
    protected String mOperationName;
    protected Object[] mArgs;
    protected QName mReturnType;
    protected Object mReturnObject = null;

    public ClientInvocationHandler(String endPoint, String namespace, String operation, Object[] args, QName returnType) {
        this.mEndPointUrl = endPoint;
        this.mNamespace = namespace;
        this.mOperationName = operation;
        this.mArgs = args;
        this.mReturnType = returnType;
    }

    public Logger getLogger() {
        return Logger.getLogger(this.getClass().getPackage().getName());
    }

    public String getClientACT() {
        return null;
    }

    public Call constructCall() throws AxisFault {
        this.getLogger().info("ClientInvocationHandler.constructCall");
        this.getLogger().info("TEST");
        Call call = null;
        try {
            this.getLogger().info("ClientInvocationHandler.create service");
            Service service = new Service();
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(this.mEndPointUrl);
            call.setOperationName(new QName(this.mNamespace, this.mOperationName));
            this.getLogger().info("ClientInvocationHandler.set args");
            for (int idx = 0; idx < this.mArgs.length; ++idx) {
                if (this.mArgs[idx] instanceof String) {
                    call.addParameter("arg" + idx, XMLType.XSD_STRING, ParameterMode.IN);
                    continue;
                }
                if (this.mArgs[idx] instanceof Integer) {
                    call.addParameter("arg" + idx, XMLType.XSD_INTEGER, ParameterMode.IN);
                    continue;
                }
                if (this.mArgs[idx] instanceof Double) {
                    call.addParameter("arg" + idx, XMLType.XSD_DOUBLE, ParameterMode.IN);
                    continue;
                }
                Class<?> c = this.mArgs[idx].getClass();
                if (c.isArray()) {
                    call.addParameter("arg" + idx, XMLType.SOAP_ARRAY, ParameterMode.IN);
                    continue;
                }
                this.getLogger().severe("parameter type not implemented" + c.getName());
            }
            if (this.mReturnType != null) {
                call.setReturnType(this.mReturnType);
            }
        }
        catch (ServiceException createex) {
            throw AxisFault.makeFault(createex);
        }
        this.getLogger().info("End ClientInvocationHandler.constructCall");
        return call;
    }

    public Object invoke() throws AxisFault {
        try {
            this.mReturnObject = null;
            Call call = this.constructCall();
            System.out.println("doint invoke");
            this.mReturnObject = call.invoke(this.mArgs);
        }
        catch (Exception ex) {
            throw AxisFault.makeFault(ex);
        }
        return this.mReturnObject;
    }

    public void run() {
        try {
            Object ret = this.invoke();
            this.getLogger().info("invoke returned" + ret);
        }
        catch (Exception ex) {
            this.getLogger().warning("Error invoking web service" + ex.getMessage());
        }
    }

    public Object getReturnObject() {
        return this.mReturnObject;
    }
}

