/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db;

import com.workingdogs.village.QueryDataSet;
import java.util.Vector;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.pool.DBConnection;

public class LargeSelect
implements Runnable {
    public static final String DEFAULT_NAME = "default.large.select";
    private int miniblock;
    private int memoryLimit;
    private String name;
    private int blockBegin = 0;
    private int blockEnd;
    private int currentlyFilledTo = -1;
    private String query;
    private String dbName;
    private DBConnection db = null;
    private QueryDataSet qds = null;
    private Vector results = null;
    private Thread thread = null;
    private boolean killThread = false;
    private int position;

    private void init(String name, Criteria criteria, int memoryLimit) throws Exception {
        this.memoryLimit = memoryLimit;
        this.name = name;
        this.query = BasePeer.createQueryString(criteria);
        this.dbName = criteria.getDbName();
        this.blockEnd = this.blockBegin + memoryLimit - 1;
        this.startQuery(this.miniblock);
    }

    public Vector getNextResults() throws Exception {
        return this.getResults(this.position, this.miniblock);
    }

    public Vector getPreviousResults() throws Exception {
        return this.getResults(this.position - 2 * this.miniblock, this.miniblock);
    }

    public Vector getResults(int start) throws Exception {
        return this.getResults(start, this.miniblock);
    }

    public synchronized Vector getResults(int start, int size) throws Exception {
        if (size > this.memoryLimit) {
            throw new Exception("Memory limit does not permit a range this large.");
        }
        if (start >= this.blockBegin && start + size - 1 < this.blockEnd) {
            while (start + size - 1 > this.currentlyFilledTo) {
                Thread.currentThread();
                Thread.sleep(500L);
            }
        } else if (start < this.blockBegin && start >= 0) {
            this.stopQuery();
            if (this.memoryLimit >= 2 * size) {
                this.blockBegin = start - size;
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
            } else {
                this.blockBegin = start;
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
            }
        } else if (start + size - 1 >= this.blockEnd) {
            this.stopQuery();
            this.blockBegin = start;
            this.blockEnd = this.blockBegin + this.memoryLimit - 1;
            this.startQuery(size);
        } else {
            throw new Exception("parameter configuration not accounted for");
        }
        Vector returnResults = new Vector(size);
        int i = start - this.blockBegin;
        while (i < start - this.blockBegin + size) {
            returnResults.addElement(this.results.elementAt(i));
            ++i;
        }
        this.position = start + size;
        return returnResults;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block15: {
            size = this.miniblock;
            this.db = TurbineDB.getConnection(this.dbName);
            connection = this.db.getConnection();
            this.qds = new QueryDataSet(connection, this.query);
            if (true) ** GOTO lbl18
            do {
                if (this.currentlyFilledTo + size > this.blockEnd) {
                    size = this.blockEnd - this.currentlyFilledTo;
                }
                tempResults = BasePeer.getSelectResults(this.qds, size, false);
                i = 0;
                while (i < tempResults.size()) {
                    this.results.addElement(tempResults.elementAt(i));
                    ++i;
                }
                this.currentlyFilledTo += this.miniblock;
lbl18:
                // 2 sources

                if (this.killThread || this.qds.allRecordsRetrieved()) break;
            } while (this.currentlyFilledTo + size <= this.blockEnd);
            var3_8 = null;
            try {
                if (this.qds != null) {
                    this.qds.close();
                }
                TurbineDB.releaseConnection(this.db);
            }
            catch (Exception e) {
                Log.error(e);
            }
            break block15;
            {
                catch (Exception e) {
                    Log.error(e);
                    var3_9 = null;
                    try {
                        if (this.qds != null) {
                            this.qds.close();
                        }
                        TurbineDB.releaseConnection(this.db);
                    }
                    catch (Exception e) {
                        Log.error(e);
                    }
                }
            }
            catch (Throwable var2_11) {
                var3_10 = null;
                try {
                    if (this.qds != null) {
                        this.qds.close();
                    }
                    TurbineDB.releaseConnection(this.db);
                }
                catch (Exception e) {
                    Log.error(e);
                }
                throw var2_11;
            }
        }
    }

    private void startQuery(int initialSize) throws Exception {
        this.miniblock = initialSize;
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void stopQuery() throws Exception {
        this.killThread = true;
        while (this.thread.isAlive()) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        this.killThread = false;
    }

    public LargeSelect(Criteria criteria, int memoryLimit) throws Exception {
        this.miniblock = Math.min(100, memoryLimit / 100 + 1);
        this.name = DEFAULT_NAME;
        this.init(this.name, criteria, memoryLimit);
    }

    public LargeSelect(String name, Criteria criteria, int memoryLimit) throws Exception {
        this.miniblock = Math.min(100, memoryLimit / 100);
        this.init(name, criteria, memoryLimit);
    }

    public LargeSelect(Criteria criteria, int memoryLimit, int pageSize) throws Exception {
        this.miniblock = pageSize;
        this.name = DEFAULT_NAME;
        this.init(this.name, criteria, memoryLimit);
    }

    public LargeSelect(String name, Criteria criteria, int memoryLimit, int pageSize) throws Exception {
        this.miniblock = pageSize;
        this.init(name, criteria, memoryLimit);
    }
}

