/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.localization.LocaleDetector;
import org.apache.turbine.services.localization.LocalizationService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class TurbineLocalizationService
extends TurbineBaseService
implements LocalizationService {
    private static Hashtable bundles = null;
    private static String defaultBundle = null;

    public void init() throws InitializationException {
        bundles = new Hashtable();
        defaultBundle = TurbineResources.getString("locale.default.bundle");
        this.setInit(true);
    }

    public ResourceBundle getBundle() {
        return this.getBundle(defaultBundle);
    }

    public ResourceBundle getBundle(String bundleName) {
        String language = TurbineResources.getString("locale.default.language", "en").trim();
        String country = TurbineResources.getString("locale.default.country", "US").trim();
        return this.getBundle(bundleName, new Locale(language, country));
    }

    public ResourceBundle getBundle(String bundleName, String languageHeader) {
        return this.getBundle(bundleName, LocaleDetector.getLocale(languageHeader));
    }

    public ResourceBundle getBundle(RunData data) {
        Locale locale = LocaleDetector.getLocale(data);
        if (locale == null) {
            return this.getBundle();
        }
        return this.getBundle(defaultBundle, locale);
    }

    public ResourceBundle getBundle(String bundleName, RunData data) {
        Locale locale = LocaleDetector.getLocale(data);
        if (locale == null) {
            return this.getBundle(bundleName);
        }
        return this.getBundle(bundleName, locale);
    }

    public ResourceBundle getBundle(String bundleName, Locale locale) {
        if (bundles.containsKey(bundleName = bundleName.trim())) {
            Hashtable locales = (Hashtable)bundles.get(bundleName);
            if (locales.containsKey(locale)) {
                return (ResourceBundle)locales.get(locale);
            }
            ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
            locales.put(rb.getLocale(), rb);
            return rb;
        }
        ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
        Hashtable<Locale, ResourceBundle> ht = new Hashtable<Locale, ResourceBundle>();
        ht.put(locale, rb);
        bundles.put(bundleName, ht);
        return rb;
    }

    public void setBundle(String defaultBundle) {
        TurbineLocalizationService.defaultBundle = defaultBundle;
    }
}

