/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var fifo = require( './../lib' );

var queue;
var iter;
var len;
var v;
var i;

// Create a new FIFO queue:
queue = fifo();

// Add some values to the queue:
queue.push( 'foo' );
queue.push( 'bar' );
queue.push( 'beep' );
queue.push( 'boop' );

// Peek at the first and last queue values:
v = queue.first();
console.log( 'First: %s', v );

v = queue.last();
console.log( 'Last: %s', v );

// Inspect the queue length:
len = queue.length;
console.log( 'Queue length: %d', len );

// Remove the "oldest" queue value:
v = queue.pop();
console.log( 'Removed value: %s', v );

// Inspect the queue length:
len = queue.length;
console.log( 'Queue length: %d', len );

// Iterate over the queue:
iter = queue.iterator();
for ( i = 0; i < len; i++ ) {
	console.log( 'Queue value #%d: %s', i+1, iter.next().value );
}

// Clear the queue:
queue.clear();

// Inspect the queue length:
len = queue.length;
console.log( 'Queue length: %d', len );
