/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var tape = require( 'tape' );
var proxyquire = require( 'proxyquire' );
var PATH_SEP_POSIX = require( './../../../path/sep-posix' );
var PATH_SEP_WIN32 = require( './../../../path/sep-win32' );
var PATH_SEP = require( './../lib' );


// TESTS //

tape( 'main export is a string', function test( t ) {
	t.ok( true, __filename );
	t.equal( typeof PATH_SEP, 'string', 'main export is a string' );
	t.end();
});

tape( 'if platform is POSIX, export is the POSIX path separator', function test( t ) {
	var PATH_SEP = proxyquire( './../lib', {
		'@stdlib/assert/is-windows': false
	});
	t.equal( PATH_SEP, PATH_SEP_POSIX, 'equals POSIX separator' );
	t.end();
});

tape( 'if platform is Windows, export is the Windows path separator', function test( t ) {
	var PATH_SEP = proxyquire( './../lib', {
		'@stdlib/assert/is-windows': true
	});
	t.equal( PATH_SEP, PATH_SEP_WIN32, 'equals Windows separator' );
	t.end();
});
