/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Base 10 logarithm of Euler's number.
*
* @module @stdlib/constants/float64/log10-e
* @type {number}
*
* @example
* var LOG10E = require( '@stdlib/constants/float64/log10-e' );
* // returns 0.4342944819032518
*/


// MAIN //

/**
* Base 10 logarithm of Euler's number.
*
* @constant
* @type {number}
* @default 0.4342944819032518
* @see [OEIS]{@link https://oeis.org/A001113}
* @see [Wikipedia]{@link https://en.wikipedia.org/wiki/E_%27mathematical_constant%28}
*/
var LOG10E = 4.34294481903251827651128918916605082294397005803666566114453783165864649208870774729224949338431748318706106745e-01; // eslint-disable-line max-len


// EXPORTS //

module.exports = LOG10E;
