/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public final class TimeValue
extends CalendarValue
implements Comparable {
    private byte hour;
    private byte minute;
    private byte second;
    private int microsecond;

    private TimeValue() {
    }

    public TimeValue(byte hour, byte minute, byte second, int microsecond, int tz) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microsecond = microsecond;
        this.setTimezoneInMinutes(tz);
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    public TimeValue(GregorianCalendar calendar, int tz) {
        this.hour = (byte)calendar.get(11);
        this.minute = (byte)calendar.get(12);
        this.second = (byte)calendar.get(13);
        this.microsecond = calendar.get(14) * 1000;
        this.setTimezoneInMinutes(tz);
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    public static ConversionResult makeTimeValue(CharSequence s) {
        TimeValue tv = new TimeValue();
        StringTokenizer tok = new StringTokenizer(((Object)Whitespace.trimWhitespace(s)).toString(), "-:.+Z", true);
        if (!tok.hasMoreElements()) {
            return TimeValue.badTime("too short", s);
        }
        String part = (String)tok.nextElement();
        if (part.length() != 2) {
            return TimeValue.badTime("hour must be two digits", s);
        }
        int value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return TimeValue.badTime("Non-numeric hour component", s);
        }
        tv.hour = (byte)value;
        if (tv.hour > 24) {
            return TimeValue.badTime("hour is out of range", s);
        }
        if (!tok.hasMoreElements()) {
            return TimeValue.badTime("too short", s);
        }
        if (!":".equals(tok.nextElement())) {
            return TimeValue.badTime("wrong delimiter after hour", s);
        }
        if (!tok.hasMoreElements()) {
            return TimeValue.badTime("too short", s);
        }
        part = (String)tok.nextElement();
        if (part.length() != 2) {
            return TimeValue.badTime("minute must be two digits", s);
        }
        value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return TimeValue.badTime("Non-numeric minute component", s);
        }
        tv.minute = (byte)value;
        if (tv.minute > 59) {
            return TimeValue.badTime("minute is out of range", s);
        }
        if (tv.hour == 24 && tv.minute != 0) {
            return TimeValue.badTime("If hour is 24, minute must be 00", s);
        }
        if (!tok.hasMoreElements()) {
            return TimeValue.badTime("too short", s);
        }
        if (!":".equals(tok.nextElement())) {
            return TimeValue.badTime("wrong delimiter after minute", s);
        }
        if (!tok.hasMoreElements()) {
            return TimeValue.badTime("too short", s);
        }
        part = (String)tok.nextElement();
        if (part.length() != 2) {
            return TimeValue.badTime("second must be two digits", s);
        }
        value = DurationValue.simpleInteger(part);
        if (value < 0) {
            return TimeValue.badTime("Non-numeric second component", s);
        }
        tv.second = (byte)value;
        if (tv.second > 59) {
            return TimeValue.badTime("second is out of range", s);
        }
        if (tv.hour == 24 && tv.second != 0) {
            return TimeValue.badTime("If hour is 24, second must be 00", s);
        }
        int tz = 0;
        int state = 0;
        while (tok.hasMoreElements()) {
            if (state == 9) {
                return TimeValue.badTime("characters after the end", s);
            }
            String delim = (String)tok.nextElement();
            if (".".equals(delim)) {
                if (state != 0) {
                    return TimeValue.badTime("decimal separator occurs twice", s);
                }
                if (!tok.hasMoreElements()) {
                    return TimeValue.badTime("decimal point must be followed by digits", s);
                }
                part = (String)tok.nextElement();
                value = DurationValue.simpleInteger(part);
                if (value < 0) {
                    return TimeValue.badTime("Non-numeric fractional seconds component", s);
                }
                double fractionalSeconds = Double.parseDouble('.' + part);
                tv.microsecond = (int)Math.round(fractionalSeconds * 1000000.0);
                if (tv.hour == 24 && tv.microsecond != 0) {
                    return TimeValue.badTime("If hour is 24, fractional seconds must be 0", s);
                }
                state = 1;
                continue;
            }
            if ("Z".equals(delim)) {
                if (state > 1) {
                    return TimeValue.badTime("Z cannot occur here", s);
                }
                tz = 0;
                state = 9;
                tv.setTimezoneInMinutes(0);
                continue;
            }
            if ("+".equals(delim) || "-".equals(delim)) {
                if (state > 1) {
                    return TimeValue.badTime(delim + " cannot occur here", s);
                }
                state = 2;
                if (!tok.hasMoreElements()) {
                    return TimeValue.badTime("missing timezone", s);
                }
                part = (String)tok.nextElement();
                if (part.length() != 2) {
                    return TimeValue.badTime("timezone hour must be two digits", s);
                }
                value = DurationValue.simpleInteger(part);
                if (value < 0) {
                    return TimeValue.badTime("Non-numeric timezone hour component", s);
                }
                tz = value * 60;
                if (tz > 840) {
                    return TimeValue.badTime("timezone hour is out of range", s);
                }
                if (!"-".equals(delim)) continue;
                tz = -tz;
                continue;
            }
            if (":".equals(delim)) {
                if (state != 2) {
                    return TimeValue.badTime("colon cannot occur here", s);
                }
                state = 9;
                part = (String)tok.nextElement();
                value = DurationValue.simpleInteger(part);
                if (value < 0) {
                    return TimeValue.badTime("Non-numeric timezone minute component", s);
                }
                int tzminute = value;
                if (part.length() != 2) {
                    return TimeValue.badTime("timezone minute must be two digits", s);
                }
                if (tzminute > 59) {
                    return TimeValue.badTime("timezone minute is out of range", s);
                }
                if (tz < 0) {
                    tzminute = -tzminute;
                }
                tv.setTimezoneInMinutes(tz += tzminute);
                continue;
            }
            return TimeValue.badTime("timezone format is incorrect", s);
        }
        if (state == 2 || state == 3) {
            return TimeValue.badTime("timezone incomplete", s);
        }
        if (tv.hour == 24) {
            tv.hour = 0;
        }
        tv.typeLabel = BuiltInAtomicType.TIME;
        return tv;
    }

    private static ValidationFailure badTime(String msg, CharSequence value) {
        ValidationFailure err = new ValidationFailure("Invalid time " + Err.wrap(value, 4) + " (" + msg + ")");
        err.setErrorCode("FORG0001");
        return err;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.TIME;
    }

    public byte getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        return this.microsecond;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 520: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert time to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer sb = new FastStringBuffer(16);
        TimeValue.appendTwoDigits(sb, this.hour);
        sb.append(':');
        TimeValue.appendTwoDigits(sb, this.minute);
        sb.append(':');
        TimeValue.appendTwoDigits(sb, this.second);
        if (this.microsecond != 0) {
            sb.append('.');
            int ms = this.microsecond;
            int div = 100000;
            while (ms > 0) {
                int d = ms / div;
                sb.append((char)(d + 48));
                ms %= div;
                div /= 10;
            }
        }
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb;
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        if (this.hasTimezone() && this.getTimezoneInMinutes() != 0) {
            return this.adjustTimezone(0).getStringValueCS();
        }
        return this.getStringValueCS();
    }

    public DateTimeValue toDateTime() {
        return new DateTimeValue(1972, 12, 31, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
    }

    public GregorianCalendar getCalendar() {
        int tz = this.hasTimezone() ? this.getTimezoneInMinutes() : 0;
        SimpleTimeZone zone = new SimpleTimeZone(tz * 60000, "LLL");
        GregorianCalendar calendar = new GregorianCalendar(zone);
        calendar.setLenient(false);
        int year = 1972;
        int month = 11;
        int day = 31;
        calendar.set(year, month, day, this.hour, this.minute, this.second);
        calendar.set(14, this.microsecond / 1000);
        calendar.set(15, tz * 60000);
        calendar.set(16, 0);
        calendar.getTime();
        return calendar;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        TimeValue v = new TimeValue(this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
        v.typeLabel = typeLabel;
        return v;
    }

    public CalendarValue adjustTimezone(int timezone) {
        DateTimeValue dt = (DateTimeValue)this.toDateTime().adjustTimezone(timezone);
        return new TimeValue(dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMicrosecond(), dt.getTimezoneInMinutes());
    }

    public AtomicValue getComponent(int component) throws XPathException {
        switch (component) {
            case 4: {
                return Int64Value.makeIntegerValue(this.hour);
            }
            case 5: {
                return Int64Value.makeIntegerValue(this.minute);
            }
            case 6: {
                BigDecimal d = BigDecimal.valueOf(this.microsecond);
                d = d.divide(DecimalValue.BIG_DECIMAL_ONE_MILLION, 6, 4);
                d = d.add(BigDecimal.valueOf(this.second));
                return new DecimalValue(d);
            }
            case 12: {
                return Int64Value.makeIntegerValue(this.second);
            }
            case 11: {
                return new Int64Value(this.microsecond);
            }
            case 7: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(this.getTimezoneInMinutes() * 60000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for time: " + component);
    }

    public int compareTo(Object other) {
        TimeValue otherTime = (TimeValue)other;
        if (this.getTimezoneInMinutes() == otherTime.getTimezoneInMinutes()) {
            if (this.hour != otherTime.hour) {
                return IntegerValue.signum(this.hour - otherTime.hour);
            }
            if (this.minute != otherTime.minute) {
                return IntegerValue.signum(this.minute - otherTime.minute);
            }
            if (this.second != otherTime.second) {
                return IntegerValue.signum(this.second - otherTime.second);
            }
            if (this.microsecond != otherTime.microsecond) {
                return IntegerValue.signum(this.microsecond - otherTime.microsecond);
            }
            return 0;
        }
        return this.toDateTime().compareTo(otherTime.toDateTime());
    }

    public int compareTo(CalendarValue other, XPathContext context) throws NoDynamicContextException {
        if (!(other instanceof TimeValue)) {
            throw new ClassCastException("Time values are not comparable to " + other.getClass());
        }
        TimeValue otherTime = (TimeValue)other;
        if (this.getTimezoneInMinutes() == otherTime.getTimezoneInMinutes()) {
            return this.compareTo(other);
        }
        return this.toDateTime().compareTo(otherTime.toDateTime(), context);
    }

    public Comparable getSchemaComparable() {
        return new TimeComparable();
    }

    public ComparisonKey getComparisonKey(XPathContext context) throws NoDynamicContextException {
        return new ComparisonKey(520, this.toDateTime().normalize(context));
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return DateTimeValue.hashCode(1951, (byte)10, (byte)11, this.hour, this.minute, this.second, this.microsecond, this.getTimezoneInMinutes());
    }

    public CalendarValue add(DurationValue duration) throws XPathException {
        if (duration instanceof DayTimeDurationValue) {
            DateTimeValue dt = (DateTimeValue)this.toDateTime().add(duration);
            return new TimeValue(dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMicrosecond(), this.getTimezoneInMinutes());
        }
        XPathException err = new XPathException("Time+Duration arithmetic is supported only for xs:dayTimeDuration");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public DayTimeDurationValue subtract(CalendarValue other, XPathContext context) throws XPathException {
        if (!(other instanceof TimeValue)) {
            XPathException err = new XPathException("First operand of '-' is a time, but the second is not");
            err.setIsTypeError(true);
            throw err;
        }
        return super.subtract(other, context);
    }

    private class TimeComparable
    implements Comparable {
        private TimeComparable() {
        }

        public TimeValue asTimeValue() {
            return TimeValue.this;
        }

        public int compareTo(Object o) {
            if (o instanceof TimeComparable) {
                DateTimeValue dt0 = this.asTimeValue().toDateTime();
                DateTimeValue dt1 = ((TimeComparable)o).asTimeValue().toDateTime();
                return dt0.getSchemaComparable().compareTo(dt1.getSchemaComparable());
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return TimeValue.this.toDateTime().getSchemaComparable().hashCode();
        }
    }
}

