/* This is part of the netCDF package. Copyright 2005-2918 University
   Corporation for Atmospheric Research/Unidata See COPYRIGHT file for
   conditions of use.

   This program benchmarks creating a netCDF file with many objects.

   Ed Hartnett
*/

#include <config.h>
#include <nc_tests.h>
#include "err_macros.h"
#include <netcdf.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h> /* Extra high precision time info. */

/* We will create this file. */
#define FILE_NAME "bm_many_atts.nc"

/* Prototype from tst_utils.c. */
int nc4_timeval_subtract(struct timeval *result, struct timeval *x,
                         struct timeval *y);

int main(int argc, char **argv)
{
    struct timeval start_time, end_time, diff_time;
    double sec;
    int nitem = 1000;		/* default number of objects of each type */
    int i;
    int ncid;
    int data[] = {42};
    int g, grp, numgrp;
    char gname[16];
    int a, numatt, an, aleft, natts;

    if(argc > 2) { 	/* Usage */
	printf("NetCDF performance test, writing many groups, variables, and attributes.\n");
	printf("Usage:\t%s [N]\n", argv[0]);
	printf("\tN: number of objects\n");
	return(0);
    }
    for(i = 1; i < argc; i++) {
	nitem = atoi(argv[i]);
    }

    /*  create new file */
    if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;
    /* create N group/global attributes, printing time after every 100.
     * Because only NC_MAX_ATTRS are permitted per group, create the
     * necessary number of groups to hold nitem attributes. */
    numatt = nitem;
    a = 1;
    numgrp = (numatt - 1) / NC_MAX_ATTRS + 1;
    aleft = numatt - (NC_MAX_ATTRS * (numgrp - 1));
    if (gettimeofday(&start_time, NULL))
	ERR;

    for(g = 1; g < numgrp + 1; g++) {
	sprintf(gname, "group%d", g);
	if (nc_def_grp(ncid, gname, &grp)) ERR;
	natts = g < numgrp ? NC_MAX_ATTRS : aleft; /* leftovers on last time through */
	for(an = 1; an < natts + 1; an++) {
	    char aname[20];
	    sprintf(aname, "attribute%d", a);
	    if (nc_put_att_int(grp, NC_GLOBAL, aname, NC_INT, 1, data)) ERR;
	    if(a%100 == 0) {		/* only print every 100th attribute name */
		if (gettimeofday(&end_time, NULL)) ERR;
		if (nc4_timeval_subtract(&diff_time, &end_time, &start_time)) ERR;
		sec = diff_time.tv_sec + 1.0e-6 * diff_time.tv_usec;
		printf("%s/%s\t%.3g sec\n", gname, aname, sec);
	    }
	    a++;
	}
    }
    nc_close(ncid);
    FINAL_RESULTS;
}
