/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2013 Sun Microsystems, Inc.
 */

package org.netbeans.modules.team.ide;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXMonthView;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/**
 *
 * @author Ondrej Vrabec
 */
public final class JXDatePickerImpl extends javax.swing.JPanel implements IDEServices.DatePickerComponent,
        PropertyChangeListener {
    private final ChangeSupport support;

    /**
     * Creates new form DatePickerImpl
     */
    public JXDatePickerImpl () {
        this.support = new ChangeSupport(this);
        initComponents();
        datePicker.getEditor().addPropertyChangeListener(this);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        datePicker = new org.jdesktop.swingx.JXDatePicker();

        datePicker.setFormats(new java.text.DateFormat[] { java.text.DateFormat.getDateInstance(java.text.DateFormat.MEDIUM) });
        datePicker.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                datePickerActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(datePicker, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(datePicker, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void datePickerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_datePickerActionPerformed
        support.fireChange();
    }//GEN-LAST:event_datePickerActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.jdesktop.swingx.JXDatePicker datePicker;
    // End of variables declaration//GEN-END:variables

    @Override
    public JComponent getComponent () {
        return this;
    }

    @Override
    public void setDate (Date date) {
        datePicker.setDate(date);
    }

    @Override
    public Date getDate () {
        return datePicker.getDate();
    }

    @Override
    public void addChangeListener (ChangeListener listener) {
        support.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener (ChangeListener listener) {
        support.removeChangeListener(listener);
    }

    @Override
    public void propertyChange (PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName())) { //NOI18N
            if (evt.getOldValue() != null || evt.getNewValue() != null) {
                support.fireChange();
            }
        }
    }

    @Override
    public void setEnabled (boolean enabled) {
        super.setEnabled(enabled);
        datePicker.setEnabled(enabled);
    }

    @Override
    public boolean allowsOpeningDaySelector () {
        return true;
    }

    @Override
    @NbBundle.Messages({
        "LBL_ChooseDate=Choose Date"
    })
    public boolean openDaySelector () {
        JXMonthView monthView = datePicker.getMonthView();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(monthView);
        NotifyDescriptor nd = new NotifyDescriptor(
                panel,
                Bundle.LBL_ChooseDate(),
                NotifyDescriptor.OK_CANCEL_OPTION,
                NotifyDescriptor.PLAIN_MESSAGE,
                null,
                NotifyDescriptor.OK_OPTION);
        if (DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.OK_OPTION) {
            setDate(monthView.getSelectionDate());
            return true;
        } else {
            return false;
        }
    }
}
