/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.smarty.editor.utlis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.smarty.editor.lexer.TplTokenId;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.openide.filesystems.FileObject;

/**
 *
 * @author Martin Fousek
 */
public class EmbeddingUtils {

    public static TokenHierarchy<CharSequence> createTplTokenHierarchy(CharSequence inputText, Snapshot tmplSnapshot) {
        InputAttributes inputAttributes = new InputAttributes();

        FileObject fo = tmplSnapshot.getSource().getFileObject();
        if (fo != null) {
            //try to obtain tmpl coloring info for file based snapshots
            final Document doc = tmplSnapshot.getSource().getDocument(true);

        }

        TokenHierarchy<CharSequence> th = TokenHierarchy.create(
                inputText,
                true,
                TplTokenId.language(),
                Collections.<TplTokenId>emptySet(),
                inputAttributes);

        return th;
    }
}
