# Stubs for statistics

from decimal import Decimal
from fractions import Fraction
import sys
from typing import Iterable, Optional, TypeVar

# Most functions in this module accept homogeneous collections of one of these types
_Number = TypeVar('_Number', float, Decimal, Fraction)

class StatisticsError(ValueError): ...

def mean(data: Iterable[_Number]) -> _Number: ...
if sys.version_info >= (3, 6):
    def harmonic_mean(data: Iterable[_Number]) -> _Number: ...
def median(data: Iterable[_Number]) -> _Number: ...
def median_low(data: Iterable[_Number]) -> _Number: ...
def median_high(data: Iterable[_Number]) -> _Number: ...
def median_grouped(data: Iterable[_Number]) -> _Number: ...
def mode(data: Iterable[_Number]) -> _Number: ...
def pstdev(data: Iterable[_Number], mu: Optional[_Number] = ...) -> _Number: ...
def pvariance(data: Iterable[_Number], mu: Optional[_Number] = ...) -> _Number: ...
def stdev(data: Iterable[_Number], xbar: Optional[_Number] = ...) -> _Number: ...
def variance(data: Iterable[_Number], xbar: Optional[_Number] = ...) -> _Number: ...
