/* MSPDebug - debugging tool for MSP430 MCUs
 * Copyright (C) 2009-2012 Daniel Beer
 * Copyright (C) 2012 Stanimir Bonev
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string.h>
#include <assert.h>

#include "fet_olimex_db.h"
#include "devicelist.h"
#include "util.h"

#define ID0_OFFSET		0
#define ID1_OFFSET		1
#define REV_OFFSET		2
#define FAB_ID_OFFSET		3
#define SELF_TEST0_OFFSET	8
#define SELF_TEST1_OFFSET	9
#define EMB_SYS_OFFSET		13

static const struct fet_olimex_db_record fet_olimex_db[] = {
	[DT_MSP430F11x1] = {
		.name = "Prototype_MSP430F11x1",
		.msg29_params = {0x00, 0x01, 0x01},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0xef,
			0xff, 0xef, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x13, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F11x1D] = {
		.name = "MSP430F11x1",
		.msg29_params = {0x00, 0x02, 0x02},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x13, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F133] = {
		.name = "MSP430F133",
		.msg29_params = {0x00, 0x03, 0x03},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x03, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F135] = {
		.name = "MSP430F135",
		.msg29_params = {0x00, 0x04, 0x04},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x03, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F147] = {
		.name = "MSP430F147",
		.msg29_params = {0x00, 0x05, 0x05},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x03, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F148] = {
		.name = "MSP430F148",
		.msg29_params = {0x00, 0x06, 0x06},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x03, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F149] = {
		.name = "MSP430F149",
		.msg29_params = {0x00, 0x07, 0x07},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x03, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F413P] = {
		.name = "Preliminary_MSP430F413",
		.msg29_params = {0x00, 0x08, 0x08},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0x9c, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x33, 0x80, 0x13, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F41xC] = {
		.name = "MSP430F41x",
		.msg29_params = {0x00, 0x09, 0x09},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0x9c, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x33, 0x80, 0x13, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F11x1A] = {
		.name = "MSP430F11x1A",
		.msg29_params = {0x00, 0x0a, 0x0a},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x13, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F12x] = {
		.name = "MSP430F12x",
		.msg29_params = {0x00, 0x0b, 0x0b},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x03, 0x13, 0x03,
			0xff, 0x03,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F43x] = {
		.name = "MSP430F43x",
		.msg29_params = {0x00, 0x0c, 0x0c},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F44x] = {
		.name = "MSP430F44x",
		.msg29_params = {0x00, 0x0e, 0x0d},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0xb0, 0xd3, 0xb0,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F12x2] = {
		.name = "Preliminary_MSP430F12x2",
		.msg29_params = {0x00, 0x0f, 0x0e},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x03, 0x13, 0x03,
			0xff, 0x03,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F11x2] = {
		.name = "MSP430F11x2",
		.msg29_params = {0x00, 0x10, 0x0f},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x13, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F12x2C] = {
		.name = "MSP430F12x2/F11x2",
		.msg29_params = {0x00, 0x11, 0x10},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x03, 0x13, 0x03,
			0xff, 0x03,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_PMS430F16x] = {
		.name = "Preliminary_MSP430F16x",
		.msg29_params = {0x00, 0x12, 0x11},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x03, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE423] = {
		.name = "MSP430FE423",
		.msg29_params = {0x00, 0x19, 0x12},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE425] = {
		.name = "MSP430FE425",
		.msg29_params = {0x00, 0x1a, 0x13},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE427] = {
		.name = "MSP430FE427",
		.msg29_params = {0x00, 0x1b, 0x14},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F423] = {
		.name = "MSP430F423",
		.msg29_params = {0x00, 0x1c, 0x15},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F425] = {
		.name = "MSP430F425",
		.msg29_params = {0x00, 0x1d, 0x16},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F427] = {
		.name = "MSP430F427",
		.msg29_params = {0x00, 0x1e, 0x17},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FW42x] = {
		.name = "MSP430FW42x/F41x",
		.msg29_params = {0x00, 0x1f, 0x18},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0x9c, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x33, 0x80, 0x13, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4230] = {
		.name = "MSP430F4230",
		.msg29_params = {0x00, 0x20, 0x19},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x33, 0x80, 0x1f, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4250] = {
		.name = "MSP430F4250",
		.msg29_params = {0x00, 0x21, 0x1a},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x33, 0x80, 0x1f, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F42x0] = {
		.name = "MSP430F42x0",
		.msg29_params = {0x00, 0x22, 0x1b},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x33, 0x80, 0x1f, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F155] = {
		.name = "MSP430F155",
		.msg29_params = {0x00, 0x23, 0x1c},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xd3, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F156] = {
		.name = "MSP430F156",
		.msg29_params = {0x00, 0x24, 0x1d},
		.msg29_data = {
			0x00, 0xa0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xd3, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F157] = {
		.name = "MSP430F157",
		.msg29_params = {0x00, 0x25, 0x1e},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xd3, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F167] = {
		.name = "MSP430F167",
		.msg29_params = {0x00, 0x26, 0x1f},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F168] = {
		.name = "MSP430F168",
		.msg29_params = {0x00, 0x27, 0x20},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F169] = {
		.name = "MSP430F169",
		.msg29_params = {0x00, 0x28, 0x21},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F1610] = {
		.name = "MSP430F1610",
		.msg29_params = {0x00, 0x29, 0x22},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x24,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F1611] = {
		.name = "MSP430F1611",
		.msg29_params = {0x00, 0x2a, 0x23},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x38,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F1612] = {
		.name = "MSP430F1612",
		.msg29_params = {0x00, 0x2b, 0x24},
		.msg29_data = {
			0x00, 0x25, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x30, 0xd3, 0x30,
			0xc0, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x24,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG43x] = {
		.name = "MSP430FG43x_F43x",
		.msg29_params = {0x00, 0x2d, 0x25},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0x9c, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG4619] = {
		.name = "MSP430FG4619",
		.msg29_params = {0x00, 0x2e, 0x26},
		.msg29_data = {
			0x00, 0x21, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0x9c, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xbf, 0x13, 0xbf,
			0xff, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F21x1] = {
		.name = "MSP430F21x1",
		.msg29_params = {0x00, 0x2f, 0x27},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x1f, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_TMS430F1390] = {
		.name = "TMS430FCAS001",
		.msg29_params = {0x00, 0x30, 0x28},
		.msg29_data = {
			0x00, 0x10, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0x7f, 0x10, 0x80, 0x00, 0x00, 0x05, 0xff, 0x0c,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x9a, 0x0b, 0x7c, 0x15, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x37, 0x00, 0x17, 0x00,
			0x00, 0x00,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_TMS430F1250] = {
		.name = "TMS430FCAS003",
		.msg29_params = {0x00, 0x31, 0x29},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0x7f, 0x10, 0x80, 0x00, 0x00, 0x05, 0xff, 0x07,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3f, 0x0c, 0x82, 0x14, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x37, 0x00, 0x17, 0x00,
			0x00, 0x00,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_TMS430C1250] = {
		.name = "TMS430ROMSHUTTLE",
		.msg29_params = {0x00, 0x32, 0x2a},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0x7f, 0x10, 0x80, 0x00, 0x00, 0x05, 0xff, 0x07,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x3f, 0x0c, 0x82, 0x14, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x37, 0x00, 0x17, 0x00,
			0x00, 0x00,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_TMS430EMU] = {
		.name = "TMS430EMU",
		.msg29_params = {0x00, 0x33, 0x2b},
		.msg29_data = {
			0x00, 0x10, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0x7f, 0x10, 0x80, 0x00, 0x00, 0x05, 0xff, 0x0c,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x9a, 0x0b, 0x7c, 0x15, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x37, 0x00, 0x17, 0x00,
			0x00, 0x00,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F20x3] = {
		.name = "MSP430F20x3",
		.msg29_params = {0x00, 0x34, 0x2c},
		.msg29_data = {
			0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0x7f, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x1f, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F20x2] = {
		.name = "F20x2_G2x2x_G2x3x",
		.msg29_params = {0x00, 0x35, 0x2d},
		.msg29_data = {
			0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0x7f, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x1f, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F20x1] = {
		.name = "F20x1_G2x0x_G2x1x",
		.msg29_params = {0x00, 0x36, 0x2e},
		.msg29_data = {
			0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0x7f, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x1f, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2234] = {
		.name = "MSP430F2234",
		.msg29_params = {0x00, 0x37, 0x2f},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2254] = {
		.name = "MSP430F2254",
		.msg29_params = {0x00, 0x38, 0x30},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2274] = {
		.name = "MSP430F2274",
		.msg29_params = {0x00, 0x39, 0x31},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG4618] = {
		.name = "MSP430FG4618",
		.msg29_params = {0x00, 0x3a, 0x32},
		.msg29_data = {
			0x00, 0x31, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0x9c, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xbf, 0x13, 0xbf,
			0xff, 0x30,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2330] = {
		.name = "MSP430F2330",
		.msg29_params = {0x00, 0x3b, 0x33},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2350] = {
		.name = "MSP430F2350",
		.msg29_params = {0x00, 0x3c, 0x34},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2370] = {
		.name = "MSP430F2370",
		.msg29_params = {0x00, 0x3d, 0x35},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2232] = {
		.name = "MSP430F2232",
		.msg29_params = {0x00, 0x3e, 0x36},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2252] = {
		.name = "MSP430F2252",
		.msg29_params = {0x00, 0x3f, 0x37},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2272] = {
		.name = "MSP430F2272",
		.msg29_params = {0x00, 0x40, 0x38},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2619] = {
		.name = "MSP430F2619",
		.msg29_params = {0x00, 0x41, 0x39},
		.msg29_data = {
			0x00, 0x21, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2618] = {
		.name = "MSP430F2618",
		.msg29_params = {0x00, 0x42, 0x3a},
		.msg29_data = {
			0x00, 0x31, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2419] = {
		.name = "MSP430F2419",
		.msg29_params = {0x00, 0x43, 0x3b},
		.msg29_data = {
			0x00, 0x21, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2418] = {
		.name = "MSP430F2418",
		.msg29_params = {0x00, 0x44, 0x3c},
		.msg29_data = {
			0x00, 0x31, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE423A] = {
		.name = "MSP430FE423A",
		.msg29_params = {0x00, 0x45, 0x3d},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE425A] = {
		.name = "MSP430FE425A",
		.msg29_params = {0x00, 0x46, 0x3e},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE427A] = {
		.name = "MSP430FE427A",
		.msg29_params = {0x00, 0x47, 0x3f},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F423A] = {
		.name = "MSP430F423A",
		.msg29_params = {0x00, 0x48, 0x40},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F425A] = {
		.name = "MSP430F425A",
		.msg29_params = {0x00, 0x49, 0x41},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F427A] = {
		.name = "MSP430F427A",
		.msg29_params = {0x00, 0x4a, 0x42},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4783] = {
		.name = "MSP430F4783",
		.msg29_params = {0x00, 0x4b, 0x43},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4784] = {
		.name = "MSP430F4784",
		.msg29_params = {0x00, 0x4c, 0x44},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4793] = {
		.name = "MSP430F4793",
		.msg29_params = {0x00, 0x4d, 0x45},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x0b,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4794] = {
		.name = "MSP430F4794",
		.msg29_params = {0x00, 0x4e, 0x46},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x0b,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F249] = {
		.name = "MSP430F249",
		.msg29_params = {0x00, 0x4f, 0x47},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F248] = {
		.name = "MSP430F248",
		.msg29_params = {0x00, 0x50, 0x48},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F247] = {
		.name = "MSP430F247",
		.msg29_params = {0x00, 0x51, 0x49},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F235] = {
		.name = "MSP430F235",
		.msg29_params = {0x00, 0x52, 0x4a},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2491] = {
		.name = "MSP430F2491",
		.msg29_params = {0x00, 0x53, 0x4b},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2481] = {
		.name = "MSP430F2481",
		.msg29_params = {0x00, 0x54, 0x4c},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2471] = {
		.name = "MSP430F2471",
		.msg29_params = {0x00, 0x55, 0x4d},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F233] = {
		.name = "MSP430F233",
		.msg29_params = {0x00, 0x56, 0x4e},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2410] = {
		.name = "MSP430F2410",
		.msg29_params = {0x00, 0x57, 0x4f},
		.msg29_data = {
			0x00, 0x21, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x01, 0x00,
			0x01, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2132] = {
		.name = "MSP430F2132",
		.msg29_params = {0x00, 0x58, 0x50},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2122] = {
		.name = "MSP430F2122",
		.msg29_params = {0x00, 0x59, 0x51},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F2112] = {
		.name = "MSP430F2112",
		.msg29_params = {0x00, 0x5a, 0x52},
		.msg29_data = {
			0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x0f, 0x1f, 0x0f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_XMS430F5438] = {
		.name = "XMS430F5438",
		.msg29_params = {0x00, 0x5b, 0x53},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5438] = {
		.name = "MSP430F5438",
		.msg29_params = {0x00, 0x5c, 0x54},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5436] = {
		.name = "MSP430F5436",
		.msg29_params = {0x00, 0x5d, 0x55},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5419] = {
		.name = "MSP430F5419",
		.msg29_params = {0x00, 0x5e, 0x56},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE4232] = {
		.name = "MSP430FE4232",
		.msg29_params = {0x00, 0x5f, 0x57},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE42x2] = {
		.name = "MSP430FE42x2",
		.msg29_params = {0x00, 0x60, 0x58},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5437] = {
		.name = "MSP430F5437",
		.msg29_params = {0x00, 0x61, 0x59},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5435] = {
		.name = "MSP430F5435",
		.msg29_params = {0x00, 0x62, 0x5a},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5418] = {
		.name = "MSP430F5418",
		.msg29_params = {0x00, 0x63, 0x5b},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG4250] = {
		.name = "MSP430FG4250",
		.msg29_params = {0x00, 0x64, 0x5c},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x33, 0x80, 0x1f, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG42x0] = {
		.name = "MSP430FG42x0",
		.msg29_params = {0x00, 0x65, 0x5d},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x33, 0x80, 0x1f, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FE4272] = {
		.name = "MSP430FE4272",
		.msg29_params = {0x00, 0x66, 0x5e},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x05,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x8c, 0x0a, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0xf3, 0x80, 0xd3, 0x80,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG477] = {
		.name = "MSP430FG477",
		.msg29_params = {0x00, 0x67, 0x5f},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG478] = {
		.name = "MSP430FG478",
		.msg29_params = {0x00, 0x68, 0x60},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FG479] = {
		.name = "MSP430FG479",
		.msg29_params = {0x00, 0x69, 0x61},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F477] = {
		.name = "MSP430F477",
		.msg29_params = {0x00, 0x6a, 0x62},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F478] = {
		.name = "MSP430F478",
		.msg29_params = {0x00, 0x6b, 0x63},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F479] = {
		.name = "MSP430F479",
		.msg29_params = {0x00, 0x6c, 0x64},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47197] = {
		.name = "MSP430F47197",
		.msg29_params = {0x00, 0x6d, 0x65},
		.msg29_data = {
			0x00, 0x21, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47187] = {
		.name = "MSP430F47187",
		.msg29_params = {0x00, 0x6e, 0x66},
		.msg29_data = {
			0x00, 0x31, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47177] = {
		.name = "MSP430F47177",
		.msg29_params = {0x00, 0x6f, 0x67},
		.msg29_data = {
			0x00, 0x31, 0xff, 0x9f, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47167] = {
		.name = "MSP430F47167",
		.msg29_params = {0x00, 0x70, 0x68},
		.msg29_data = {
			0x00, 0x21, 0xff, 0x8f, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47196] = {
		.name = "MSP430F47196",
		.msg29_params = {0x00, 0x71, 0x69},
		.msg29_data = {
			0x00, 0x21, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47186] = {
		.name = "MSP430F47186",
		.msg29_params = {0x00, 0x72, 0x6a},
		.msg29_data = {
			0x00, 0x31, 0xff, 0xff, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47176] = {
		.name = "MSP430F47176",
		.msg29_params = {0x00, 0x73, 0x6b},
		.msg29_data = {
			0x00, 0x31, 0xff, 0x9f, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x30,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F47166] = {
		.name = "MSP430F47166",
		.msg29_params = {0x00, 0x74, 0x6c},
		.msg29_data = {
			0x00, 0x21, 0xff, 0x8f, 0x01, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xa4, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x1f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x02, 0x00,
			0x08, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xff, 0x20,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4152] = {
		.name = "MSP430F4152",
		.msg29_params = {0x00, 0x75, 0x6d},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F4132] = {
		.name = "MSP430F4132",
		.msg29_params = {0x00, 0x76, 0x6e},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x02, 0x00, 0xd7, 0x60, 0x90, 0x00, 0xaf, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0x8c, 0x0a, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x8f, 0x1f, 0x8f,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6137] = {
		.name = "CC430F6137",
		.msg29_params = {0x00, 0x77, 0x6f},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6135] = {
		.name = "CC430F6135",
		.msg29_params = {0x00, 0x78, 0x70},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6127] = {
		.name = "CC430F6127",
		.msg29_params = {0x00, 0x79, 0x71},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6126] = {
		.name = "CC430F6126",
		.msg29_params = {0x00, 0x7a, 0x72},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6125] = {
		.name = "CC430F6125",
		.msg29_params = {0x00, 0x7b, 0x73},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5137] = {
		.name = "CC430F5137",
		.msg29_params = {0x00, 0x7c, 0x74},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5135] = {
		.name = "CC430F5135",
		.msg29_params = {0x00, 0x7d, 0x75},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5133] = {
		.name = "CC430F5133",
		.msg29_params = {0x00, 0x7e, 0x76},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5513] = {
		.name = "MSP430F5513",
		.msg29_params = {0x00, 0x7f, 0x77},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5514] = {
		.name = "MSP430F5514",
		.msg29_params = {0x00, 0x80, 0x78},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5515] = {
		.name = "MSP430F5515",
		.msg29_params = {0x00, 0x81, 0x79},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5517] = {
		.name = "MSP430F5517",
		.msg29_params = {0x00, 0x82, 0x7a},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5519] = {
		.name = "MSP430F5519",
		.msg29_params = {0x00, 0x83, 0x7b},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5521] = {
		.name = "MSP430F5521",
		.msg29_params = {0x00, 0x84, 0x7c},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5522] = {
		.name = "MSP430F5522",
		.msg29_params = {0x00, 0x85, 0x7d},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5524] = {
		.name = "MSP430F5524",
		.msg29_params = {0x00, 0x86, 0x7e},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5525] = {
		.name = "MSP430F5525",
		.msg29_params = {0x00, 0x87, 0x7f},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5526] = {
		.name = "MSP430F5526",
		.msg29_params = {0x00, 0x88, 0x80},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5527] = {
		.name = "MSP430F5527",
		.msg29_params = {0x00, 0x89, 0x81},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5528] = {
		.name = "MSP430F5528",
		.msg29_params = {0x00, 0x8a, 0x82},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5529] = {
		.name = "MSP430F5529",
		.msg29_params = {0x00, 0x8b, 0x83},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5438A] = {
		.name = "MSP430F5438A",
		.msg29_params = {0x00, 0x8c, 0x84},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5436A] = {
		.name = "MSP430F5436A",
		.msg29_params = {0x00, 0x8d, 0x85},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5419A] = {
		.name = "MSP430F5419A",
		.msg29_params = {0x00, 0x8e, 0x86},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5437A] = {
		.name = "MSP430F5437A",
		.msg29_params = {0x00, 0x8f, 0x87},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5435A] = {
		.name = "MSP430F5435A",
		.msg29_params = {0x00, 0x90, 0x88},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5418A] = {
		.name = "MSP430F5418A",
		.msg29_params = {0x00, 0x91, 0x89},
		.msg29_data = {
			0x00, 0x5c, 0xff, 0x5b, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x5b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x9d,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5510] = {
		.name = "MSP430F5510",
		.msg29_params = {0x00, 0x92, 0x8a},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5131] = {
		.name = "MSP430F5131",
		.msg29_params = {0x00, 0x93, 0x8b},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x00, 0x8e, 0x74,
			0x75, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5132] = {
		.name = "MSP430F5132",
		.msg29_params = {0x00, 0x94, 0x8c},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x00, 0x8e, 0x74,
			0x75, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5151] = {
		.name = "MSP430F5151",
		.msg29_params = {0x00, 0x95, 0x8d},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x00, 0x8e, 0x74,
			0x75, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5152] = {
		.name = "MSP430F5152",
		.msg29_params = {0x00, 0x96, 0x8e},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x00, 0x8e, 0x74,
			0x75, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5171] = {
		.name = "MSP430F5171",
		.msg29_params = {0x00, 0x97, 0x8f},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x00, 0x8e, 0x74,
			0x75, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5172] = {
		.name = "MSP430F5172",
		.msg29_params = {0x00, 0x98, 0x90},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x00, 0x8e, 0x74,
			0x75, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5630] = {
		.name = "MSP430F5630",
		.msg29_params = {0x00, 0x99, 0x91},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5631] = {
		.name = "MSP430F5631",
		.msg29_params = {0x00, 0x9a, 0x92},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5632] = {
		.name = "MSP430F5632",
		.msg29_params = {0x00, 0x9b, 0x93},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5633] = {
		.name = "MSP430F5633",
		.msg29_params = {0x00, 0x9c, 0x94},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5634] = {
		.name = "MSP430F5634",
		.msg29_params = {0x00, 0x9d, 0x95},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5635] = {
		.name = "MSP430F5635",
		.msg29_params = {0x00, 0x9e, 0x96},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5636] = {
		.name = "MSP430F5636",
		.msg29_params = {0x00, 0x9f, 0x97},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5637] = {
		.name = "MSP430F5637",
		.msg29_params = {0x00, 0xa0, 0x98},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5638] = {
		.name = "MSP430F5638",
		.msg29_params = {0x00, 0xa1, 0x99},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6630] = {
		.name = "MSP430F6630",
		.msg29_params = {0x00, 0xa2, 0x9a},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6631] = {
		.name = "MSP430F6631",
		.msg29_params = {0x00, 0xa3, 0x9b},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6632] = {
		.name = "MSP430F6632",
		.msg29_params = {0x00, 0xa4, 0x9c},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6633] = {
		.name = "MSP430F6633",
		.msg29_params = {0x00, 0xa5, 0x9d},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6634] = {
		.name = "MSP430F6634",
		.msg29_params = {0x00, 0xa6, 0x9e},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6635] = {
		.name = "MSP430F6635",
		.msg29_params = {0x00, 0xa7, 0x9f},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6636] = {
		.name = "MSP430F6636",
		.msg29_params = {0x00, 0xa8, 0xa0},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6637] = {
		.name = "MSP430F6637",
		.msg29_params = {0x00, 0xa9, 0xa1},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x03, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6638] = {
		.name = "MSP430F6638",
		.msg29_params = {0x00, 0xaa, 0xa2},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5739] = {
		.name = "MSP430FR5739",
		.msg29_params = {0x00, 0xab, 0xa3},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430L092] = {
		.name = "MSP430L092",
		.msg29_params = {0x00, 0xac, 0xa4},
		.msg29_data = {
			0x00, 0x1c, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xff,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00,
			0x02, 0x00, 0x17, 0x04, 0x90, 0x00, 0xaf, 0x00,
			0x84, 0x03, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x02, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0xb5, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6700] = {
		.name = "MSP430F6700",
		.msg29_params = {0x00, 0xad, 0xa5},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6701] = {
		.name = "MSP430F6701",
		.msg29_params = {0x00, 0xae, 0xa6},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6702] = {
		.name = "MSP430F6702",
		.msg29_params = {0x00, 0xaf, 0xa7},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6703] = {
		.name = "MSP430F6703",
		.msg29_params = {0x00, 0xb0, 0xa8},
		.msg29_data = {
			0x00, 0x40, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6720] = {
		.name = "MSP430F6720",
		.msg29_params = {0x00, 0xb1, 0xa9},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6721] = {
		.name = "MSP430F6721",
		.msg29_params = {0x00, 0xb2, 0xaa},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6722] = {
		.name = "MSP430F6722",
		.msg29_params = {0x00, 0xb3, 0xab},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6723] = {
		.name = "MSP430F6723",
		.msg29_params = {0x00, 0xb4, 0xac},
		.msg29_data = {
			0x00, 0x40, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6730] = {
		.name = "MSP430F6730",
		.msg29_params = {0x00, 0xb5, 0xad},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6731] = {
		.name = "MSP430F6731",
		.msg29_params = {0x00, 0xb6, 0xae},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6732] = {
		.name = "MSP430F6732",
		.msg29_params = {0x00, 0xb7, 0xaf},
		.msg29_data = {
			0x00, 0x40, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6733] = {
		.name = "MSP430F6733",
		.msg29_params = {0x00, 0xb8, 0xb0},
		.msg29_data = {
			0x00, 0x40, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5509] = {
		.name = "MSP430F5509",
		.msg29_params = {0x00, 0xb9, 0xb1},
		.msg29_data = {
			0x00, 0xa0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5508] = {
		.name = "MSP430F5508",
		.msg29_params = {0x00, 0xba, 0xb2},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5507] = {
		.name = "MSP430F5507",
		.msg29_params = {0x00, 0xbb, 0xb3},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5506] = {
		.name = "MSP430F5506",
		.msg29_params = {0x00, 0xbc, 0xb4},
		.msg29_data = {
			0x00, 0xa0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5505] = {
		.name = "MSP430F5505",
		.msg29_params = {0x00, 0xbd, 0xb5},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5504] = {
		.name = "MSP430F5504",
		.msg29_params = {0x00, 0xbe, 0xb6},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5503] = {
		.name = "MSP430F5503",
		.msg29_params = {0x00, 0xbf, 0xb7},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5502] = {
		.name = "MSP430F5502",
		.msg29_params = {0x00, 0xc0, 0xb8},
		.msg29_data = {
			0x00, 0xa0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5501] = {
		.name = "MSP430F5501",
		.msg29_params = {0x00, 0xc1, 0xb9},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5500] = {
		.name = "MSP430F5500",
		.msg29_params = {0x00, 0xc2, 0xba},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F12x2New] = {
		.name = "MSP430F12x2/F11x2",
		.msg29_params = {0x00, 0xc3, 0xbb},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x00, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0x03, 0x13, 0x03,
			0xff, 0x03,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5310] = {
		.name = "MSP430F5310",
		.msg29_params = {0x00, 0xc4, 0xbc},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5309] = {
		.name = "MSP430F5309",
		.msg29_params = {0x00, 0xc5, 0xbd},
		.msg29_data = {
			0x00, 0xa0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5308] = {
		.name = "MSP430F5308",
		.msg29_params = {0x00, 0xc6, 0xbe},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5304] = {
		.name = "MSP430F5304",
		.msg29_params = {0x00, 0xc7, 0xbf},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd6,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE253] = {
		.name = "MSP430AFE253",
		.msg29_params = {0x00, 0xc8, 0xc0},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5329] = {
		.name = "MSP430F5329",
		.msg29_params = {0x00, 0xc9, 0xc1},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5328] = {
		.name = "MSP430F5328",
		.msg29_params = {0x00, 0xca, 0xc2},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5327] = {
		.name = "MSP430F5327",
		.msg29_params = {0x00, 0xcb, 0xc3},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5326] = {
		.name = "MSP430F5326",
		.msg29_params = {0x00, 0xcc, 0xc4},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5325] = {
		.name = "MSP430F5325",
		.msg29_params = {0x00, 0xcd, 0xc5},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5324] = {
		.name = "MSP430F5324",
		.msg29_params = {0x00, 0xce, 0xc6},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430G2452] = {
		.name = "MSP430G2xx2",
		.msg29_params = {0x00, 0xcf, 0xc7},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x1f, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5342] = {
		.name = "MSP430F5342",
		.msg29_params = {0x00, 0xd0, 0xc8},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5341] = {
		.name = "MSP430F5341",
		.msg29_params = {0x00, 0xd1, 0xc9},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5340] = {
		.name = "MSP430F5340",
		.msg29_params = {0x00, 0xd2, 0xca},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x33,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FW429] = {
		.name = "MSP430FW429",
		.msg29_params = {0x00, 0xd3, 0xcb},
		.msg29_data = {
			0x00, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x80, 0x00, 0x00, 0x02, 0xff, 0x09,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x90, 0x00, 0x9c, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x33, 0x80, 0x13, 0x80,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6659] = {
		.name = "MSP430F6659",
		.msg29_params = {0x00, 0xd4, 0xcc},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x08, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6658] = {
		.name = "MSP430F6658",
		.msg29_params = {0x00, 0xd5, 0xcd},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x06, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6459] = {
		.name = "MSP430F6459",
		.msg29_params = {0x00, 0xd6, 0xce},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x08, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6458] = {
		.name = "MSP430F6458",
		.msg29_params = {0x00, 0xd7, 0xcf},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x06, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6457] = {
		.name = "MSP430F6457",
		.msg29_params = {0x00, 0xd8, 0xd0},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5659] = {
		.name = "MSP430F5659",
		.msg29_params = {0x00, 0xd9, 0xd1},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x08, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5658] = {
		.name = "MSP430F5658",
		.msg29_params = {0x00, 0xda, 0xd2},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x06, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x40, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5359] = {
		.name = "MSP430F5359",
		.msg29_params = {0x00, 0xdb, 0xd3},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x08, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5358] = {
		.name = "MSP430F5358",
		.msg29_params = {0x00, 0xdc, 0xd4},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x06, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5357] = {
		.name = "MSP430F5357",
		.msg29_params = {0x00, 0xdd, 0xd5},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x00, 0x00, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0xff, 0xff,
			0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430G2553] = {
		.name = "MSP430G2xx3",
		.msg29_params = {0x00, 0xde, 0xd6},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x33, 0xff, 0x1f, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE233] = {
		.name = "MSP430AFE233",
		.msg29_params = {0x00, 0xdf, 0xd7},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE223] = {
		.name = "MSP430AFE223",
		.msg29_params = {0x00, 0xe0, 0xd8},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE252] = {
		.name = "MSP430AFE252",
		.msg29_params = {0x00, 0xe1, 0xd9},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE232] = {
		.name = "MSP430AFE232",
		.msg29_params = {0x00, 0xe2, 0xda},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE222] = {
		.name = "MSP430AFE222",
		.msg29_params = {0x00, 0xe3, 0xdb},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE251] = {
		.name = "MSP430AFE251",
		.msg29_params = {0x00, 0xe4, 0xdc},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE231] = {
		.name = "MSP430AFE231",
		.msg29_params = {0x00, 0xe5, 0xdd},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE221] = {
		.name = "MSP430AFE221",
		.msg29_params = {0x00, 0xe6, 0xde},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE250] = {
		.name = "MSP430AFE250",
		.msg29_params = {0x00, 0xe7, 0xdf},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE230] = {
		.name = "MSP430AFE230",
		.msg29_params = {0x00, 0xe8, 0xe0},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x03,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430AFE220] = {
		.name = "MSP430AFE220",
		.msg29_params = {0x00, 0xe9, 0xe1},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x10,
			0xff, 0x10, 0x40, 0x00, 0x00, 0x02, 0xff, 0x02,
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00,
			0x01, 0x00, 0xd7, 0x60, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xf3, 0xff, 0xdf, 0xff,
			0xc0, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
			0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5229] = {
		.name = "MSP430F5229",
		.msg29_params = {0x00, 0xea, 0xe2},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5738] = {
		.name = "MSP430FR5738",
		.msg29_params = {0x00, 0xeb, 0xe3},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5735] = {
		.name = "MSP430FR5735",
		.msg29_params = {0x00, 0xec, 0xe4},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5730] = {
		.name = "MSP430FR5730",
		.msg29_params = {0x00, 0xed, 0xe5},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1d,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5729] = {
		.name = "MSP430FR5729",
		.msg29_params = {0x00, 0xee, 0xe6},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5728] = {
		.name = "MSP430FR5728",
		.msg29_params = {0x00, 0xef, 0xe7},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5725] = {
		.name = "MSP430FR5725",
		.msg29_params = {0x00, 0xf0, 0xe8},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5720] = {
		.name = "MSP430FR5720",
		.msg29_params = {0x00, 0xf1, 0xe9},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1d,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5969] = {
		.name = "MSP430FR5969",
		.msg29_params = {0x00, 0xf2, 0xea},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x88, 0x8d, 0x8f,
			0x8e, 0x9d, 0x2d, 0x2c, 0x30, 0x00, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6147] = {
		.name = "CC430F6147",
		.msg29_params = {0x00, 0xf3, 0xeb},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6145] = {
		.name = "CC430F6145",
		.msg29_params = {0x00, 0xf4, 0xec},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F6143] = {
		.name = "CC430F6143",
		.msg29_params = {0x00, 0xf5, 0xed},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0xb0, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5147] = {
		.name = "CC430F5147",
		.msg29_params = {0x00, 0xf6, 0xee},
		.msg29_data = {
			0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x2b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5145] = {
		.name = "CC430F5145",
		.msg29_params = {0x00, 0xf7, 0xef},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5143] = {
		.name = "CC430F5143",
		.msg29_params = {0x00, 0xf8, 0xf0},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5125] = {
		.name = "CC430F5125",
		.msg29_params = {0x00, 0xf9, 0xf1},
		.msg29_data = {
			0x00, 0xc0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_CC430F5123] = {
		.name = "CC430F5123",
		.msg29_params = {0x00, 0xfa, 0xf2},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x00,
			0x00, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x60, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6723] = {
		.name = "MSP430F672x",
		.msg29_params = {0x00, 0xfb, 0xac},
		.msg29_data = {
			0x00, 0x40, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x23,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6736] = {
		.name = "MSP430F673x",
		.msg29_params = {0x00, 0xfe, 0xf8},
		.msg29_data = {
			0x00, 0x40, 0xff, 0x3f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x3b,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x07, 0x24, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x01, 0x00,
			0x04, 0x00, 0x20, 0x00, 0x0a, 0x88, 0x8d, 0x8c,
			0x8e, 0x00, 0x2e, 0x2c, 0x2d, 0x30, 0x8a, 0xd6,
			0xd5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5333] = {
		.name = "MSP430F5333",
		.msg29_params = {0x00, 0x101, 0xf9},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5335] = {
		.name = "MSP430F5335",
		.msg29_params = {0x00, 0x102, 0xfa},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5336] = {
		.name = "MSP430F5336",
		.msg29_params = {0x00, 0x103, 0xfb},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5338] = {
		.name = "MSP430F5338",
		.msg29_params = {0x00, 0x104, 0xfc},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6433] = {
		.name = "MSP430F6433",
		.msg29_params = {0x00, 0x105, 0xfd},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6435] = {
		.name = "MSP430F6435",
		.msg29_params = {0x00, 0x106, 0xfe},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6436] = {
		.name = "MSP430F6436",
		.msg29_params = {0x00, 0x107, 0xff},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F6438] = {
		.name = "MSP430F6438",
		.msg29_params = {0x00, 0x108, 0x100},
		.msg29_data = {
			0x00, 0x80, 0xff, 0x7f, 0x04, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x1c, 0xff, 0x63,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x04, 0x02, 0x00,
			0x0a, 0x00, 0x40, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0xc0, 0xb0, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x1c, 0xff, 0x23, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5737] = {
		.name = "MSP430FR5737",
		.msg29_params = {0x00, 0x109, 0x101},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5736] = {
		.name = "MSP430FR5736",
		.msg29_params = {0x00, 0x10a, 0x102},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5734] = {
		.name = "MSP430FR5734",
		.msg29_params = {0x00, 0x10b, 0x103},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5733] = {
		.name = "MSP430FR5733",
		.msg29_params = {0x00, 0x10c, 0x104},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5732] = {
		.name = "MSP430FR5732",
		.msg29_params = {0x00, 0x10d, 0x105},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5731] = {
		.name = "MSP430FR5731",
		.msg29_params = {0x00, 0x10e, 0x106},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1d,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5727] = {
		.name = "MSP430FR5727",
		.msg29_params = {0x00, 0x10f, 0x107},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5726] = {
		.name = "MSP430FR5726",
		.msg29_params = {0x00, 0x110, 0x108},
		.msg29_data = {
			0x00, 0xc2, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5724] = {
		.name = "MSP430FR5724",
		.msg29_params = {0x00, 0x111, 0x109},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5723] = {
		.name = "MSP430FR5723",
		.msg29_params = {0x00, 0x112, 0x10a},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5722] = {
		.name = "MSP430FR5722",
		.msg29_params = {0x00, 0x113, 0x10b},
		.msg29_data = {
			0x00, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x00,
			0x00, 0x97, 0x2c, 0x00, 0x30, 0x00, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430FR5721] = {
		.name = "MSP430FR5721",
		.msg29_params = {0x00, 0x114, 0x10c},
		.msg29_data = {
			0x00, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18,
			0xff, 0x18, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1d,
			0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00,
			0x02, 0x00, 0x0f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
			0x04, 0x00, 0x00, 0x00, 0x0a, 0x8f, 0x8e, 0x99,
			0x98, 0x97, 0x2c, 0x2d, 0x30, 0x00, 0x8a, 0xd6,
			0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5228] = {
		.name = "MSP430F5228",
		.msg29_params = {0x00, 0x115, 0x10d},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5227] = {
		.name = "MSP430F5227",
		.msg29_params = {0x00, 0x116, 0x10e},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5224] = {
		.name = "MSP430F5224",
		.msg29_params = {0x00, 0x117, 0x10f},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5223] = {
		.name = "MSP430F5223",
		.msg29_params = {0x00, 0x118, 0x110},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5222] = {
		.name = "MSP430F5222",
		.msg29_params = {0x00, 0x119, 0x111},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5219] = {
		.name = "MSP430F5219",
		.msg29_params = {0x00, 0x11a, 0x112},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5218] = {
		.name = "MSP430F5218",
		.msg29_params = {0x00, 0x11b, 0x113},
		.msg29_data = {
			0x00, 0x44, 0xff, 0xc3, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5217] = {
		.name = "MSP430F5217",
		.msg29_params = {0x00, 0x11c, 0x114},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x01, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0x00,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_MSP430F5229] = {
		.name = "MSP430F5212/3/4",
		.msg29_params = {0x00, 0x11d, 0xe2},
		.msg29_data = {
			0x00, 0x44, 0xff, 0x43, 0x02, 0x00, 0x00, 0x18,
			0xff, 0x19, 0x80, 0x00, 0x00, 0x24, 0xff, 0x43,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x07, 0x00,
			0x02, 0x00, 0x1f, 0x04, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x07, 0x10, 0x0e, 0xc4, 0x09, 0x70, 0x17,
			0x58, 0x1b, 0x01, 0x00, 0x03, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x10, 0xff, 0x17, 0x00, 0x02, 0x02, 0x00,
			0x0a, 0x00, 0x20, 0x00, 0x0a, 0x91, 0x8e, 0x8f,
			0x9d, 0x00, 0x28, 0x29, 0x2a, 0x2b, 0x8a, 0xd8,
			0xa8, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
	[DT_END] = {
		.name = "End_of_devices",
		.msg29_params = {0x00, 0x120, 0x118},
		.msg29_data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
			0xff, 0xff,
		},
		.msg2b_len = 0x4a,
		.msg2b_data = {
			0x00, 0x0c, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
		},
	},
};

int fet_olimex_db_find_by_name(const char *name)
{
	int i;

	for (i = 1; i < ARRAY_LEN(sdeviceID); i++) {
		const struct device_table *r = &sdeviceID[i];

		if (!strcasecmp(r->name, name))
			return i;
	}

	return -1;
}

int fet_olimex_db_enum(fet_olimex_db_enum_func_t func, void *user_data)
{
	int i;

	for (i = 1; i < ARRAY_LEN(sdeviceID) - 1; i++)
		if (func(user_data, sdeviceID[i].name) < 0)
			return -1;

	return 0;
}

int fet_olimex_db_identify(const uint8_t *data)
{
	uint16_t fuse = LE_WORD(data, 16);
	int i;

	for (i = 1; i < DT_END; i++) {
		if (((0xFF == sdeviceID[i].device_id_param[0]) ||
		     (sdeviceID[i].device_id_param[0] == data[ID0_OFFSET])) &&
		    ((0xFF == sdeviceID[i].device_id_param[1]) ||
		     (sdeviceID[i].device_id_param[1] == data[ID1_OFFSET])) &&
		    ((0xFF == sdeviceID[i].device_id_param[2]) ||
		     (sdeviceID[i].device_id_param[2] == data[REV_OFFSET])) &&
		    ((0xFF == sdeviceID[i].device_id_param[3]) ||
		     (sdeviceID[i].device_id_param[3] == data[FAB_ID_OFFSET])) &&
		    ((0xFF == sdeviceID[i].device_id_param[4]) ||
		     (sdeviceID[i].device_id_param[4] ==
				data[SELF_TEST0_OFFSET])) &&
		    ((0xFF == sdeviceID[i].device_id_param[5]) ||
		     (sdeviceID[i].device_id_param[5] ==
				data[SELF_TEST1_OFFSET])) &&
		    ((0xFF == sdeviceID[i].device_id_param[6]) ||
		     (sdeviceID[i].device_id_param[6] ==
				data[EMB_SYS_OFFSET]))) {
			if (0xFF != sdeviceID[i].device_id_param[7]) {
				if ((sdeviceID[i].device_id_param[7] &
				     sdeviceID[i].device_id_param[8])
				 == (fuse & sdeviceID[i].device_id_param[8]))
				return i;
			} else {
				return i;
			}
		}
	}

	return -1;
}

devicetype_t fet_olimex_db_index_to_type(int indx)
{
	if (indx < 1 || indx >= ARRAY_LEN(sdeviceID) - 1)
		return DT_UNKNOWN_DEVICE;

	return sdeviceID[indx].device_type_id;
}

const struct fet_olimex_db_record *fet_db_get_record(devicetype_t type)
{
	const struct fet_olimex_db_record *rec = &fet_olimex_db[type];

	if (type <= DT_UNKNOWN_DEVICE || type >= DT_END)
		return NULL;

	if (!rec->name)
		return NULL;

	return rec;
}
