/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc.sorting;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndirectSort {
    static int MIN_LENGTH_FOR_QUICKSORT = 15;
    static int MIN_LENGTH_FOR_INSERTION_SORT = 30;
    static int MIN_MED3_SIZE = 30;
    static int MIN_MED9_SIZE = 60;

    private IndirectSort() {
    }

    public static int[] sort(int start, int length, IndirectComparator comparator) {
        int[] order = IndirectSort.createOrderArray(start, length);
        IndirectSort.quickSort(0, length, order, comparator);
        return order;
    }

    public static <T> int[] sort(T[] input, int start, int length, Comparator<? super T> comparator) {
        return IndirectSort.sort(start, length, new IndirectComparator.DelegatingComparator<T>(input, comparator));
    }

    public static int[] mergesort(int start, int length, IndirectComparator comparator) {
        int[] src = IndirectSort.createOrderArray(start, length);
        if (length > 1) {
            int[] dst = (int[])src.clone();
            IndirectSort.topDownMergeSort(src, dst, 0, length, comparator);
            return dst;
        }
        return src;
    }

    public static <T> int[] mergesort(T[] input, int start, int length, Comparator<? super T> comparator) {
        return IndirectSort.mergesort(start, length, new IndirectComparator.DelegatingComparator<T>(input, comparator));
    }

    private static void topDownMergeSort(int[] src, int[] dst, int fromIndex, int toIndex, IndirectComparator comp) {
        if (toIndex - fromIndex <= MIN_LENGTH_FOR_INSERTION_SORT) {
            IndirectSort.insertionSort(fromIndex, toIndex - fromIndex, dst, comp);
            return;
        }
        int mid = fromIndex + toIndex >>> 1;
        IndirectSort.topDownMergeSort(dst, src, fromIndex, mid, comp);
        IndirectSort.topDownMergeSort(dst, src, mid, toIndex, comp);
        if (comp.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, fromIndex, dst, fromIndex, toIndex - fromIndex);
        } else {
            int i = fromIndex;
            int j = mid;
            for (int k = fromIndex; k < toIndex; ++k) {
                dst[k] = j == toIndex || i < mid && comp.compare(src[i], src[j]) <= 0 ? src[i++] : src[j++];
            }
        }
    }

    private static void quickSort(int off, int len, int[] order, IndirectComparator comp) {
        int c;
        int a;
        if (len < MIN_LENGTH_FOR_QUICKSORT) {
            IndirectSort.insertionSort(off, len, order, comp);
            return;
        }
        int m = off + (len >> 1);
        if (len > MIN_MED3_SIZE) {
            int l = off;
            int n = off + len - 1;
            if (len > MIN_MED9_SIZE) {
                int s = len / 8;
                l = IndirectSort.med3(order, l, l + s, l + 2 * s, comp);
                m = IndirectSort.med3(order, m - s, m, m + s, comp);
                n = IndirectSort.med3(order, n - 2 * s, n - s, n, comp);
            }
            m = IndirectSort.med3(order, l, m, n, comp);
        }
        int v = order[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int t;
            if (b <= c && (t = comp.compare(order[b], v)) <= 0) {
                if (t == 0) {
                    IndirectSort.swap(order, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (t = comp.compare(order[c], v)) >= 0) {
                if (t == 0) {
                    IndirectSort.swap(order, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IndirectSort.swap(order, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        IndirectSort.vecswap(order, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        IndirectSort.vecswap(order, b, n - s, s);
        int s1 = b - a;
        int s2 = d - c;
        assert (s1 < len && s2 < len) : "Recursive call must decrease range length, comparator: " + comp;
        if (s1 < s2) {
            if (s1 > 1) {
                IndirectSort.quickSort(off, s1, order, comp);
            }
            if (s2 > 1) {
                IndirectSort.quickSort(n - s2, s2, order, comp);
            }
        } else {
            if (s2 > 1) {
                IndirectSort.quickSort(n - s2, s2, order, comp);
            }
            if (s1 > 1) {
                IndirectSort.quickSort(off, s1, order, comp);
            }
        }
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            IndirectSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void insertionSort(int off, int len, int[] order, IndirectComparator intComparator) {
        for (int i = off + 1; i < off + len; ++i) {
            int t;
            int v = order[i];
            int j = i;
            while (j > off && intComparator.compare(t = order[j - 1], v) > 0) {
                order[j--] = t;
            }
            order[j] = v;
        }
    }

    private static int med3(int[] order, int a, int b, int c, IndirectComparator comp) {
        int va = order[a];
        int vb = order[b];
        int vc = order[c];
        return comp.compare(va, vb) < 0 ? (comp.compare(vb, vc) < 0 ? b : (comp.compare(va, vc) < 0 ? c : a)) : (comp.compare(vb, vc) > 0 ? b : (comp.compare(va, vc) > 0 ? c : a));
    }

    private static final void swap(int[] array, int l, int i) {
        int temp = array[l];
        array[l] = array[i];
        array[i] = temp;
    }

    private static int[] createOrderArray(int start, int length) {
        int[] order = new int[length];
        for (int i = 0; i < length; ++i) {
            order[i] = start + i;
        }
        return order;
    }
}

