/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.Intrinsics;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongObjectAssociativeContainer;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.carrotsearch.hppc.hash.LongHashFunction;
import com.carrotsearch.hppc.hash.LongMurmurHash;
import com.carrotsearch.hppc.hash.ObjectHashFunction;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongObjectProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongObjectOpenHashMap<VType>
implements LongObjectMap<VType> {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public long[] keys;
    public VType[] values;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final LongHashFunction keyHashFunction;
    public final ObjectHashFunction<? super VType> valueHashFunction;
    private KeySet keySetView;

    public LongObjectOpenHashMap() {
        this(16);
    }

    public LongObjectOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongObjectOpenHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new LongMurmurHash());
    }

    public LongObjectOpenHashMap(int initialCapacity, float loadFactor, LongHashFunction keyHashFunction) {
        this(initialCapacity, loadFactor, keyHashFunction, new ObjectHashFunction());
    }

    public LongObjectOpenHashMap(int initialCapacity, float loadFactor, LongHashFunction keyHashFunction, ObjectHashFunction<? super VType> valueHashFunction) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.valueHashFunction = valueHashFunction;
        this.keyHashFunction = keyHashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public LongObjectOpenHashMap(LongObjectAssociativeContainer<VType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public VType put(long key, VType value) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        VType oldValue = this.values[slot];
        this.keys[slot] = key;
        this.values[slot] = value;
        this.states[slot] = 2;
        return oldValue;
    }

    @Override
    public final int putAll(LongObjectAssociativeContainer<VType> container) {
        int count = this.assigned;
        for (LongObjectCursor<VType> c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(long key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndRehash() {
        long[] oldKeys = this.keys;
        VType[] oldValues = this.values;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.values.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.values[slot] = oldValues[i];
            this.states[slot] = 2;
            oldValues[i] = null;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new long[capacity];
        this.values = (Object[])Intrinsics.newVTypeArray(capacity);
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public VType remove(long key) {
        int slot = this.slotFor(key);
        VType value = this.values[slot];
        byte state = this.states[slot];
        if (state == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = 0L;
            this.values[slot] = Intrinsics.defaultVTypeValue();
            this.states[slot] = 1;
        } else assert (Intrinsics.defaultVTypeValue() == value) : "Default value expected.";
        return value;
    }

    @Override
    public final int removeAll(LongContainer container) {
        int before = this.deleted;
        for (LongCursor cursor : container) {
            this.remove(cursor.value);
        }
        return this.deleted - before;
    }

    @Override
    public final int removeAll(LongPredicate predicate) {
        int before = this.deleted;
        long[] keys = this.keys;
        VType[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2 || !predicate.apply(keys[i])) continue;
            ++this.deleted;
            --this.assigned;
            keys[i] = 0L;
            values[i] = Intrinsics.defaultVTypeValue();
            states[i] = 1;
        }
        return this.deleted - before;
    }

    @Override
    public VType get(long key) {
        return this.values[this.slotFor(key)];
    }

    public VType lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public VType lset(VType key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        VType previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(long key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(long key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.keyHashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keys[slot] == key) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (LongObjectCursor<VType> c : this) {
            h += this.keyHashFunction.hash(c.key) + this.valueHashFunction.hash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            LongObjectMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongObjectMap && (other = (LongObjectMap)obj).size() == this.size()) {
                for (LongObjectCursor<VType> c : this) {
                    Object v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<LongObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends LongObjectProcedure<VType>> T forEach(T procedure) {
        long[] keys = this.keys;
        VType[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeySet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySet();
        }
        return this.keySetView;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> LongObjectOpenHashMap<VType> from(long[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongObjectOpenHashMap<VType> map = new LongObjectOpenHashMap<VType>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <VType> LongObjectOpenHashMap<VType> from(LongObjectAssociativeContainer<VType> container) {
        return new LongObjectOpenHashMap<VType>(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySetIterator
    implements Iterator<LongCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final LongCursor cursor = new LongCursor();
        private int nextIndex = -1;

        public KeySetIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < LongObjectOpenHashMap.this.keys.length && LongObjectOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != LongObjectOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public LongCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = LongObjectOpenHashMap.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeySet
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongObjectOpenHashMap<VType> owner;

        public KeySet() {
            this.owner = LongObjectOpenHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return LongObjectOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            long[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length; ++i) {
                if (localStates[i] != 2) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            long[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length && (localStates[i] != 2 || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(long e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<LongObjectCursor<VType>> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final LongObjectCursor<VType> cursor = new LongObjectCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < LongObjectOpenHashMap.this.keys.length && LongObjectOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != LongObjectOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public LongObjectCursor<VType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.key = LongObjectOpenHashMap.this.keys[this.nextIndex];
            this.cursor.value = LongObjectOpenHashMap.this.values[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

