/* moonshot-keyring-store.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-keyring-store.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-keyring.h>
#include <stdio.h>


#define TYPE_IIDENTITY_CARD_STORE (iidentity_card_store_get_type ())
#define IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStore))
#define IS_IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_CARD_STORE))
#define IIDENTITY_CARD_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStoreIface))

typedef struct _IIdentityCardStore IIdentityCardStore;
typedef struct _IIdentityCardStoreIface IIdentityCardStoreIface;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())

#define TYPE_KEYRING_STORE (keyring_store_get_type ())
#define KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYRING_STORE, KeyringStore))
#define KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYRING_STORE, KeyringStoreClass))
#define IS_KEYRING_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYRING_STORE))
#define IS_KEYRING_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYRING_STORE))
#define KEYRING_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYRING_STORE, KeyringStoreClass))

typedef struct _KeyringStore KeyringStore;
typedef struct _KeyringStoreClass KeyringStoreClass;
typedef struct _KeyringStorePrivate KeyringStorePrivate;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__gnome_keyring_found_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gnome_keyring_found_free0_ (var), NULL)))
#define _gnome_keyring_attribute_list_free0(var) ((var == NULL) ? NULL : (var = (gnome_keyring_attribute_list_free (var), NULL)))

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _IIdentityCardStoreIface {
	GTypeInterface parent_iface;
	void (*add_card) (IIdentityCardStore* self, IdCard* card);
	gboolean (*remove_card) (IIdentityCardStore* self, IdCard* card);
	IdCard* (*update_card) (IIdentityCardStore* self, IdCard* card);
	IIdentityCardStoreStoreType (*get_store_type) (IIdentityCardStore* self);
	GeeLinkedList* (*get_card_list) (IIdentityCardStore* self);
	void (*store_id_cards) (IIdentityCardStore* self);
};

struct _KeyringStore {
	GObject parent_instance;
	KeyringStorePrivate * priv;
};

struct _KeyringStoreClass {
	GObjectClass parent_class;
};

struct _KeyringStorePrivate {
	GeeLinkedList* id_card_list;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer keyring_store_parent_class = NULL;
static MoonshotLogger* keyring_store_logger;
static MoonshotLogger* keyring_store_logger = NULL;
static IIdentityCardStoreIface* keyring_store_iidentity_card_store_parent_iface = NULL;

GType id_card_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_get_type (void) G_GNUC_CONST;
GType keyring_store_get_type (void) G_GNUC_CONST;
#define KEYRING_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEYRING_STORE, KeyringStorePrivate))
enum  {
	KEYRING_STORE_DUMMY_PROPERTY
};
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
#define KEYRING_STORE_keyring_store_attribute "Moonshot"
#define KEYRING_STORE_keyring_store_version "1.0"
#define KEYRING_STORE_item_type GNOME_KEYRING_ITEM_GENERIC_SECRET
static void keyring_store_real_add_card (IIdentityCardStore* base, IdCard* card);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
const gchar* id_card_get_display_name (IdCard* self);
gchar* id_card_get_services_string (IdCard* self, const gchar* sep);
void iidentity_card_store_store_id_cards (IIdentityCardStore* self);
static IdCard* keyring_store_real_update_card (IIdentityCardStore* base, IdCard* card);
void moonshot_logger_error (MoonshotLogger* self, const gchar* message, GError* e);
static gboolean keyring_store_real_remove_card (IIdentityCardStore* base, IdCard* card);
static IIdentityCardStoreStoreType keyring_store_real_get_store_type (IIdentityCardStore* base);
static GeeLinkedList* keyring_store_real_get_card_list (IIdentityCardStore* base);
static void keyring_store_clear_keyring (KeyringStore* self);
static void _gnome_keyring_found_free0_ (gpointer var);
static void _g_list_free__gnome_keyring_found_free0_ (GList* self);
static void keyring_store_load_id_cards (KeyringStore* self);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_update_services (IdCard* self, gchar** services, int services_length1);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* trust_anchor_new (const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
TrustAnchor* trust_anchor_construct (GType object_type, const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
void trust_anchor_set_datetime_added (TrustAnchor* self, const gchar* datetime);
void id_card_set_trust_anchor_from_store (IdCard* self, TrustAnchor* ta);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static void _vala_Rule_array_free (Rule* array, gint array_length);
void id_card_set_store_password (IdCard* self, gboolean value);
gboolean id_card_get_store_password (IdCard* self);
void id_card_set_password (IdCard* self, const gchar* value);
static void keyring_store_real_store_id_cards (IIdentityCardStore* base);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
static Rule* _vala_array_dup2 (Rule* self, int length);
const gchar* id_card_get_issuer (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
const gchar* trust_anchor_get_datetime_added (TrustAnchor* self);
const gchar* id_card_get_password (IdCard* self);
KeyringStore* keyring_store_new (void);
KeyringStore* keyring_store_construct (GType object_type);
static void keyring_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void keyring_store_real_add_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	MoonshotLogger* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	IdCard* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GeeLinkedList* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (card != NULL);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = keyring_store_logger;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = id_card_get_display_name (_tmp1_);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = _tmp2_;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp4_ = card;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp5_ = id_card_get_services_string (_tmp4_, "; ");
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp6_ = _tmp5_;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp7_ = g_strdup_printf ("add_card: Adding card '%s' with services: '%s'", _tmp3_, _tmp6_);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp8_ = _tmp7_;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	moonshot_logger_trace (_tmp0_, _tmp8_, NULL);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_free0 (_tmp8_);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_free0 (_tmp6_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp9_ = self->priv->id_card_list;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp10_ = card;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iidentity_card_store_store_id_cards ((IIdentityCardStore*) self);
#line 260 "moonshot-keyring-store.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 267 "moonshot-keyring-store.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 279 "moonshot-keyring-store.c"
}


static IdCard* keyring_store_real_update_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	IdCard* result = NULL;
	MoonshotLogger* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_ = NULL;
	IdCard* _tmp4_ = NULL;
	MoonshotLogger* _tmp22_ = NULL;
	IdCard* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = keyring_store_logger;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	moonshot_logger_trace (_tmp0_, "update_card", NULL);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = self->priv->id_card_list;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = card;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, _tmp2_);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = self->priv->id_card_list;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp4_ = card;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iidentity_card_store_store_id_cards ((IIdentityCardStore*) self);
#line 320 "moonshot-keyring-store.c"
	{
		GeeLinkedList* _idcard_list = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		GeeLinkedList* _tmp6_ = NULL;
		gint _idcard_size = 0;
		GeeLinkedList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _idcard_index = 0;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp5_ = self->priv->id_card_list;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_list = _tmp6_;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp7_ = _idcard_list;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp9_ = _tmp8_;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_size = _tmp9_;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_idcard_index = -1;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		while (TRUE) {
#line 348 "moonshot-keyring-store.c"
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			IdCard* idcard = NULL;
			GeeLinkedList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			IdCard* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			IdCard* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp10_ = _idcard_index;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_idcard_index = _tmp10_ + 1;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp11_ = _idcard_index;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp12_ = _idcard_size;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (!(_tmp11_ < _tmp12_)) {
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				break;
#line 374 "moonshot-keyring-store.c"
			}
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13_ = _idcard_list;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14_ = _idcard_index;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			idcard = (IdCard*) _tmp15_;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp16_ = idcard;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17_ = id_card_get_display_name (_tmp16_);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18_ = _tmp17_;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp19_ = card;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp20_ = id_card_get_display_name (_tmp19_);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp21_ = _tmp20_;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (g_strcmp0 (_tmp18_, _tmp21_) == 0) {
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				result = idcard;
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_object_unref0 (_idcard_list);
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				return result;
#line 404 "moonshot-keyring-store.c"
			}
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_object_unref0 (idcard);
#line 408 "moonshot-keyring-store.c"
		}
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_g_object_unref0 (_idcard_list);
#line 412 "moonshot-keyring-store.c"
	}
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp22_ = keyring_store_logger;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp23_ = card;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp24_ = id_card_get_display_name (_tmp23_);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp25_ = _tmp24_;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp26_ = string_to_string (_tmp25_);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp27_ = g_strconcat ("update_card: card '", _tmp26_, "' was not found after re-loading!", NULL);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp28_ = _tmp27_;
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	moonshot_logger_error (_tmp22_, _tmp28_, NULL);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_free0 (_tmp28_);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = NULL;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 436 "moonshot-keyring-store.c"
}


static gboolean keyring_store_real_remove_card (IIdentityCardStore* base, IdCard* card) {
	KeyringStore * self;
	gboolean result = FALSE;
	gboolean retval = FALSE;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = card;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	retval = _tmp2_;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = retval;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	if (_tmp3_) {
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		iidentity_card_store_store_id_cards ((IIdentityCardStore*) self);
#line 466 "moonshot-keyring-store.c"
	}
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = retval;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 472 "moonshot-keyring-store.c"
}


static IIdentityCardStoreStoreType keyring_store_real_get_store_type (IIdentityCardStore* base) {
	KeyringStore * self;
	IIdentityCardStoreStoreType result = 0;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 485 "moonshot-keyring-store.c"
}


static GeeLinkedList* keyring_store_real_get_card_list (IIdentityCardStore* base) {
	KeyringStore * self;
	GeeLinkedList* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = _tmp1_;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 504 "moonshot-keyring-store.c"
}


static void _gnome_keyring_found_free0_ (gpointer var) {
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	(var == NULL) ? NULL : (var = (gnome_keyring_found_free (var), NULL));
#line 511 "moonshot-keyring-store.c"
}


static void _g_list_free__gnome_keyring_found_free0_ (GList* self) {
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_list_foreach (self, (GFunc) _gnome_keyring_found_free0_, NULL);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_list_free (self);
#line 520 "moonshot-keyring-store.c"
}


static void keyring_store_clear_keyring (KeyringStore* self) {
	GnomeKeyringAttributeList* match = NULL;
	GnomeKeyringAttributeList* _tmp0_ = NULL;
	GnomeKeyringAttributeList* _tmp1_ = NULL;
	GList* items = NULL;
	GnomeKeyringAttributeList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = gnome_keyring_attribute_list_new ();
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	match = _tmp0_;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = match;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_attribute_list_append_string (_tmp1_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = match;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_find_items_sync (KEYRING_STORE_item_type, _tmp2_, &_tmp3_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	items = _tmp3_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp4_ = items;
#line 552 "moonshot-keyring-store.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		entry_collection = _tmp4_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 560 "moonshot-keyring-store.c"
			GnomeKeyringFound* entry = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			entry = (GnomeKeyringFound*) entry_it->data;
#line 564 "moonshot-keyring-store.c"
			{
				GnomeKeyringResult _result_ = 0;
				GnomeKeyringFound* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				GnomeKeyringResult _tmp7_ = 0;
				GnomeKeyringResult _tmp8_ = 0;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp5_ = entry;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp6_ = _tmp5_->item_id;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp7_ = gnome_keyring_item_delete_sync (NULL, (guint32) _tmp6_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_result_ = _tmp7_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp8_ = _result_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp8_ != GNOME_KEYRING_RESULT_OK) {
#line 583 "moonshot-keyring-store.c"
					FILE* _tmp9_ = NULL;
					GnomeKeyringResult _tmp10_ = 0;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp9_ = stdout;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp10_ = _result_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					fprintf (_tmp9_, "GnomeKeyring.item_delete_sync() failed. result: %d", (gint) _tmp10_);
#line 592 "moonshot-keyring-store.c"
				}
			}
		}
	}
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_gnome_keyring_attribute_list_free0 (match);
#line 601 "moonshot-keyring-store.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1215 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 624 "moonshot-keyring-store.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	if (array != NULL) {
#line 631 "moonshot-keyring-store.c"
		int i;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rule_destroy (&array[i]);
#line 637 "moonshot-keyring-store.c"
		}
	}
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_free (array);
#line 642 "moonshot-keyring-store.c"
}


static void keyring_store_load_id_cards (KeyringStore* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GnomeKeyringAttributeList* match = NULL;
	GnomeKeyringAttributeList* _tmp1_ = NULL;
	GnomeKeyringAttributeList* _tmp2_ = NULL;
	GList* items = NULL;
	GnomeKeyringAttributeList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp1_ = gnome_keyring_attribute_list_new ();
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	match = _tmp1_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp2_ = match;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_attribute_list_append_string (_tmp2_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp3_ = match;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	gnome_keyring_find_items_sync (KEYRING_STORE_item_type, _tmp3_, &_tmp4_);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	items = _tmp4_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp5_ = items;
#line 679 "moonshot-keyring-store.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		entry_collection = _tmp5_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 687 "moonshot-keyring-store.c"
			GnomeKeyringFound* entry = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			entry = (GnomeKeyringFound*) entry_it->data;
#line 691 "moonshot-keyring-store.c"
			{
				IdCard* id_card = NULL;
				IdCard* _tmp6_ = NULL;
				gint i = 0;
				gint rules_patterns_index = 0;
				gint rules_always_confirm_index = 0;
				gchar* store_password = NULL;
				gchar* ca_cert = NULL;
				gchar* _tmp7_ = NULL;
				gchar* server_cert = NULL;
				gchar* _tmp8_ = NULL;
				gchar* subject = NULL;
				gchar* _tmp9_ = NULL;
				gchar* subject_alt = NULL;
				gchar* _tmp10_ = NULL;
				gchar* ta_datetime_added = NULL;
				gchar* _tmp11_ = NULL;
				TrustAnchor* ta = NULL;
				const gchar* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				TrustAnchor* _tmp82_ = NULL;
				const gchar* _tmp83_ = NULL;
				IdCard* _tmp86_ = NULL;
				TrustAnchor* _tmp87_ = NULL;
				gboolean _tmp88_ = FALSE;
				gint _tmp89_ = 0;
				const gchar* _tmp133_ = NULL;
				IdCard* _tmp142_ = NULL;
				gboolean _tmp143_ = FALSE;
				gboolean _tmp144_ = FALSE;
				GeeLinkedList* _tmp149_ = NULL;
				IdCard* _tmp150_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp6_ = id_card_new ();
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				id_card = _tmp6_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				rules_patterns_index = -1;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				rules_always_confirm_index = -1;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				store_password = NULL;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp7_ = g_strdup ("");
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				ca_cert = _tmp7_;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp8_ = g_strdup ("");
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				server_cert = _tmp8_;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp9_ = g_strdup ("");
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				subject = _tmp9_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp10_ = g_strdup ("");
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				subject_alt = _tmp10_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp11_ = g_strdup ("");
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				ta_datetime_added = _tmp11_;
#line 756 "moonshot-keyring-store.c"
				{
					gboolean _tmp12_ = FALSE;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					i = 0;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp12_ = TRUE;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					while (TRUE) {
#line 765 "moonshot-keyring-store.c"
						gint _tmp14_ = 0;
						GnomeKeyringFound* _tmp15_ = NULL;
						GnomeKeyringAttributeList* _tmp16_ = NULL;
						guint _tmp17_ = 0U;
						GnomeKeyringAttribute attribute = {0};
						GnomeKeyringFound* _tmp18_ = NULL;
						GnomeKeyringAttributeList* _tmp19_ = NULL;
						GnomeKeyringAttribute* _tmp20_ = NULL;
						gint _tmp20__length1 = 0;
						gint _tmp21_ = 0;
						GnomeKeyringAttribute _tmp22_ = {0};
						gchar* value = NULL;
						gchar* _tmp23_ = NULL;
						GnomeKeyringAttribute _tmp24_ = {0};
						GnomeKeyringAttributeType _tmp25_ = 0;
						GnomeKeyringAttribute _tmp29_ = {0};
						const gchar* _tmp30_ = NULL;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!_tmp12_) {
#line 785 "moonshot-keyring-store.c"
							gint _tmp13_ = 0;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp13_ = i;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							i = _tmp13_ + 1;
#line 791 "moonshot-keyring-store.c"
						}
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp12_ = FALSE;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp14_ = i;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp15_ = entry;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp16_ = _tmp15_->attributes;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp17_ = _tmp16_->len;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!(((guint) _tmp14_) < _tmp17_)) {
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							break;
#line 807 "moonshot-keyring-store.c"
						}
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp18_ = entry;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp19_ = _tmp18_->attributes;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp20_ = _tmp19_->data;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp20__length1 = -1;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp21_ = i;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp22_ = ((GnomeKeyringAttribute*) _tmp20_)[_tmp21_];
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						attribute = _tmp22_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp23_ = g_strdup ("");
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						value = _tmp23_;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp24_ = attribute;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp25_ = _tmp24_.type;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (_tmp25_ == GNOME_KEYRING_ATTRIBUTE_TYPE_STRING) {
#line 833 "moonshot-keyring-store.c"
							GnomeKeyringAttribute _tmp26_ = {0};
							const gchar* _tmp27_ = NULL;
							gchar* _tmp28_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp26_ = attribute;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp27_ = _tmp26_.value.string;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp28_ = g_strdup (_tmp27_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_g_free0 (value);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							value = _tmp28_;
#line 847 "moonshot-keyring-store.c"
						}
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp29_ = attribute;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp30_ = _tmp29_.name;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (g_strcmp0 (_tmp30_, "Issuer") == 0) {
#line 855 "moonshot-keyring-store.c"
							IdCard* _tmp31_ = NULL;
							const gchar* _tmp32_ = NULL;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp31_ = id_card;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp32_ = value;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							id_card_set_issuer (_tmp31_, _tmp32_);
#line 864 "moonshot-keyring-store.c"
						} else {
							GnomeKeyringAttribute _tmp33_ = {0};
							const gchar* _tmp34_ = NULL;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp33_ = attribute;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp34_ = _tmp33_.name;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							if (g_strcmp0 (_tmp34_, "Username") == 0) {
#line 874 "moonshot-keyring-store.c"
								IdCard* _tmp35_ = NULL;
								const gchar* _tmp36_ = NULL;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp35_ = id_card;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp36_ = value;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								id_card_set_username (_tmp35_, _tmp36_);
#line 883 "moonshot-keyring-store.c"
							} else {
								GnomeKeyringAttribute _tmp37_ = {0};
								const gchar* _tmp38_ = NULL;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp37_ = attribute;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp38_ = _tmp37_.name;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								if (g_strcmp0 (_tmp38_, "DisplayName") == 0) {
#line 893 "moonshot-keyring-store.c"
									IdCard* _tmp39_ = NULL;
									const gchar* _tmp40_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp39_ = id_card;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp40_ = value;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									id_card_set_display_name (_tmp39_, _tmp40_);
#line 902 "moonshot-keyring-store.c"
								} else {
									GnomeKeyringAttribute _tmp41_ = {0};
									const gchar* _tmp42_ = NULL;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp41_ = attribute;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp42_ = _tmp41_.name;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (g_strcmp0 (_tmp42_, "Services") == 0) {
#line 912 "moonshot-keyring-store.c"
										IdCard* _tmp43_ = NULL;
										const gchar* _tmp44_ = NULL;
										gchar** _tmp45_ = NULL;
										gchar** _tmp46_ = NULL;
										gchar** _tmp47_ = NULL;
										gint _tmp47__length1 = 0;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp43_ = id_card;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp44_ = value;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp46_ = _tmp45_ = g_strsplit (_tmp44_, ";", 0);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp47_ = _tmp46_;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp47__length1 = _vala_array_length (_tmp45_);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										id_card_update_services (_tmp43_, _tmp47_, _vala_array_length (_tmp45_));
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
#line 933 "moonshot-keyring-store.c"
									} else {
										GnomeKeyringAttribute _tmp48_ = {0};
										const gchar* _tmp49_ = NULL;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp48_ = attribute;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp49_ = _tmp48_.name;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										if (g_strcmp0 (_tmp49_, "Rules-Pattern") == 0) {
#line 943 "moonshot-keyring-store.c"
											gint _tmp50_ = 0;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp50_ = i;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											rules_patterns_index = _tmp50_;
#line 949 "moonshot-keyring-store.c"
										} else {
											GnomeKeyringAttribute _tmp51_ = {0};
											const gchar* _tmp52_ = NULL;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp51_ = attribute;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											_tmp52_ = _tmp51_.name;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
											if (g_strcmp0 (_tmp52_, "Rules-AlwaysConfirm") == 0) {
#line 959 "moonshot-keyring-store.c"
												gint _tmp53_ = 0;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp53_ = i;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												rules_always_confirm_index = _tmp53_;
#line 965 "moonshot-keyring-store.c"
											} else {
												GnomeKeyringAttribute _tmp54_ = {0};
												const gchar* _tmp55_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp54_ = attribute;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												_tmp55_ = _tmp54_.name;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
												if (g_strcmp0 (_tmp55_, "CA-Cert") == 0) {
#line 975 "moonshot-keyring-store.c"
													const gchar* _tmp56_ = NULL;
													gchar* _tmp57_ = NULL;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp56_ = value;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp57_ = string_strip (_tmp56_);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_g_free0 (ca_cert);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													ca_cert = _tmp57_;
#line 986 "moonshot-keyring-store.c"
												} else {
													GnomeKeyringAttribute _tmp58_ = {0};
													const gchar* _tmp59_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp58_ = attribute;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													_tmp59_ = _tmp58_.name;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
													if (g_strcmp0 (_tmp59_, "Server-Cert") == 0) {
#line 996 "moonshot-keyring-store.c"
														const gchar* _tmp60_ = NULL;
														gchar* _tmp61_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp60_ = value;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp61_ = g_strdup (_tmp60_);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_g_free0 (server_cert);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														server_cert = _tmp61_;
#line 1007 "moonshot-keyring-store.c"
													} else {
														GnomeKeyringAttribute _tmp62_ = {0};
														const gchar* _tmp63_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp62_ = attribute;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														_tmp63_ = _tmp62_.name;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
														if (g_strcmp0 (_tmp63_, "Subject") == 0) {
#line 1017 "moonshot-keyring-store.c"
															const gchar* _tmp64_ = NULL;
															gchar* _tmp65_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp64_ = value;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp65_ = g_strdup (_tmp64_);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_g_free0 (subject);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															subject = _tmp65_;
#line 1028 "moonshot-keyring-store.c"
														} else {
															GnomeKeyringAttribute _tmp66_ = {0};
															const gchar* _tmp67_ = NULL;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp66_ = attribute;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															_tmp67_ = _tmp66_.name;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
															if (g_strcmp0 (_tmp67_, "Subject-Alt") == 0) {
#line 1038 "moonshot-keyring-store.c"
																const gchar* _tmp68_ = NULL;
																gchar* _tmp69_ = NULL;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp68_ = value;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp69_ = g_strdup (_tmp68_);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_g_free0 (subject_alt);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																subject_alt = _tmp69_;
#line 1049 "moonshot-keyring-store.c"
															} else {
																GnomeKeyringAttribute _tmp70_ = {0};
																const gchar* _tmp71_ = NULL;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp70_ = attribute;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																_tmp71_ = _tmp70_.name;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																if (g_strcmp0 (_tmp71_, "StorePassword") == 0) {
#line 1059 "moonshot-keyring-store.c"
																	const gchar* _tmp72_ = NULL;
																	gchar* _tmp73_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp72_ = value;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp73_ = g_strdup (_tmp72_);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_g_free0 (store_password);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	store_password = _tmp73_;
#line 1070 "moonshot-keyring-store.c"
																} else {
																	GnomeKeyringAttribute _tmp74_ = {0};
																	const gchar* _tmp75_ = NULL;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp74_ = attribute;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	_tmp75_ = _tmp74_.name;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																	if (g_strcmp0 (_tmp75_, "TA_DateTime_Added") == 0) {
#line 1080 "moonshot-keyring-store.c"
																		const gchar* _tmp76_ = NULL;
																		gchar* _tmp77_ = NULL;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																		_tmp76_ = value;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																		_tmp77_ = g_strdup (_tmp76_);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																		_g_free0 (ta_datetime_added);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
																		ta_datetime_added = _tmp77_;
#line 1091 "moonshot-keyring-store.c"
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (value);
#line 1106 "moonshot-keyring-store.c"
					}
				}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp78_ = ca_cert;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp79_ = server_cert;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp80_ = subject;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp81_ = subject_alt;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp82_ = trust_anchor_new (_tmp78_, _tmp79_, _tmp80_, _tmp81_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				ta = _tmp82_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp83_ = ta_datetime_added;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (g_strcmp0 (_tmp83_, "") != 0) {
#line 1125 "moonshot-keyring-store.c"
					TrustAnchor* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp84_ = ta;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp85_ = ta_datetime_added;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					trust_anchor_set_datetime_added (_tmp84_, _tmp85_);
#line 1134 "moonshot-keyring-store.c"
				}
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp86_ = id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp87_ = ta;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				id_card_set_trust_anchor_from_store (_tmp86_, _tmp87_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp89_ = rules_always_confirm_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp89_ != -1) {
#line 1146 "moonshot-keyring-store.c"
					gint _tmp90_ = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp90_ = rules_patterns_index;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp88_ = _tmp90_ != -1;
#line 1152 "moonshot-keyring-store.c"
				} else {
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp88_ = FALSE;
#line 1156 "moonshot-keyring-store.c"
				}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp88_) {
#line 1160 "moonshot-keyring-store.c"
					gchar* rules_patterns_all = NULL;
					GnomeKeyringFound* _tmp91_ = NULL;
					GnomeKeyringAttributeList* _tmp92_ = NULL;
					GnomeKeyringAttribute* _tmp93_ = NULL;
					gint _tmp93__length1 = 0;
					gint _tmp94_ = 0;
					GnomeKeyringAttribute _tmp95_ = {0};
					const gchar* _tmp96_ = NULL;
					gchar* _tmp97_ = NULL;
					gchar* rules_always_confirm_all = NULL;
					GnomeKeyringFound* _tmp98_ = NULL;
					GnomeKeyringAttributeList* _tmp99_ = NULL;
					GnomeKeyringAttribute* _tmp100_ = NULL;
					gint _tmp100__length1 = 0;
					gint _tmp101_ = 0;
					GnomeKeyringAttribute _tmp102_ = {0};
					const gchar* _tmp103_ = NULL;
					gchar* _tmp104_ = NULL;
					gchar** rules_always_confirm = NULL;
					const gchar* _tmp105_ = NULL;
					gchar** _tmp106_ = NULL;
					gchar** _tmp107_ = NULL;
					gint rules_always_confirm_length1 = 0;
					gint _rules_always_confirm_size_ = 0;
					gchar** rules_patterns = NULL;
					const gchar* _tmp108_ = NULL;
					gchar** _tmp109_ = NULL;
					gchar** _tmp110_ = NULL;
					gint rules_patterns_length1 = 0;
					gint _rules_patterns_size_ = 0;
					gchar** _tmp111_ = NULL;
					gint _tmp111__length1 = 0;
					gchar** _tmp112_ = NULL;
					gint _tmp112__length1 = 0;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp91_ = entry;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp92_ = _tmp91_->attributes;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp93_ = _tmp92_->data;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp93__length1 = -1;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp94_ = rules_patterns_index;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp95_ = ((GnomeKeyringAttribute*) _tmp93_)[_tmp94_];
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp96_ = _tmp95_.value.string;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp97_ = g_strdup (_tmp96_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns_all = _tmp97_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp98_ = entry;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp99_ = _tmp98_->attributes;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp100_ = _tmp99_->data;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp100__length1 = -1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp101_ = rules_always_confirm_index;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp102_ = ((GnomeKeyringAttribute*) _tmp100_)[_tmp101_];
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp103_ = _tmp102_.value.string;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp104_ = g_strdup (_tmp103_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm_all = _tmp104_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp105_ = rules_always_confirm_all;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp107_ = _tmp106_ = g_strsplit (_tmp105_, ";", 0);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm = _tmp107_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm_length1 = _vala_array_length (_tmp106_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_rules_always_confirm_size_ = rules_always_confirm_length1;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp108_ = rules_patterns_all;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp110_ = _tmp109_ = g_strsplit (_tmp108_, ";", 0);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns = _tmp110_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns_length1 = _vala_array_length (_tmp109_);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_rules_patterns_size_ = rules_patterns_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp111_ = rules_patterns;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp111__length1 = rules_patterns_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp112_ = rules_always_confirm;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp112__length1 = rules_always_confirm_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					if (_tmp111__length1 == _tmp112__length1) {
#line 1261 "moonshot-keyring-store.c"
						Rule* rules = NULL;
						gchar** _tmp113_ = NULL;
						gint _tmp113__length1 = 0;
						Rule* _tmp114_ = NULL;
						gint rules_length1 = 0;
						gint _rules_size_ = 0;
						IdCard* _tmp131_ = NULL;
						Rule* _tmp132_ = NULL;
						gint _tmp132__length1 = 0;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp113_ = rules_patterns;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp113__length1 = rules_patterns_length1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp114_ = g_new0 (Rule, _tmp113__length1);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules = _tmp114_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules_length1 = _tmp113__length1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_rules_size_ = rules_length1;
#line 1283 "moonshot-keyring-store.c"
						{
							gint j = 0;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							j = 0;
#line 1288 "moonshot-keyring-store.c"
							{
								gboolean _tmp115_ = FALSE;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								_tmp115_ = TRUE;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
								while (TRUE) {
#line 1295 "moonshot-keyring-store.c"
									gint _tmp117_ = 0;
									gchar** _tmp118_ = NULL;
									gint _tmp118__length1 = 0;
									Rule* _tmp119_ = NULL;
									gint _tmp119__length1 = 0;
									gint _tmp120_ = 0;
									gchar** _tmp121_ = NULL;
									gint _tmp121__length1 = 0;
									gint _tmp122_ = 0;
									const gchar* _tmp123_ = NULL;
									gchar* _tmp124_ = NULL;
									Rule* _tmp125_ = NULL;
									gint _tmp125__length1 = 0;
									gint _tmp126_ = 0;
									gchar** _tmp127_ = NULL;
									gint _tmp127__length1 = 0;
									gint _tmp128_ = 0;
									const gchar* _tmp129_ = NULL;
									gchar* _tmp130_ = NULL;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (!_tmp115_) {
#line 1317 "moonshot-keyring-store.c"
										gint _tmp116_ = 0;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										_tmp116_ = j;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										j = _tmp116_ + 1;
#line 1323 "moonshot-keyring-store.c"
									}
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp115_ = FALSE;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp117_ = j;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp118_ = rules_patterns;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp118__length1 = rules_patterns_length1;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									if (!(_tmp117_ < _tmp118__length1)) {
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
										break;
#line 1337 "moonshot-keyring-store.c"
									}
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp119_ = rules;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp119__length1 = rules_length1;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp120_ = j;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp121_ = rules_patterns;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp121__length1 = rules_patterns_length1;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp122_ = j;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp123_ = _tmp121_[_tmp122_];
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp124_ = g_strdup (_tmp123_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_g_free0 (_tmp119_[_tmp120_].pattern);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp119_[_tmp120_].pattern = _tmp124_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp125_ = rules;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp125__length1 = rules_length1;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp126_ = j;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp127_ = rules_always_confirm;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp127__length1 = rules_always_confirm_length1;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp128_ = j;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp129_ = _tmp127_[_tmp128_];
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp130_ = g_strdup (_tmp129_);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_g_free0 (_tmp125_[_tmp126_].always_confirm);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
									_tmp125_[_tmp126_].always_confirm = _tmp130_;
#line 1379 "moonshot-keyring-store.c"
								}
							}
						}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp131_ = id_card;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp132_ = rules;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp132__length1 = rules_length1;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						id_card_set_rules (_tmp131_, _tmp132_, _tmp132__length1);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 1393 "moonshot-keyring-store.c"
					}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_g_free0 (rules_always_confirm_all);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_g_free0 (rules_patterns_all);
#line 1403 "moonshot-keyring-store.c"
				}
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp133_ = store_password;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp133_ != NULL) {
#line 1409 "moonshot-keyring-store.c"
					IdCard* _tmp134_ = NULL;
					const gchar* _tmp135_ = NULL;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp134_ = id_card;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp135_ = store_password;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_store_password (_tmp134_, g_strcmp0 (_tmp135_, "yes") == 0);
#line 1418 "moonshot-keyring-store.c"
				} else {
					gboolean _tmp136_ = FALSE;
					GnomeKeyringFound* _tmp137_ = NULL;
					const gchar* _tmp138_ = NULL;
					IdCard* _tmp141_ = NULL;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp137_ = entry;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp138_ = _tmp137_->secret;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					if (_tmp138_ != NULL) {
#line 1430 "moonshot-keyring-store.c"
						GnomeKeyringFound* _tmp139_ = NULL;
						const gchar* _tmp140_ = NULL;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp139_ = entry;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp140_ = _tmp139_->secret;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp136_ = g_strcmp0 (_tmp140_, "") != 0;
#line 1439 "moonshot-keyring-store.c"
					} else {
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp136_ = FALSE;
#line 1443 "moonshot-keyring-store.c"
					}
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp141_ = id_card;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_store_password (_tmp141_, _tmp136_);
#line 1449 "moonshot-keyring-store.c"
				}
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp142_ = id_card;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp143_ = id_card_get_store_password (_tmp142_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp144_ = _tmp143_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				if (_tmp144_) {
#line 1459 "moonshot-keyring-store.c"
					IdCard* _tmp145_ = NULL;
					GnomeKeyringFound* _tmp146_ = NULL;
					const gchar* _tmp147_ = NULL;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp145_ = id_card;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp146_ = entry;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp147_ = _tmp146_->secret;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_password (_tmp145_, _tmp147_);
#line 1471 "moonshot-keyring-store.c"
				} else {
					IdCard* _tmp148_ = NULL;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp148_ = id_card;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					id_card_set_password (_tmp148_, NULL);
#line 1478 "moonshot-keyring-store.c"
				}
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp149_ = self->priv->id_card_list;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp150_ = id_card;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp149_, _tmp150_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_object_unref0 (ta);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (ta_datetime_added);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (subject_alt);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (subject);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (server_cert);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (ca_cert);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_free0 (store_password);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_g_object_unref0 (id_card);
#line 1502 "moonshot-keyring-store.c"
			}
		}
	}
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	__g_list_free__gnome_keyring_found_free0_0 (items);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_gnome_keyring_attribute_list_free0 (match);
#line 1510 "moonshot-keyring-store.c"
}


static Rule* _vala_array_dup2 (Rule* self, int length) {
	Rule* result;
	int i;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	result = g_new0 (Rule, length);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	for (i = 0; i < length; i++) {
#line 1521 "moonshot-keyring-store.c"
		Rule _tmp0_ = {0};
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		rule_copy (&self[i], &_tmp0_);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		result[i] = _tmp0_;
#line 1527 "moonshot-keyring-store.c"
	}
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return result;
#line 1531 "moonshot-keyring-store.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 1062 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 1062 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 1063 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		separator = "";
#line 1548 "moonshot-keyring-store.c"
	}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 1558 "moonshot-keyring-store.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 1568 "moonshot-keyring-store.c"
	}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1574 "moonshot-keyring-store.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 1585 "moonshot-keyring-store.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 1597 "moonshot-keyring-store.c"
		} else {
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 1601 "moonshot-keyring-store.c"
		}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 1605 "moonshot-keyring-store.c"
	}
#line 1065 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1609 "moonshot-keyring-store.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 1067 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 1632 "moonshot-keyring-store.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			i = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1641 "moonshot-keyring-store.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 1654 "moonshot-keyring-store.c"
					gint _tmp10_ = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 1660 "moonshot-keyring-store.c"
				}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 1670 "moonshot-keyring-store.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 1682 "moonshot-keyring-store.c"
				} else {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 1686 "moonshot-keyring-store.c"
				}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 1692 "moonshot-keyring-store.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 1703 "moonshot-keyring-store.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 1718 "moonshot-keyring-store.c"
					} else {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 1722 "moonshot-keyring-store.c"
					}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 1726 "moonshot-keyring-store.c"
				}
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 1068 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					break;
#line 1732 "moonshot-keyring-store.c"
				}
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 1744 "moonshot-keyring-store.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 1765 "moonshot-keyring-store.c"
				} else {
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 1769 "moonshot-keyring-store.c"
				}
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 1069 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 1775 "moonshot-keyring-store.c"
			}
		}
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 1071 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 1782 "moonshot-keyring-store.c"
			gchar* _tmp32_ = NULL;
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 1072 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return result;
#line 1790 "moonshot-keyring-store.c"
		}
#line 1074 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 1074 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 1074 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 1075 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 1077 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 1077 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 1077 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 1078 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1828 "moonshot-keyring-store.c"
		{
			gboolean _tmp46_ = FALSE;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			i = 1;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1837 "moonshot-keyring-store.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1853 "moonshot-keyring-store.c"
					gint _tmp47_ = 0;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1859 "moonshot-keyring-store.c"
				}
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 1079 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					break;
#line 1873 "moonshot-keyring-store.c"
				}
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 1080 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1893 "moonshot-keyring-store.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1908 "moonshot-keyring-store.c"
				} else {
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1912 "moonshot-keyring-store.c"
				}
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 1081 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1920 "moonshot-keyring-store.c"
			}
		}
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		res = NULL;
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 1084 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1931 "moonshot-keyring-store.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1940 "moonshot-keyring-store.c"
	}
}


static void keyring_store_real_store_id_cards (IIdentityCardStore* base) {
	KeyringStore * self;
	MoonshotLogger* _tmp0_ = NULL;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) base;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = keyring_store_logger;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	moonshot_logger_trace (_tmp0_, "store_id_cards", NULL);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_clear_keyring (self);
#line 1956 "moonshot-keyring-store.c"
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _id_card_index = 0;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp1_ = self->priv->id_card_list;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_list = _tmp2_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp3_ = _id_card_list;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_tmp5_ = _tmp4_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_size = _tmp5_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_id_card_index = -1;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		while (TRUE) {
#line 1984 "moonshot-keyring-store.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Rule* rules = NULL;
			IdCard* _tmp12_ = NULL;
			Rule* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			Rule* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			Rule* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gint rules_length1 = 0;
			gint _rules_size_ = 0;
			gchar** rules_patterns = NULL;
			Rule* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gchar** _tmp17_ = NULL;
			gint rules_patterns_length1 = 0;
			gint _rules_patterns_size_ = 0;
			gchar** rules_always_conf = NULL;
			Rule* _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gchar** _tmp19_ = NULL;
			gint rules_always_conf_length1 = 0;
			gint _rules_always_conf_size_ = 0;
			gchar* patterns = NULL;
			gchar** _tmp40_ = NULL;
			gint _tmp40__length1 = 0;
			gchar* _tmp41_ = NULL;
			gchar* always_conf = NULL;
			gchar** _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
			gchar* _tmp43_ = NULL;
			gchar* services = NULL;
			IdCard* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			GnomeKeyringAttributeList* attributes = NULL;
			GnomeKeyringAttributeList* _tmp46_ = NULL;
			guint32 item_id = 0U;
			GnomeKeyringAttributeList* _tmp47_ = NULL;
			GnomeKeyringAttributeList* _tmp48_ = NULL;
			IdCard* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			GnomeKeyringAttributeList* _tmp52_ = NULL;
			IdCard* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			GnomeKeyringAttributeList* _tmp56_ = NULL;
			IdCard* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			const gchar* _tmp59_ = NULL;
			GnomeKeyringAttributeList* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			GnomeKeyringAttributeList* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			GnomeKeyringAttributeList* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			GnomeKeyringAttributeList* _tmp66_ = NULL;
			IdCard* _tmp67_ = NULL;
			TrustAnchor* _tmp68_ = NULL;
			TrustAnchor* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			GnomeKeyringAttributeList* _tmp72_ = NULL;
			IdCard* _tmp73_ = NULL;
			TrustAnchor* _tmp74_ = NULL;
			TrustAnchor* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			const gchar* _tmp77_ = NULL;
			GnomeKeyringAttributeList* _tmp78_ = NULL;
			IdCard* _tmp79_ = NULL;
			TrustAnchor* _tmp80_ = NULL;
			TrustAnchor* _tmp81_ = NULL;
			const gchar* _tmp82_ = NULL;
			const gchar* _tmp83_ = NULL;
			GnomeKeyringAttributeList* _tmp84_ = NULL;
			IdCard* _tmp85_ = NULL;
			TrustAnchor* _tmp86_ = NULL;
			TrustAnchor* _tmp87_ = NULL;
			const gchar* _tmp88_ = NULL;
			const gchar* _tmp89_ = NULL;
			GnomeKeyringAttributeList* _tmp90_ = NULL;
			IdCard* _tmp91_ = NULL;
			TrustAnchor* _tmp92_ = NULL;
			TrustAnchor* _tmp93_ = NULL;
			const gchar* _tmp94_ = NULL;
			const gchar* _tmp95_ = NULL;
			const gchar* _tmp96_ = NULL;
			IdCard* _tmp97_ = NULL;
			gboolean _tmp98_ = FALSE;
			gboolean _tmp99_ = FALSE;
			GnomeKeyringAttributeList* _tmp100_ = NULL;
			const gchar* _tmp101_ = NULL;
			IdCard* _tmp102_ = NULL;
			gboolean _tmp103_ = FALSE;
			gboolean _tmp104_ = FALSE;
			GnomeKeyringResult _result_ = 0;
			IdCard* _tmp108_ = NULL;
			const gchar* _tmp109_ = NULL;
			const gchar* _tmp110_ = NULL;
			GnomeKeyringAttributeList* _tmp111_ = NULL;
			guint32 _tmp112_ = 0U;
			GnomeKeyringResult _tmp113_ = 0;
			GnomeKeyringResult _tmp114_ = 0;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp6_ = _id_card_index;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_id_card_index = _tmp6_ + 1;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp7_ = _id_card_index;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp8_ = _id_card_size;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				break;
#line 2106 "moonshot-keyring-store.c"
			}
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp9_ = _id_card_list;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp10_ = _id_card_index;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			id_card = (IdCard*) _tmp11_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp12_ = id_card;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp13_ = id_card_get_rules (_tmp12_, &_tmp13__length1);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14_ = _tmp13_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp14__length1 = _tmp13__length1;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp15_ = (_tmp14_ != NULL) ? _vala_array_dup2 (_tmp14_, _tmp14__length1) : ((gpointer) _tmp14_);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp15__length1 = _tmp14__length1;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules = _tmp15_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_length1 = _tmp15__length1;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_size_ = rules_length1;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp16_ = rules;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp16__length1 = rules_length1;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp17_ = g_new0 (gchar*, _tmp16__length1 + 1);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns = _tmp17_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns_length1 = _tmp16__length1;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_patterns_size_ = rules_patterns_length1;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18_ = rules;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp18__length1 = rules_length1;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp19_ = g_new0 (gchar*, _tmp18__length1 + 1);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf = _tmp19_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf_length1 = _tmp18__length1;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_rules_always_conf_size_ = rules_always_conf_length1;
#line 2158 "moonshot-keyring-store.c"
			{
				gint i = 0;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				i = 0;
#line 2163 "moonshot-keyring-store.c"
				{
					gboolean _tmp20_ = FALSE;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					_tmp20_ = TRUE;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
					while (TRUE) {
#line 2170 "moonshot-keyring-store.c"
						gint _tmp22_ = 0;
						Rule* _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gchar** _tmp24_ = NULL;
						gint _tmp24__length1 = 0;
						gint _tmp25_ = 0;
						Rule* _tmp26_ = NULL;
						gint _tmp26__length1 = 0;
						gint _tmp27_ = 0;
						Rule _tmp28_ = {0};
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar** _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						gint _tmp33_ = 0;
						Rule* _tmp34_ = NULL;
						gint _tmp34__length1 = 0;
						gint _tmp35_ = 0;
						Rule _tmp36_ = {0};
						const gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!_tmp20_) {
#line 2196 "moonshot-keyring-store.c"
							gint _tmp21_ = 0;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							_tmp21_ = i;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							i = _tmp21_ + 1;
#line 2202 "moonshot-keyring-store.c"
						}
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp20_ = FALSE;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp22_ = i;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp23_ = rules;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp23__length1 = rules_length1;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						if (!(_tmp22_ < _tmp23__length1)) {
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
							break;
#line 2216 "moonshot-keyring-store.c"
						}
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp24_ = rules_patterns;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp24__length1 = rules_patterns_length1;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp25_ = i;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp26_ = rules;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp26__length1 = rules_length1;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp27_ = i;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp28_ = _tmp26_[_tmp27_];
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp29_ = _tmp28_.pattern;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp30_ = g_strdup (_tmp29_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (_tmp24_[_tmp25_]);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp24_[_tmp25_] = _tmp30_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp31_ = _tmp24_[_tmp25_];
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp32_ = rules_always_conf;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp32__length1 = rules_always_conf_length1;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp33_ = i;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp34_ = rules;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp34__length1 = rules_length1;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp35_ = i;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp36_ = _tmp34_[_tmp35_];
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp37_ = _tmp36_.always_confirm;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp38_ = g_strdup (_tmp37_);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_g_free0 (_tmp32_[_tmp33_]);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp32_[_tmp33_] = _tmp38_;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
						_tmp39_ = _tmp32_[_tmp33_];
#line 2266 "moonshot-keyring-store.c"
					}
				}
			}
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp40_ = rules_patterns;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp40__length1 = rules_patterns_length1;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp41_ = _vala_g_strjoinv (";", _tmp40_, _tmp40__length1);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			patterns = _tmp41_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp42_ = rules_always_conf;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp42__length1 = rules_always_conf_length1;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp43_ = _vala_g_strjoinv (";", _tmp42_, _tmp42__length1);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			always_conf = _tmp43_;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp44_ = id_card;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp45_ = id_card_get_services_string (_tmp44_, ";");
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			services = _tmp45_;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp46_ = gnome_keyring_attribute_list_new ();
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			attributes = _tmp46_;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp47_ = attributes;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp47_, KEYRING_STORE_keyring_store_attribute, KEYRING_STORE_keyring_store_version);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp48_ = attributes;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp49_ = id_card;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp50_ = id_card_get_issuer (_tmp49_);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp51_ = _tmp50_;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp48_, "Issuer", _tmp51_);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp52_ = attributes;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp53_ = id_card;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp54_ = id_card_get_username (_tmp53_);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp55_ = _tmp54_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp52_, "Username", _tmp55_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp56_ = attributes;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp57_ = id_card;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp58_ = id_card_get_display_name (_tmp57_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp59_ = _tmp58_;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp56_, "DisplayName", _tmp59_);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp60_ = attributes;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp61_ = services;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp60_, "Services", _tmp61_);
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp62_ = attributes;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp63_ = patterns;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp62_, "Rules-Pattern", _tmp63_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp64_ = attributes;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp65_ = always_conf;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp64_, "Rules-AlwaysConfirm", _tmp65_);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp66_ = attributes;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp67_ = id_card;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp68_ = id_card_get_trust_anchor (_tmp67_);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp69_ = _tmp68_;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp70_ = trust_anchor_get_ca_cert (_tmp69_);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp71_ = _tmp70_;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp66_, "CA-Cert", _tmp71_);
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp72_ = attributes;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp73_ = id_card;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp74_ = id_card_get_trust_anchor (_tmp73_);
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp75_ = _tmp74_;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp76_ = trust_anchor_get_server_cert (_tmp75_);
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp77_ = _tmp76_;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp72_, "Server-Cert", _tmp77_);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp78_ = attributes;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp79_ = id_card;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp80_ = id_card_get_trust_anchor (_tmp79_);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp81_ = _tmp80_;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp82_ = trust_anchor_get_subject (_tmp81_);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp83_ = _tmp82_;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp78_, "Subject", _tmp83_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp84_ = attributes;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp85_ = id_card;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp86_ = id_card_get_trust_anchor (_tmp85_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp87_ = _tmp86_;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp88_ = trust_anchor_get_subject_alt (_tmp87_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp89_ = _tmp88_;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp84_, "Subject-Alt", _tmp89_);
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp90_ = attributes;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp91_ = id_card;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp92_ = id_card_get_trust_anchor (_tmp91_);
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp93_ = _tmp92_;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp94_ = trust_anchor_get_datetime_added (_tmp93_);
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp95_ = _tmp94_;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp90_, "TA_DateTime_Added", _tmp95_);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp97_ = id_card;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp98_ = id_card_get_store_password (_tmp97_);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp99_ = _tmp98_;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp99_) {
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp96_ = "yes";
#line 2428 "moonshot-keyring-store.c"
			} else {
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp96_ = "no";
#line 2432 "moonshot-keyring-store.c"
			}
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp100_ = attributes;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			gnome_keyring_attribute_list_append_string (_tmp100_, "StorePassword", _tmp96_);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp102_ = id_card;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp103_ = id_card_get_store_password (_tmp102_);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp104_ = _tmp103_;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp104_) {
#line 2446 "moonshot-keyring-store.c"
				IdCard* _tmp105_ = NULL;
				const gchar* _tmp106_ = NULL;
				const gchar* _tmp107_ = NULL;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp105_ = id_card;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp106_ = id_card_get_password (_tmp105_);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp107_ = _tmp106_;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp101_ = _tmp107_;
#line 2458 "moonshot-keyring-store.c"
			} else {
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp101_ = "";
#line 2462 "moonshot-keyring-store.c"
			}
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp108_ = id_card;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp109_ = id_card_get_display_name (_tmp108_);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp110_ = _tmp109_;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp111_ = attributes;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp113_ = gnome_keyring_item_create_sync (NULL, KEYRING_STORE_item_type, _tmp110_, _tmp111_, _tmp101_, TRUE, &_tmp112_);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			item_id = _tmp112_;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_result_ = _tmp113_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_tmp114_ = _result_;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			if (_tmp114_ != GNOME_KEYRING_RESULT_OK) {
#line 2482 "moonshot-keyring-store.c"
				FILE* _tmp115_ = NULL;
				GnomeKeyringResult _tmp116_ = 0;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp115_ = stdout;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				_tmp116_ = _result_;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
				fprintf (_tmp115_, "GnomeKeyring.item_create_sync() failed. result: %d", (gint) _tmp116_);
#line 2491 "moonshot-keyring-store.c"
			}
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_gnome_keyring_attribute_list_free0 (attributes);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (services);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (always_conf);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_free0 (patterns);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_always_conf = (_vala_array_free (rules_always_conf, rules_always_conf_length1, (GDestroyNotify) g_free), NULL);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
			_g_object_unref0 (id_card);
#line 2509 "moonshot-keyring-store.c"
		}
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
		_g_object_unref0 (_id_card_list);
#line 2513 "moonshot-keyring-store.c"
	}
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_load_id_cards (self);
#line 2517 "moonshot-keyring-store.c"
}


KeyringStore* keyring_store_construct (GType object_type) {
	KeyringStore * self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = (KeyringStore*) g_object_new (object_type, NULL);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = gee_linked_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self->priv->id_card_list = _tmp0_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_load_id_cards (self);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return self;
#line 2536 "moonshot-keyring-store.c"
}


KeyringStore* keyring_store_new (void) {
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	return keyring_store_construct (TYPE_KEYRING_STORE);
#line 2543 "moonshot-keyring-store.c"
}


static void keyring_store_class_init (KeyringStoreClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	g_type_class_add_private (klass, sizeof (KeyringStorePrivate));
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	G_OBJECT_CLASS (klass)->finalize = keyring_store_finalize;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_tmp0_ = get_logger ("KeyringStore");
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_logger = _tmp0_;
#line 2559 "moonshot-keyring-store.c"
}


static void keyring_store_iidentity_card_store_interface_init (IIdentityCardStoreIface * iface) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	keyring_store_iidentity_card_store_parent_iface = g_type_interface_peek_parent (iface);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->add_card = (void (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_add_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->update_card = (IdCard* (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_update_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->remove_card = (gboolean (*)(IIdentityCardStore*, IdCard*)) keyring_store_real_remove_card;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->get_store_type = (IIdentityCardStoreStoreType (*)(IIdentityCardStore*)) keyring_store_real_get_store_type;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->get_card_list = (GeeLinkedList* (*)(IIdentityCardStore*)) keyring_store_real_get_card_list;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	iface->store_id_cards = (void (*)(IIdentityCardStore*)) keyring_store_real_store_id_cards;
#line 2578 "moonshot-keyring-store.c"
}


static void keyring_store_instance_init (KeyringStore * self) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self->priv = KEYRING_STORE_GET_PRIVATE (self);
#line 2585 "moonshot-keyring-store.c"
}


static void keyring_store_finalize (GObject* obj) {
	KeyringStore * self;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYRING_STORE, KeyringStore);
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-keyring-store.vala"
	G_OBJECT_CLASS (keyring_store_parent_class)->finalize (obj);
#line 2597 "moonshot-keyring-store.c"
}


GType keyring_store_get_type (void) {
	static volatile gsize keyring_store_type_id__volatile = 0;
	if (g_once_init_enter (&keyring_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeyringStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyring_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyringStore), 0, (GInstanceInitFunc) keyring_store_instance_init, NULL };
		static const GInterfaceInfo iidentity_card_store_info = { (GInterfaceInitFunc) keyring_store_iidentity_card_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType keyring_store_type_id;
		keyring_store_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyringStore", &g_define_type_info, 0);
		g_type_add_interface_static (keyring_store_type_id, TYPE_IIDENTITY_CARD_STORE, &iidentity_card_store_info);
		g_once_init_leave (&keyring_store_type_id__volatile, keyring_store_type_id);
	}
	return keyring_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



