/* moonshot-identity-manager-app.c generated by valac 0.24.0, the Vala compiler
 * generated from moonshot-identity-manager-app.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gnome-keyring.h>
#include <gee.h>
#include <stdlib.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_IIDENTITY_MANAGER (iidentity_manager_get_type ())
#define IIDENTITY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_MANAGER, IIdentityManager))
#define IS_IIDENTITY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_MANAGER))
#define IIDENTITY_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_MANAGER, IIdentityManagerIface))

typedef struct _IIdentityManager IIdentityManager;
typedef struct _IIdentityManagerIface IIdentityManagerIface;

#define TYPE_IIDENTITY_MANAGER_PROXY (iidentity_manager_proxy_get_type ())
typedef GDBusProxy IIdentityManagerProxy;
typedef GDBusProxyClass IIdentityManagerProxyClass;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;
typedef struct _IdentityManagerAppPrivate IdentityManagerAppPrivate;

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;

#define TYPE_MOONSHOT_SERVER (moonshot_server_get_type ())
#define MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_SERVER, MoonshotServer))
#define MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_SERVER, MoonshotServerClass))
#define IS_MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_SERVER))
#define IS_MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_SERVER))
#define MOONSHOT_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_SERVER, MoonshotServerClass))

typedef struct _MoonshotServer MoonshotServer;
typedef struct _MoonshotServerClass MoonshotServerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())

#define TYPE_IDENTITY_REQUEST (identity_request_get_type ())
#define IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_REQUEST, IdentityRequest))
#define IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_REQUEST, IdentityRequestClass))
#define IS_IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_REQUEST))
#define IS_IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_REQUEST))
#define IDENTITY_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_REQUEST, IdentityRequestClass))

typedef struct _IdentityRequest IdentityRequest;
typedef struct _IdentityRequestClass IdentityRequestClass;
typedef struct _Block1Data Block1Data;
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))
typedef struct _IdentityRequestPrivate IdentityRequestPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecIdentityManagerApp ParamSpecIdentityManagerApp;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _IIdentityManagerIface {
	GTypeInterface parent_iface;
	gboolean (*show_ui) (IIdentityManager* self, GError** error);
};

struct _IdentityManagerApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdentityManagerAppPrivate * priv;
	IdentityManagerModel* model;
	IdCard* default_id_card;
	gboolean explicitly_launched;
	IdentityManagerView* view;
};

struct _IdentityManagerAppClass {
	GTypeClass parent_class;
	void (*finalize) (IdentityManagerApp *self);
};

struct _IdentityManagerAppPrivate {
	MoonshotServer* ipc_server;
};

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _Block1Data {
	int _ref_count_;
	IdentityManagerApp* self;
	IdCard* identity;
	IdentityRequest* request;
};

struct _IdentityRequest {
	GObject parent_instance;
	IdentityRequestPrivate * priv;
	IdCard* id_card;
	gboolean complete;
	gboolean select_default;
	gchar* nai;
	gchar* password;
	gchar* service;
	GSList* candidates;
};

struct _IdentityRequestClass {
	GObjectClass parent_class;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};

struct _ParamSpecIdentityManagerApp {
	GParamSpec parent_instance;
};


static gpointer identity_manager_app_parent_class = NULL;
extern gboolean explicitly_launched;
gboolean explicitly_launched = TRUE;
extern gboolean use_flat_file_store;
gboolean use_flat_file_store = FALSE;
extern gboolean gtk_available;

GType iidentity_manager_proxy_get_type (void) G_GNUC_CONST;
guint iidentity_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType iidentity_manager_get_type (void) G_GNUC_CONST;
gboolean iidentity_manager_show_ui (IIdentityManager* self, GError** error);
static void iidentity_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gboolean iidentity_manager_proxy_show_ui (IIdentityManager* self, GError** error);
static void iidentity_manager_proxy_iidentity_manager_interface_init (IIdentityManagerIface* iface);
static void _dbus_iidentity_manager_show_ui (IIdentityManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void iidentity_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* iidentity_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean iidentity_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _iidentity_manager_unregister_object (gpointer user_data);
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
GType identity_manager_model_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
GType identity_manager_view_get_type (void) G_GNUC_CONST;
GType moonshot_server_get_type (void) G_GNUC_CONST;
guint moonshot_server_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define IDENTITY_MANAGER_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppPrivate))
enum  {
	IDENTITY_MANAGER_APP_DUMMY_PROPERTY
};
#define IDENTITY_MANAGER_APP_WINDOW_WIDTH 400
#define IDENTITY_MANAGER_APP_WINDOW_HEIGHT 500
void identity_manager_app_show (IdentityManagerApp* self);
IdentityManagerApp* identity_manager_app_new (gboolean headless, gboolean use_flat_file_store);
IdentityManagerApp* identity_manager_app_construct (GType object_type, gboolean headless, gboolean use_flat_file_store);
gboolean UserForcesFlatFileStore (void);
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
IdentityManagerModel* identity_manager_model_new (IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
IdentityManagerModel* identity_manager_model_construct (GType object_type, IdentityManagerApp* parent_app, IIdentityCardStoreStoreType store_type);
gboolean identity_manager_model_HasNonTrivialIdentities (IdentityManagerModel* self);
void identity_manager_model_set_store_type (IdentityManagerModel* self, IIdentityCardStoreStoreType type);
IdentityManagerView* identity_manager_view_new (IdentityManagerApp* app);
IdentityManagerView* identity_manager_view_construct (GType object_type, IdentityManagerApp* app);
GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self);
static void identity_manager_app_init_ipc_server (IdentityManagerApp* self);
gboolean identity_manager_app_add_identity (IdentityManagerApp* self, IdCard* id, gboolean force_flat_file_store);
gboolean identity_manager_view_add_identity (IdentityManagerView* self, IdCard* id_card, gboolean force_flat_file_store);
void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store);
GType identity_request_get_type (void) G_GNUC_CONST;
void identity_manager_app_select_identity (IdentityManagerApp* self, IdentityRequest* request);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
const gchar* id_card_get_nai (IdCard* self);
gchar** id_card_get_services (IdCard* self, int* result_length1);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
void id_card_set_services (IdCard* self, gchar** value, int value_length1);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
static gboolean identity_manager_app_match_service_pattern (IdentityManagerApp* self, const gchar* service, const gchar* pattern);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_password (IdCard* self, const gchar* value);
void id_card_set_temporary (IdCard* self, gboolean value);
void identity_manager_view_queue_identity_request (IdentityManagerView* self, IdentityRequest* request);
static gboolean __lambda6_ (Block1Data* _data1_);
IdCard* identity_manager_view_check_add_password (IdentityManagerView* self, IdCard* identity, IdentityRequest* request, IdentityManagerModel* model);
void identity_request_return_identity (IdentityRequest* self, IdCard* id_card);
static gboolean ___lambda6__gsource_func (gpointer self);
static void identity_manager_app_bus_acquired_cb (IdentityManagerApp* self, GDBusConnection* conn);
MoonshotServer* moonshot_server_new (IdentityManagerApp* app);
MoonshotServer* moonshot_server_construct (GType object_type, IdentityManagerApp* app);
static void _identity_manager_app_bus_acquired_cb_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda9_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name);
static void ___lambda9__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda10_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name);
static void ___lambda10__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void identity_manager_app_finalize (IdentityManagerApp* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _iidentity_manager_dbus_arg_info_show_ui_result = {-1, "result", "b"};
static const GDBusArgInfo * const _iidentity_manager_dbus_arg_info_show_ui_in[] = {NULL};
static const GDBusArgInfo * const _iidentity_manager_dbus_arg_info_show_ui_out[] = {&_iidentity_manager_dbus_arg_info_show_ui_result, NULL};
static const GDBusMethodInfo _iidentity_manager_dbus_method_info_show_ui = {-1, "ShowUi", (GDBusArgInfo **) (&_iidentity_manager_dbus_arg_info_show_ui_in), (GDBusArgInfo **) (&_iidentity_manager_dbus_arg_info_show_ui_out)};
static const GDBusMethodInfo * const _iidentity_manager_dbus_method_info[] = {&_iidentity_manager_dbus_method_info_show_ui, NULL};
static const GDBusSignalInfo * const _iidentity_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _iidentity_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _iidentity_manager_dbus_interface_info = {-1, "org.janet.Moonshot", (GDBusMethodInfo **) (&_iidentity_manager_dbus_method_info), (GDBusSignalInfo **) (&_iidentity_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_iidentity_manager_dbus_property_info)};
static const GDBusInterfaceVTable _iidentity_manager_dbus_interface_vtable = {iidentity_manager_dbus_interface_method_call, iidentity_manager_dbus_interface_get_property, iidentity_manager_dbus_interface_set_property};
const GOptionEntry options[3] = {{"dbus-launched", (gchar) 0, (gint) G_OPTION_FLAG_REVERSE, G_OPTION_ARG_NONE, &explicitly_launched, "launch for dbus rpc use", NULL}, {"flat-file-store", (gchar) 0, 0, G_OPTION_ARG_NONE, &use_flat_file_store, "force use of flat file identity store (used by default only for headle" \
"ss operation)", NULL}, {NULL}};

gboolean iidentity_manager_show_ui (IIdentityManager* self, GError** error) {
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return IIDENTITY_MANAGER_GET_INTERFACE (self)->show_ui (self, error);
#line 313 "moonshot-identity-manager-app.c"
}


static void iidentity_manager_base_init (IIdentityManagerIface * iface) {
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	static gboolean initialized = FALSE;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!initialized) {
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		initialized = TRUE;
#line 324 "moonshot-identity-manager-app.c"
	}
}


GType iidentity_manager_get_type (void) {
	static volatile gsize iidentity_manager_type_id__volatile = 0;
	if (g_once_init_enter (&iidentity_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IIdentityManagerIface), (GBaseInitFunc) iidentity_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType iidentity_manager_type_id;
		iidentity_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "IIdentityManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (iidentity_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (iidentity_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) iidentity_manager_proxy_get_type);
		g_type_set_qdata (iidentity_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.janet.Moonshot");
		g_type_set_qdata (iidentity_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) iidentity_manager_register_object);
		g_once_init_leave (&iidentity_manager_type_id__volatile, iidentity_manager_type_id);
	}
	return iidentity_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (IIdentityManagerProxy, iidentity_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_IIDENTITY_MANAGER, iidentity_manager_proxy_iidentity_manager_interface_init) )
static void iidentity_manager_proxy_class_init (IIdentityManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = iidentity_manager_proxy_g_signal;
}


static void iidentity_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void iidentity_manager_proxy_init (IIdentityManagerProxy* self) {
}


static gboolean iidentity_manager_proxy_show_ui (IIdentityManager* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp0_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.janet.Moonshot", "ShowUi");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static void iidentity_manager_proxy_iidentity_manager_interface_init (IIdentityManagerIface* iface) {
	iface->show_ui = iidentity_manager_proxy_show_ui;
}


static void _dbus_iidentity_manager_show_ui (IIdentityManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = iidentity_manager_show_ui (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void iidentity_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowUi") == 0) {
		_dbus_iidentity_manager_show_ui (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* iidentity_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean iidentity_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint iidentity_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_iidentity_manager_dbus_interface_info), &_iidentity_manager_dbus_interface_vtable, data, _iidentity_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _iidentity_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void identity_manager_app_show (IdentityManagerApp* self) {
	IdentityManagerView* _tmp0_ = NULL;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->view;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp0_ != NULL) {
#line 485 "moonshot-identity-manager-app.c"
		IdentityManagerView* _tmp1_ = NULL;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = self->view;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		gtk_widget_show ((GtkWidget*) _tmp1_);
#line 491 "moonshot-identity-manager-app.c"
	}
}


IdentityManagerApp* identity_manager_app_construct (GType object_type, gboolean headless, gboolean use_flat_file_store) {
	IdentityManagerApp* self = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean keyring_available = FALSE;
	IIdentityCardStoreStoreType store_type = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	IIdentityCardStoreStoreType _tmp10_ = 0;
	IdentityManagerModel* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GeeLinkedList* card_list = NULL;
	IdentityManagerModel* _tmp23_ = NULL;
	GeeLinkedList* _tmp24_ = NULL;
	GeeLinkedList* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = (IdentityManagerApp*) g_type_create_instance (object_type);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = use_flat_file_store;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = UserForcesFlatFileStore ();
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	use_flat_file_store = _tmp0_ | _tmp1_;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = use_flat_file_store;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!_tmp3_) {
#line 532 "moonshot-identity-manager-app.c"
		gboolean _tmp4_ = FALSE;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = gnome_keyring_is_available ();
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = _tmp4_;
#line 538 "moonshot-identity-manager-app.c"
	} else {
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = FALSE;
#line 542 "moonshot-identity-manager-app.c"
	}
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	keyring_available = _tmp2_;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp7_ = headless;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp7_) {
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = TRUE;
#line 552 "moonshot-identity-manager-app.c"
	} else {
		gboolean _tmp8_ = FALSE;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp8_ = use_flat_file_store;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = _tmp8_;
#line 559 "moonshot-identity-manager-app.c"
	}
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp6_) {
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = TRUE;
#line 565 "moonshot-identity-manager-app.c"
	} else {
		gboolean _tmp9_ = FALSE;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp9_ = keyring_available;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = !_tmp9_;
#line 572 "moonshot-identity-manager-app.c"
	}
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp5_) {
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		store_type = IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE;
#line 578 "moonshot-identity-manager-app.c"
	} else {
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		store_type = IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING;
#line 582 "moonshot-identity-manager-app.c"
	}
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp10_ = store_type;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp11_ = identity_manager_model_new (self, _tmp10_);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->model);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->model = _tmp11_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp15_ = headless;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp15_) {
#line 596 "moonshot-identity-manager-app.c"
		gboolean _tmp16_ = FALSE;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp16_ = keyring_available;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = _tmp16_;
#line 602 "moonshot-identity-manager-app.c"
	} else {
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = FALSE;
#line 606 "moonshot-identity-manager-app.c"
	}
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp14_) {
#line 610 "moonshot-identity-manager-app.c"
		gboolean _tmp17_ = FALSE;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp17_ = use_flat_file_store;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp13_ = !_tmp17_;
#line 616 "moonshot-identity-manager-app.c"
	} else {
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp13_ = FALSE;
#line 620 "moonshot-identity-manager-app.c"
	}
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp13_) {
#line 624 "moonshot-identity-manager-app.c"
		IdentityManagerModel* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp18_ = self->model;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp19_ = identity_manager_model_HasNonTrivialIdentities (_tmp18_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp12_ = !_tmp19_;
#line 633 "moonshot-identity-manager-app.c"
	} else {
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp12_ = FALSE;
#line 637 "moonshot-identity-manager-app.c"
	}
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp12_) {
#line 641 "moonshot-identity-manager-app.c"
		IdentityManagerModel* _tmp20_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp20_ = self->model;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_model_set_store_type (_tmp20_, IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING);
#line 647 "moonshot-identity-manager-app.c"
	}
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp21_ = headless;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!_tmp21_) {
#line 653 "moonshot-identity-manager-app.c"
		IdentityManagerView* _tmp22_ = NULL;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp22_ = identity_manager_view_new (self);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_object_ref_sink (_tmp22_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (self->view);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self->view = _tmp22_;
#line 663 "moonshot-identity-manager-app.c"
	}
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp23_ = self->model;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp24_ = identity_manager_model_get_card_list (_tmp23_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	card_list = _tmp24_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp25_ = card_list;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp27_ = _tmp26_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp27_ > 0) {
#line 679 "moonshot-identity-manager-app.c"
		GeeLinkedList* _tmp28_ = NULL;
		gpointer _tmp29_ = NULL;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp28_ = card_list;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp29_ = gee_abstract_list_last ((GeeAbstractList*) _tmp28_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (self->default_id_card);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self->default_id_card = (IdCard*) _tmp29_;
#line 690 "moonshot-identity-manager-app.c"
	}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_init_ipc_server (self);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (card_list);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return self;
#line 698 "moonshot-identity-manager-app.c"
}


IdentityManagerApp* identity_manager_app_new (gboolean headless, gboolean use_flat_file_store) {
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return identity_manager_app_construct (TYPE_IDENTITY_MANAGER_APP, headless, use_flat_file_store);
#line 705 "moonshot-identity-manager-app.c"
}


gboolean identity_manager_app_add_identity (IdentityManagerApp* self, IdCard* id, gboolean force_flat_file_store) {
	gboolean result = FALSE;
	IdentityManagerView* _tmp0_ = NULL;
	IdentityManagerModel* _tmp5_ = NULL;
	IdCard* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->view;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp0_ != NULL) {
#line 723 "moonshot-identity-manager-app.c"
		IdentityManagerView* _tmp1_ = NULL;
		IdCard* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = self->view;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = id;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = force_flat_file_store;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = identity_manager_view_add_identity (_tmp1_, _tmp2_, _tmp3_);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		result = _tmp4_;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return result;
#line 740 "moonshot-identity-manager-app.c"
	}
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp5_ = self->model;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp6_ = id;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp7_ = force_flat_file_store;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_model_add_card (_tmp5_, _tmp6_, _tmp7_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = TRUE;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 754 "moonshot-identity-manager-app.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return self ? g_object_ref (self) : NULL;
#line 761 "moonshot-identity-manager-app.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return _data1_;
#line 770 "moonshot-identity-manager-app.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 779 "moonshot-identity-manager-app.c"
		IdentityManagerApp* self;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		self = _data1_->self;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->identity);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->request);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_identity_manager_app_unref0 (self);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_slice_free (Block1Data, _data1_);
#line 791 "moonshot-identity-manager-app.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	var = (g_free (var), NULL);
#line 799 "moonshot-identity-manager-app.c"
}


static void _g_slist_free__g_free0_ (GSList* self) {
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_slist_free (self);
#line 808 "moonshot-identity-manager-app.c"
}


static gboolean __lambda6_ (Block1Data* _data1_) {
	IdentityManagerApp* self;
	gboolean result = FALSE;
	IdentityManagerView* _tmp0_ = NULL;
	IdentityRequest* _tmp6_ = NULL;
	IdCard* _tmp7_ = NULL;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = _data1_->self;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = self->view;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp0_ != NULL) {
#line 824 "moonshot-identity-manager-app.c"
		IdentityManagerView* _tmp1_ = NULL;
		IdCard* _tmp2_ = NULL;
		IdentityRequest* _tmp3_ = NULL;
		IdentityManagerModel* _tmp4_ = NULL;
		IdCard* _tmp5_ = NULL;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = self->view;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = _data1_->identity;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = _data1_->request;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = self->model;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = identity_manager_view_check_add_password (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->identity);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_data1_->identity = _tmp5_;
#line 844 "moonshot-identity-manager-app.c"
	}
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp6_ = _data1_->request;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp7_ = _data1_->identity;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_request_return_identity (_tmp6_, _tmp7_);
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = FALSE;
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 856 "moonshot-identity-manager-app.c"
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
#line 240 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 865 "moonshot-identity-manager-app.c"
}


void identity_manager_app_select_identity (IdentityManagerApp* self, IdentityRequest* request) {
	Block1Data* _data1_;
	IdentityRequest* _tmp0_ = NULL;
	IdentityRequest* _tmp1_ = NULL;
	IdentityRequest* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	IdCard* _tmp6_ = NULL;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (request != NULL);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->_ref_count_ = 1;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->self = identity_manager_app_ref (self);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = request;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (_data1_->request);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->request = _tmp1_;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_->identity = NULL;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp2_ = _data1_->request;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = _tmp2_->select_default;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp3_) {
#line 902 "moonshot-identity-manager-app.c"
		IdCard* _tmp4_ = NULL;
		IdCard* _tmp5_ = NULL;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = self->default_id_card;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (_data1_->identity);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_data1_->identity = _tmp5_;
#line 913 "moonshot-identity-manager-app.c"
	}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp6_ = _data1_->identity;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp6_ == NULL) {
#line 919 "moonshot-identity-manager-app.c"
		gboolean _tmp7_ = FALSE;
		IdentityRequest* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean has_nai = FALSE;
		gboolean _tmp12_ = FALSE;
		IdentityRequest* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean has_srv = FALSE;
		gboolean confirm = FALSE;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_ = FALSE;
		IdCard* _tmp50_ = NULL;
		gboolean _tmp86_ = FALSE;
		IdCard* _tmp87_ = NULL;
		gboolean _tmp116_ = FALSE;
		IdCard* _tmp117_ = NULL;
		IdCard* _tmp138_ = NULL;
		gboolean _tmp146_ = FALSE;
		gboolean _tmp147_ = FALSE;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp8_ = _data1_->request;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp9_ = _tmp8_->nai;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp9_ != NULL) {
#line 945 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp10_ = _data1_->request;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp11_ = _tmp10_->nai;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp7_ = g_strcmp0 (_tmp11_, "") != 0;
#line 954 "moonshot-identity-manager-app.c"
		} else {
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp7_ = FALSE;
#line 958 "moonshot-identity-manager-app.c"
		}
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		has_nai = _tmp7_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp13_ = _data1_->request;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp14_ = _tmp13_->service;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp14_ != NULL) {
#line 968 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp15_ = _data1_->request;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp16_ = _tmp15_->service;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp12_ = g_strcmp0 (_tmp16_, "") != 0;
#line 977 "moonshot-identity-manager-app.c"
		} else {
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp12_ = FALSE;
#line 981 "moonshot-identity-manager-app.c"
		}
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		has_srv = _tmp12_;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		confirm = FALSE;
#line 987 "moonshot-identity-manager-app.c"
		{
			GeeLinkedList* _id_list = NULL;
			IdentityManagerModel* _tmp17_ = NULL;
			GeeLinkedList* _tmp18_ = NULL;
			gint _id_size = 0;
			GeeLinkedList* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _id_index = 0;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp17_ = self->model;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp18_ = identity_manager_model_get_card_list (_tmp17_);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_id_list = _tmp18_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp19_ = _id_list;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp21_ = _tmp20_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_id_size = _tmp21_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_id_index = -1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			while (TRUE) {
#line 1015 "moonshot-identity-manager-app.c"
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				IdCard* id = NULL;
				GeeLinkedList* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gpointer _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp37_ = FALSE;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp22_ = _id_index;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_index = _tmp22_ + 1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp23_ = _id_index;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp24_ = _id_size;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (!(_tmp23_ < _tmp24_)) {
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					break;
#line 1038 "moonshot-identity-manager-app.c"
				}
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp25_ = _id_list;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp26_ = _id_index;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				id = (IdCard*) _tmp27_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp29_ = has_nai;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_tmp29_) {
#line 1052 "moonshot-identity-manager-app.c"
					IdentityRequest* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					IdCard* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp30_ = _data1_->request;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp31_ = _tmp30_->nai;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp32_ = id;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp33_ = id_card_get_nai (_tmp32_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp34_ = _tmp33_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp28_ = g_strcmp0 (_tmp31_, _tmp34_) == 0;
#line 1070 "moonshot-identity-manager-app.c"
				} else {
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp28_ = FALSE;
#line 1074 "moonshot-identity-manager-app.c"
				}
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_tmp28_) {
#line 1078 "moonshot-identity-manager-app.c"
					IdCard* _tmp35_ = NULL;
					IdCard* _tmp36_ = NULL;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp35_ = id;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp36_ = _g_object_ref0 (_tmp35_);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_g_object_unref0 (_data1_->identity);
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_data1_->identity = _tmp36_;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_g_object_unref0 (id);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					break;
#line 1093 "moonshot-identity-manager-app.c"
				}
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp37_ = has_srv;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_tmp37_) {
#line 1099 "moonshot-identity-manager-app.c"
					IdCard* _tmp38_ = NULL;
					gchar** _tmp39_ = NULL;
					gint _tmp39__length1 = 0;
					gchar** _tmp40_ = NULL;
					gint _tmp40__length1 = 0;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp38_ = id;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp39_ = id_card_get_services (_tmp38_, &_tmp39__length1);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp40_ = _tmp39_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp40__length1 = _tmp39__length1;
#line 1113 "moonshot-identity-manager-app.c"
					{
						gchar** srv_collection = NULL;
						gint srv_collection_length1 = 0;
						gint _srv_collection_size_ = 0;
						gint srv_it = 0;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						srv_collection = _tmp40_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						srv_collection_length1 = _tmp40__length1;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						for (srv_it = 0; srv_it < _tmp40__length1; srv_it = srv_it + 1) {
#line 1125 "moonshot-identity-manager-app.c"
							gchar* _tmp41_ = NULL;
							gchar* srv = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_tmp41_ = g_strdup (srv_collection[srv_it]);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							srv = _tmp41_;
#line 1132 "moonshot-identity-manager-app.c"
							{
								IdentityRequest* _tmp42_ = NULL;
								const gchar* _tmp43_ = NULL;
								const gchar* _tmp44_ = NULL;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp42_ = _data1_->request;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp43_ = _tmp42_->service;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp44_ = srv;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								if (g_strcmp0 (_tmp43_, _tmp44_) == 0) {
#line 1145 "moonshot-identity-manager-app.c"
									IdentityRequest* _tmp45_ = NULL;
									IdCard* _tmp46_ = NULL;
									IdCard* _tmp47_ = NULL;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp45_ = _data1_->request;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp46_ = id;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp47_ = _g_object_ref0 (_tmp46_);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp45_->candidates = g_slist_append (_tmp45_->candidates, _tmp47_);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_g_free0 (srv);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									continue;
#line 1161 "moonshot-identity-manager-app.c"
								}
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_g_free0 (srv);
#line 1165 "moonshot-identity-manager-app.c"
							}
						}
					}
				}
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (id);
#line 1172 "moonshot-identity-manager-app.c"
			}
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (_id_list);
#line 1176 "moonshot-identity-manager-app.c"
		}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp50_ = _data1_->identity;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp50_ == NULL) {
#line 1182 "moonshot-identity-manager-app.c"
			gboolean _tmp51_ = FALSE;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp51_ = has_srv;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp49_ = _tmp51_;
#line 1188 "moonshot-identity-manager-app.c"
		} else {
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp49_ = FALSE;
#line 1192 "moonshot-identity-manager-app.c"
		}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp49_) {
#line 1196 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp52_ = NULL;
			GSList* _tmp53_ = NULL;
			guint _tmp54_ = 0U;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp52_ = _data1_->request;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp53_ = _tmp52_->candidates;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp54_ = g_slist_length (_tmp53_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp48_ = _tmp54_ > ((guint) 1);
#line 1208 "moonshot-identity-manager-app.c"
		} else {
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp48_ = FALSE;
#line 1212 "moonshot-identity-manager-app.c"
		}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp48_) {
#line 1216 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp55_ = NULL;
			GSList* _tmp56_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp55_ = _data1_->request;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp56_ = _tmp55_->candidates;
#line 1223 "moonshot-identity-manager-app.c"
			{
				GSList* id_collection = NULL;
				GSList* id_it = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				id_collection = _tmp56_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
#line 1231 "moonshot-identity-manager-app.c"
					IdCard* _tmp57_ = NULL;
					IdCard* id = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp57_ = _g_object_ref0 ((IdCard*) id_it->data);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					id = _tmp57_;
#line 1238 "moonshot-identity-manager-app.c"
					{
						gint i = 0;
						GSList* services_list = NULL;
						gboolean has_service = FALSE;
						IdCard* _tmp58_ = NULL;
						gchar** _tmp59_ = NULL;
						gint _tmp59__length1 = 0;
						gchar** _tmp60_ = NULL;
						gint _tmp60__length1 = 0;
						gboolean _tmp67_ = FALSE;
						GSList* _tmp68_ = NULL;
						guint _tmp69_ = 0U;
						gchar** services = NULL;
						GSList* _tmp73_ = NULL;
						guint _tmp74_ = 0U;
						gchar** _tmp75_ = NULL;
						gint services_length1 = 0;
						gint _services_size_ = 0;
						GSList* _tmp76_ = NULL;
						IdCard* _tmp84_ = NULL;
						gchar** _tmp85_ = NULL;
						gint _tmp85__length1 = 0;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						i = 0;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						services_list = NULL;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						has_service = FALSE;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp58_ = id;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp59_ = id_card_get_services (_tmp58_, &_tmp59__length1);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp60_ = _tmp59_;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp60__length1 = _tmp59__length1;
#line 1275 "moonshot-identity-manager-app.c"
						{
							gchar** srv_collection = NULL;
							gint srv_collection_length1 = 0;
							gint _srv_collection_size_ = 0;
							gint srv_it = 0;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							srv_collection = _tmp60_;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							srv_collection_length1 = _tmp60__length1;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							for (srv_it = 0; srv_it < _tmp60__length1; srv_it = srv_it + 1) {
#line 1287 "moonshot-identity-manager-app.c"
								gchar* _tmp61_ = NULL;
								gchar* srv = NULL;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp61_ = g_strdup (srv_collection[srv_it]);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								srv = _tmp61_;
#line 1294 "moonshot-identity-manager-app.c"
								{
									const gchar* _tmp62_ = NULL;
									IdentityRequest* _tmp63_ = NULL;
									const gchar* _tmp64_ = NULL;
									const gchar* _tmp65_ = NULL;
									gchar* _tmp66_ = NULL;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp62_ = srv;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp63_ = _data1_->request;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp64_ = _tmp63_->service;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									if (g_strcmp0 (_tmp62_, _tmp64_) == 0) {
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
										has_service = TRUE;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
										_g_free0 (srv);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
										continue;
#line 1315 "moonshot-identity-manager-app.c"
									}
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp65_ = srv;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp66_ = g_strdup (_tmp65_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									services_list = g_slist_append (services_list, _tmp66_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_g_free0 (srv);
#line 1325 "moonshot-identity-manager-app.c"
								}
							}
						}
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp67_ = has_service;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						if (!_tmp67_) {
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							__g_slist_free__g_free0_0 (services_list);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_g_object_unref0 (id);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							continue;
#line 1339 "moonshot-identity-manager-app.c"
						}
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp68_ = services_list;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp69_ = g_slist_length (_tmp68_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						if (_tmp69_ == ((guint) 0)) {
#line 1347 "moonshot-identity-manager-app.c"
							IdCard* _tmp70_ = NULL;
							gchar** _tmp71_ = NULL;
							gchar** _tmp72_ = NULL;
							gint _tmp72__length1 = 0;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_tmp70_ = id;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_tmp71_ = g_new0 (gchar*, 0 + 1);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_tmp72_ = _tmp71_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_tmp72__length1 = 0;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							id_card_set_services (_tmp70_, _tmp72_, 0);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							__g_slist_free__g_free0_0 (services_list);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							_g_object_unref0 (id);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							continue;
#line 1370 "moonshot-identity-manager-app.c"
						}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp73_ = services_list;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp74_ = g_slist_length (_tmp73_);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp75_ = g_new0 (gchar*, _tmp74_ + 1);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						services = _tmp75_;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						services_length1 = _tmp74_;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_services_size_ = services_length1;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp76_ = services_list;
#line 1386 "moonshot-identity-manager-app.c"
						{
							GSList* srv_collection = NULL;
							GSList* srv_it = NULL;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							srv_collection = _tmp76_;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							for (srv_it = srv_collection; srv_it != NULL; srv_it = srv_it->next) {
#line 1394 "moonshot-identity-manager-app.c"
								gchar* _tmp77_ = NULL;
								gchar* srv = NULL;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp77_ = g_strdup ((const gchar*) srv_it->data);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								srv = _tmp77_;
#line 1401 "moonshot-identity-manager-app.c"
								{
									gchar** _tmp78_ = NULL;
									gint _tmp78__length1 = 0;
									gint _tmp79_ = 0;
									const gchar* _tmp80_ = NULL;
									gchar* _tmp81_ = NULL;
									gchar* _tmp82_ = NULL;
									gint _tmp83_ = 0;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp78_ = services;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp78__length1 = services_length1;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp79_ = i;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp80_ = srv;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp81_ = g_strdup (_tmp80_);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_g_free0 (_tmp78_[_tmp79_]);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp78_[_tmp79_] = _tmp81_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp82_ = _tmp78_[_tmp79_];
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_tmp83_ = i;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									i = _tmp83_ + 1;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									_g_free0 (srv);
#line 1432 "moonshot-identity-manager-app.c"
								}
							}
						}
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp84_ = id;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp85_ = services;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_tmp85__length1 = services_length1;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						id_card_set_services (_tmp84_, _tmp85_, _tmp85__length1);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						__g_slist_free__g_free0_0 (services_list);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						_g_object_unref0 (id);
#line 1450 "moonshot-identity-manager-app.c"
					}
				}
			}
		}
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp87_ = _data1_->identity;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp87_ == NULL) {
#line 1459 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp88_ = NULL;
			GSList* _tmp89_ = NULL;
			guint _tmp90_ = 0U;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp88_ = _data1_->request;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp89_ = _tmp88_->candidates;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp90_ = g_slist_length (_tmp89_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp86_ = _tmp90_ == ((guint) 0);
#line 1471 "moonshot-identity-manager-app.c"
		} else {
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp86_ = FALSE;
#line 1475 "moonshot-identity-manager-app.c"
		}
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp86_) {
#line 1479 "moonshot-identity-manager-app.c"
			{
				GeeLinkedList* _id_list = NULL;
				IdentityManagerModel* _tmp91_ = NULL;
				GeeLinkedList* _tmp92_ = NULL;
				gint _id_size = 0;
				GeeLinkedList* _tmp93_ = NULL;
				gint _tmp94_ = 0;
				gint _tmp95_ = 0;
				gint _id_index = 0;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp91_ = self->model;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp92_ = identity_manager_model_get_card_list (_tmp91_);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_list = _tmp92_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp93_ = _id_list;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp94_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp93_);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp95_ = _tmp94_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_size = _tmp95_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_id_index = -1;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				while (TRUE) {
#line 1507 "moonshot-identity-manager-app.c"
					gint _tmp96_ = 0;
					gint _tmp97_ = 0;
					gint _tmp98_ = 0;
					IdCard* id = NULL;
					GeeLinkedList* _tmp99_ = NULL;
					gint _tmp100_ = 0;
					gpointer _tmp101_ = NULL;
					IdCard* _tmp102_ = NULL;
					Rule* _tmp103_ = NULL;
					gint _tmp103__length1 = 0;
					Rule* _tmp104_ = NULL;
					gint _tmp104__length1 = 0;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp96_ = _id_index;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_id_index = _tmp96_ + 1;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp97_ = _id_index;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp98_ = _id_size;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					if (!(_tmp97_ < _tmp98_)) {
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						break;
#line 1532 "moonshot-identity-manager-app.c"
					}
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp99_ = _id_list;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp100_ = _id_index;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp101_ = gee_abstract_list_get ((GeeAbstractList*) _tmp99_, _tmp100_);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					id = (IdCard*) _tmp101_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp102_ = id;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp103_ = id_card_get_rules (_tmp102_, &_tmp103__length1);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp104_ = _tmp103_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_tmp104__length1 = _tmp103__length1;
#line 1550 "moonshot-identity-manager-app.c"
					{
						Rule* rule_collection = NULL;
						gint rule_collection_length1 = 0;
						gint _rule_collection_size_ = 0;
						gint rule_it = 0;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						rule_collection = _tmp104_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						rule_collection_length1 = _tmp104__length1;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
						for (rule_it = 0; rule_it < _tmp104__length1; rule_it = rule_it + 1) {
#line 1562 "moonshot-identity-manager-app.c"
							Rule _tmp105_ = {0};
							Rule rule = {0};
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							rule_copy (&rule_collection[rule_it], &_tmp105_);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
							rule = _tmp105_;
#line 1569 "moonshot-identity-manager-app.c"
							{
								IdentityRequest* _tmp106_ = NULL;
								const gchar* _tmp107_ = NULL;
								Rule _tmp108_ = {0};
								const gchar* _tmp109_ = NULL;
								gboolean _tmp110_ = FALSE;
								IdentityRequest* _tmp111_ = NULL;
								IdCard* _tmp112_ = NULL;
								IdCard* _tmp113_ = NULL;
								Rule _tmp114_ = {0};
								const gchar* _tmp115_ = NULL;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp106_ = _data1_->request;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp107_ = _tmp106_->service;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp108_ = rule;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp109_ = _tmp108_.pattern;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp110_ = identity_manager_app_match_service_pattern (self, _tmp107_, _tmp109_);
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								if (!_tmp110_) {
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									rule_destroy (&rule);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									continue;
#line 1597 "moonshot-identity-manager-app.c"
								}
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp111_ = _data1_->request;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp112_ = id;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp113_ = _g_object_ref0 (_tmp112_);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp111_->candidates = g_slist_append (_tmp111_->candidates, _tmp113_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp114_ = rule;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								_tmp115_ = _tmp114_.always_confirm;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								if (g_strcmp0 (_tmp115_, "true") == 0) {
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
									confirm = TRUE;
#line 1615 "moonshot-identity-manager-app.c"
								}
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
								rule_destroy (&rule);
#line 1619 "moonshot-identity-manager-app.c"
							}
						}
					}
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
					_g_object_unref0 (id);
#line 1625 "moonshot-identity-manager-app.c"
				}
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (_id_list);
#line 1629 "moonshot-identity-manager-app.c"
			}
		}
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp117_ = _data1_->identity;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp117_ == NULL) {
#line 1636 "moonshot-identity-manager-app.c"
			gboolean _tmp118_ = FALSE;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp118_ = has_nai;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp116_ = _tmp118_;
#line 1642 "moonshot-identity-manager-app.c"
		} else {
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp116_ = FALSE;
#line 1646 "moonshot-identity-manager-app.c"
		}
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp116_) {
#line 1650 "moonshot-identity-manager-app.c"
			gchar** components = NULL;
			IdentityRequest* _tmp119_ = NULL;
			const gchar* _tmp120_ = NULL;
			gchar** _tmp121_ = NULL;
			gchar** _tmp122_ = NULL;
			gint components_length1 = 0;
			gint _components_size_ = 0;
			IdCard* _tmp123_ = NULL;
			IdCard* _tmp124_ = NULL;
			IdentityRequest* _tmp125_ = NULL;
			const gchar* _tmp126_ = NULL;
			IdCard* _tmp127_ = NULL;
			gchar** _tmp128_ = NULL;
			gint _tmp128__length1 = 0;
			const gchar* _tmp129_ = NULL;
			gchar** _tmp130_ = NULL;
			gint _tmp130__length1 = 0;
			IdCard* _tmp134_ = NULL;
			IdentityRequest* _tmp135_ = NULL;
			const gchar* _tmp136_ = NULL;
			IdCard* _tmp137_ = NULL;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp119_ = _data1_->request;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp120_ = _tmp119_->nai;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp122_ = _tmp121_ = g_strsplit (_tmp120_, "@", 2);
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			components = _tmp122_;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			components_length1 = _vala_array_length (_tmp121_);
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_components_size_ = components_length1;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp123_ = id_card_new ();
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (_data1_->identity);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_data1_->identity = _tmp123_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp124_ = _data1_->identity;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp125_ = _data1_->request;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp126_ = _tmp125_->nai;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_display_name (_tmp124_, _tmp126_);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp127_ = _data1_->identity;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp128_ = components;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp128__length1 = components_length1;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp129_ = _tmp128_[0];
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_username (_tmp127_, _tmp129_);
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp130_ = components;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp130__length1 = components_length1;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_tmp130__length1 > 1) {
#line 1714 "moonshot-identity-manager-app.c"
				IdCard* _tmp131_ = NULL;
				gchar** _tmp132_ = NULL;
				gint _tmp132__length1 = 0;
				const gchar* _tmp133_ = NULL;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp131_ = _data1_->identity;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp132_ = components;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp132__length1 = components_length1;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp133_ = _tmp132_[1];
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				id_card_set_issuer (_tmp131_, _tmp133_);
#line 1729 "moonshot-identity-manager-app.c"
			}
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp134_ = _data1_->identity;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp135_ = _data1_->request;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp136_ = _tmp135_->password;
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_password (_tmp134_, _tmp136_);
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp137_ = _data1_->identity;
#line 220 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			id_card_set_temporary (_tmp137_, TRUE);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
#line 1745 "moonshot-identity-manager-app.c"
		}
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp138_ = _data1_->identity;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp138_ == NULL) {
#line 1751 "moonshot-identity-manager-app.c"
			IdentityRequest* _tmp139_ = NULL;
			GSList* _tmp140_ = NULL;
			guint _tmp141_ = 0U;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp139_ = _data1_->request;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp140_ = _tmp139_->candidates;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp141_ = g_slist_length (_tmp140_);
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_tmp141_ != ((guint) 1)) {
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				confirm = TRUE;
#line 1765 "moonshot-identity-manager-app.c"
			} else {
				IdentityRequest* _tmp142_ = NULL;
				GSList* _tmp143_ = NULL;
				gconstpointer _tmp144_ = NULL;
				IdCard* _tmp145_ = NULL;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp142_ = _data1_->request;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp143_ = _tmp142_->candidates;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp144_ = g_slist_nth_data (_tmp143_, (guint) 0);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp145_ = _g_object_ref0 ((IdCard*) _tmp144_);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_object_unref0 (_data1_->identity);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_data1_->identity = _tmp145_;
#line 1783 "moonshot-identity-manager-app.c"
			}
		}
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp147_ = confirm;
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp147_) {
#line 1790 "moonshot-identity-manager-app.c"
			IdentityManagerView* _tmp148_ = NULL;
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp148_ = self->view;
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp146_ = _tmp148_ != NULL;
#line 1796 "moonshot-identity-manager-app.c"
		} else {
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp146_ = FALSE;
#line 1800 "moonshot-identity-manager-app.c"
		}
#line 230 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_tmp146_) {
#line 1804 "moonshot-identity-manager-app.c"
			gboolean _tmp149_ = FALSE;
			IdentityManagerView* _tmp150_ = NULL;
			IdentityRequest* _tmp151_ = NULL;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp149_ = self->explicitly_launched;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (!_tmp149_) {
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				identity_manager_app_show (self);
#line 1814 "moonshot-identity-manager-app.c"
			}
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp150_ = self->view;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp151_ = _data1_->request;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			identity_manager_view_queue_identity_request (_tmp150_, _tmp151_);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			block1_data_unref (_data1_);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_data1_ = NULL;
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return;
#line 1828 "moonshot-identity-manager-app.c"
		}
	}
#line 240 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	block1_data_unref (_data1_);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_data1_ = NULL;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return;
#line 1839 "moonshot-identity-manager-app.c"
}


static gboolean identity_manager_app_match_service_pattern (IdentityManagerApp* self, const gchar* service, const gchar* pattern) {
	gboolean result = FALSE;
	GPatternSpec* pspec = NULL;
	const gchar* _tmp0_ = NULL;
	GPatternSpec* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (service != NULL, FALSE);
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (pattern != NULL, FALSE);
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = pattern;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = g_pattern_spec_new (_tmp0_);
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	pspec = _tmp1_;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp2_ = service;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp3_ = g_pattern_match_string (pspec, _tmp2_);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = _tmp3_;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_pattern_spec_free0 (pspec);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 1872 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_bus_acquired_cb (IdentityManagerApp* self, GDBusConnection* conn) {
	GError * _inner_error_ = NULL;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (conn != NULL);
#line 1882 "moonshot-identity-manager-app.c"
	{
		GDBusConnection* _tmp0_ = NULL;
		MoonshotServer* _tmp1_ = NULL;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = conn;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = self->priv->ipc_server;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		moonshot_server_register_object (_tmp1_, _tmp0_, "/org/janet/moonshot", &_inner_error_);
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_inner_error_ != NULL) {
#line 1894 "moonshot-identity-manager-app.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		e = _inner_error_;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_inner_error_ = NULL;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = stderr;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = e;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = _tmp3_->message;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		fprintf (_tmp2_, "%s\n", _tmp4_);
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_error_free0 (e);
#line 1919 "moonshot-identity-manager-app.c"
	}
	__finally0:
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_inner_error_ != NULL) {
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_clear_error (&_inner_error_);
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return;
#line 1930 "moonshot-identity-manager-app.c"
	}
}


static void _identity_manager_app_bus_acquired_cb_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_bus_acquired_cb ((IdentityManagerApp*) self, connection);
#line 1938 "moonshot-identity-manager-app.c"
}


static void __lambda9_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name) {
#line 327 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (conn != NULL);
#line 327 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (name != NULL);
#line 1947 "moonshot-identity-manager-app.c"
}


static void ___lambda9__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	__lambda9_ ((IdentityManagerApp*) self, connection, name);
#line 1954 "moonshot-identity-manager-app.c"
}


static void __lambda10_ (IdentityManagerApp* self, GDBusConnection* conn, const gchar* name) {
	gboolean shown = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (conn != NULL);
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (name != NULL);
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	shown = FALSE;
#line 1968 "moonshot-identity-manager-app.c"
	{
		IIdentityManager* manager = NULL;
		const gchar* _tmp0_ = NULL;
		IIdentityManager* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		IIdentityManager* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp0_ = name;
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp1_ = g_initable_new (TYPE_IIDENTITY_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/janet/moonshot", "g-interface-name", "org.janet.Moonshot", NULL);
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		manager = (IIdentityManager*) _tmp1_;
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_inner_error_ != NULL) {
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1986 "moonshot-identity-manager-app.c"
				goto __catch1_g_io_error;
			}
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 331 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return;
#line 1995 "moonshot-identity-manager-app.c"
		}
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp3_ = manager;
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp4_ = iidentity_manager_show_ui (_tmp3_, &_inner_error_);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp2_ = _tmp4_;
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_inner_error_ != NULL) {
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (manager);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 2009 "moonshot-identity-manager-app.c"
				goto __catch1_g_io_error;
			}
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_object_unref0 (manager);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return;
#line 2020 "moonshot-identity-manager-app.c"
		}
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		shown = _tmp2_;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_object_unref0 (manager);
#line 2026 "moonshot-identity-manager-app.c"
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		e = _inner_error_;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_inner_error_ = NULL;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_error_free0 (e);
#line 2038 "moonshot-identity-manager-app.c"
	}
	__finally1:
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_inner_error_ != NULL) {
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_clear_error (&_inner_error_);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return;
#line 2049 "moonshot-identity-manager-app.c"
	}
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp5_ = shown;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!_tmp5_) {
#line 2055 "moonshot-identity-manager-app.c"
		const gchar* _tmp6_ = NULL;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp6_ = name;
#line 336 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_error ("moonshot-identity-manager-app.vala:336: Couldn't own name %s on dbus o" \
"r show previously launched identity manager.", _tmp6_);
#line 2061 "moonshot-identity-manager-app.c"
	} else {
		FILE* _tmp7_ = NULL;
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp7_ = stdout;
#line 338 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		fprintf (_tmp7_, "Showed previously launched identity manager.\n");
#line 339 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		exit (0);
#line 2070 "moonshot-identity-manager-app.c"
	}
}


static void ___lambda10__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	__lambda10_ ((IdentityManagerApp*) self, connection, name);
#line 2078 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_init_ipc_server (IdentityManagerApp* self) {
	MoonshotServer* _tmp0_ = NULL;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (self != NULL);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = moonshot_server_new (self);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->priv->ipc_server);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv->ipc_server = _tmp0_;
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.janet.Moonshot", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_identity_manager_app_bus_acquired_cb_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _identity_manager_app_bus_acquired_cb_gbus_acquired_callback, identity_manager_app_ref (self), identity_manager_app_unref)), (GClosure*) ((___lambda9__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda9__gbus_name_acquired_callback, identity_manager_app_ref (self), identity_manager_app_unref)), (GClosure*) ((___lambda10__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda10__gbus_name_lost_callback, identity_manager_app_ref (self), identity_manager_app_unref)));
#line 2094 "moonshot-identity-manager-app.c"
}


static void value_identity_manager_app_init (GValue* value) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	value->data[0].v_pointer = NULL;
#line 2101 "moonshot-identity-manager-app.c"
}


static void value_identity_manager_app_free_value (GValue* value) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (value->data[0].v_pointer) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_unref (value->data[0].v_pointer);
#line 2110 "moonshot-identity-manager-app.c"
	}
}


static void value_identity_manager_app_copy_value (const GValue* src_value, GValue* dest_value) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (src_value->data[0].v_pointer) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		dest_value->data[0].v_pointer = identity_manager_app_ref (src_value->data[0].v_pointer);
#line 2120 "moonshot-identity-manager-app.c"
	} else {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2124 "moonshot-identity-manager-app.c"
	}
}


static gpointer value_identity_manager_app_peek_pointer (const GValue* value) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return value->data[0].v_pointer;
#line 2132 "moonshot-identity-manager-app.c"
}


static gchar* value_identity_manager_app_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (collect_values[0].v_pointer) {
#line 2139 "moonshot-identity-manager-app.c"
		IdentityManagerApp* object;
		object = collect_values[0].v_pointer;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (object->parent_instance.g_class == NULL) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2146 "moonshot-identity-manager-app.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2150 "moonshot-identity-manager-app.c"
		}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = identity_manager_app_ref (object);
#line 2154 "moonshot-identity-manager-app.c"
	} else {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = NULL;
#line 2158 "moonshot-identity-manager-app.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return NULL;
#line 2162 "moonshot-identity-manager-app.c"
}


static gchar* value_identity_manager_app_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	IdentityManagerApp** object_p;
	object_p = collect_values[0].v_pointer;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!object_p) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2173 "moonshot-identity-manager-app.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (!value->data[0].v_pointer) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		*object_p = NULL;
#line 2179 "moonshot-identity-manager-app.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		*object_p = value->data[0].v_pointer;
#line 2183 "moonshot-identity-manager-app.c"
	} else {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		*object_p = identity_manager_app_ref (value->data[0].v_pointer);
#line 2187 "moonshot-identity-manager-app.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return NULL;
#line 2191 "moonshot-identity-manager-app.c"
}


GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecIdentityManagerApp* spec;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IDENTITY_MANAGER_APP), NULL);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return G_PARAM_SPEC (spec);
#line 2205 "moonshot-identity-manager-app.c"
}


gpointer value_get_identity_manager_app (const GValue* value) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDENTITY_MANAGER_APP), NULL);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return value->data[0].v_pointer;
#line 2214 "moonshot-identity-manager-app.c"
}


void value_set_identity_manager_app (GValue* value, gpointer v_object) {
	IdentityManagerApp* old;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDENTITY_MANAGER_APP));
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	old = value->data[0].v_pointer;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (v_object) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDENTITY_MANAGER_APP));
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = v_object;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_ref (value->data[0].v_pointer);
#line 2234 "moonshot-identity-manager-app.c"
	} else {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = NULL;
#line 2238 "moonshot-identity-manager-app.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (old) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_unref (old);
#line 2244 "moonshot-identity-manager-app.c"
	}
}


void value_take_identity_manager_app (GValue* value, gpointer v_object) {
	IdentityManagerApp* old;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDENTITY_MANAGER_APP));
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	old = value->data[0].v_pointer;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (v_object) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDENTITY_MANAGER_APP));
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = v_object;
#line 2263 "moonshot-identity-manager-app.c"
	} else {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		value->data[0].v_pointer = NULL;
#line 2267 "moonshot-identity-manager-app.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (old) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_unref (old);
#line 2273 "moonshot-identity-manager-app.c"
	}
}


static void identity_manager_app_class_init (IdentityManagerAppClass * klass) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	identity_manager_app_parent_class = g_type_class_peek_parent (klass);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	IDENTITY_MANAGER_APP_CLASS (klass)->finalize = identity_manager_app_finalize;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_type_class_add_private (klass, sizeof (IdentityManagerAppPrivate));
#line 2285 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_instance_init (IdentityManagerApp * self) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->priv = IDENTITY_MANAGER_APP_GET_PRIVATE (self);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self->ref_count = 1;
#line 2294 "moonshot-identity-manager-app.c"
}


static void identity_manager_app_finalize (IdentityManagerApp* obj) {
	IdentityManagerApp * self;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->model);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->default_id_card);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->view);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_g_object_unref0 (self->priv->ipc_server);
#line 2310 "moonshot-identity-manager-app.c"
}


GType identity_manager_app_get_type (void) {
	static volatile gsize identity_manager_app_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_app_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_identity_manager_app_init, value_identity_manager_app_free_value, value_identity_manager_app_copy_value, value_identity_manager_app_peek_pointer, "p", value_identity_manager_app_collect_value, "p", value_identity_manager_app_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (IdentityManagerAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) identity_manager_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdentityManagerApp), 0, (GInstanceInitFunc) identity_manager_app_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType identity_manager_app_type_id;
		identity_manager_app_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IdentityManagerApp", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&identity_manager_app_type_id__volatile, identity_manager_app_type_id);
	}
	return identity_manager_app_type_id__volatile;
}


gpointer identity_manager_app_ref (gpointer instance) {
	IdentityManagerApp* self;
	self = instance;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	g_atomic_int_inc (&self->ref_count);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return instance;
#line 2335 "moonshot-identity-manager-app.c"
}


void identity_manager_app_unref (gpointer instance) {
	IdentityManagerApp* self;
	self = instance;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		IDENTITY_MANAGER_APP_GET_CLASS (self)->finalize (self);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2348 "moonshot-identity-manager-app.c"
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean headless = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	IdentityManagerApp* app = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	IdentityManagerApp* _tmp29_ = NULL;
	IdentityManagerApp* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	IdentityManagerApp* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GError * _inner_error_ = NULL;
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp0_ = g_getenv ("DISPLAY");
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	headless = _tmp0_ == NULL;
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp1_ = headless;
#line 364 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp1_) {
#line 2376 "moonshot-identity-manager-app.c"
		{
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp2_ = NULL;
			GOptionContext* _tmp3_ = NULL;
			GOptionContext* _tmp4_ = NULL;
			GOptionContext* _tmp5_ = NULL;
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp2_ = g_option_context_new (NULL);
#line 366 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			opt_context = _tmp2_;
#line 367 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp3_ = opt_context;
#line 367 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_option_context_set_help_enabled (_tmp3_, TRUE);
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp4_ = opt_context;
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_option_context_add_main_entries (_tmp4_, options, NULL);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp5_ = opt_context;
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_inner_error_ != NULL) {
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_option_context_free0 (opt_context);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				if (_inner_error_->domain == G_OPTION_ERROR) {
#line 2405 "moonshot-identity-manager-app.c"
					goto __catch2_g_option_error;
				}
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_g_option_context_free0 (opt_context);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				g_clear_error (&_inner_error_);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				return 0;
#line 2416 "moonshot-identity-manager-app.c"
			}
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_option_context_free0 (opt_context);
#line 2420 "moonshot-identity-manager-app.c"
		}
		goto __finally2;
		__catch2_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GError* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			FILE* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			const gchar* _tmp13_ = NULL;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			e = _inner_error_;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_inner_error_ = NULL;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp6_ = stdout;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp7_ = _ ("error: %s\n");
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp8_ = e;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp9_ = _tmp8_->message;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp6_, _tmp7_, _tmp9_);
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp10_ = stdout;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp11_ = _ ("Run '%s --help' to see a full list of available options\n");
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp12_ = args;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp12__length1 = args_length1;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp13_ = _tmp12_[0];
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp10_, _tmp11_, _tmp13_);
#line 373 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			result = -1;
#line 373 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_error_free0 (e);
#line 373 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return result;
#line 2467 "moonshot-identity-manager-app.c"
		}
		__finally2:
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_inner_error_ != NULL) {
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return 0;
#line 2478 "moonshot-identity-manager-app.c"
		}
#line 375 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		explicitly_launched = FALSE;
#line 2482 "moonshot-identity-manager-app.c"
	} else {
		{
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp15_ = _ ("");
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp16_ = gtk_init_with_args (&args_length1, &args, _tmp15_, options, NULL, &_inner_error_);
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp14_ = _tmp16_;
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (_inner_error_ != NULL) {
#line 2496 "moonshot-identity-manager-app.c"
				goto __catch3_g_error;
			}
#line 378 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			if (!_tmp14_) {
#line 2501 "moonshot-identity-manager-app.c"
				FILE* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 379 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp17_ = stdout;
#line 379 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				_tmp18_ = _ ("unable to initialize window\n");
#line 379 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				fprintf (_tmp17_, "%s", _tmp18_);
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				result = -1;
#line 380 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
				return result;
#line 2514 "moonshot-identity-manager-app.c"
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			FILE* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			GError* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			FILE* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			const gchar* _tmp26_ = NULL;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			e = _inner_error_;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_inner_error_ = NULL;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp19_ = stdout;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp20_ = _ ("error: %s\n");
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp21_ = e;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp22_ = _tmp21_->message;
#line 383 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp19_, _tmp20_, _tmp22_);
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp23_ = stdout;
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp24_ = _ ("Run '%s --help' to see a full list of available options\n");
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp25_ = args;
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp25__length1 = args_length1;
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_tmp26_ = _tmp25_[0];
#line 384 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			fprintf (_tmp23_, _tmp24_, _tmp26_);
#line 385 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			result = -1;
#line 385 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			_g_error_free0 (e);
#line 385 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return result;
#line 2562 "moonshot-identity-manager-app.c"
		}
		__finally3:
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		if (_inner_error_ != NULL) {
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			g_clear_error (&_inner_error_);
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
			return 0;
#line 2573 "moonshot-identity-manager-app.c"
		}
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		gtk_available = TRUE;
#line 2577 "moonshot-identity-manager-app.c"
	}
#line 397 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 399 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	textdomain (GETTEXT_PACKAGE);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp27_ = headless;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp28_ = use_flat_file_store;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp29_ = identity_manager_app_new (_tmp27_, _tmp28_);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	app = _tmp29_;
#line 403 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp30_ = app;
#line 403 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp31_ = explicitly_launched;
#line 403 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp30_->explicitly_launched = _tmp31_;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp32_ = app;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp33_ = _tmp32_->explicitly_launched;
#line 405 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp33_) {
#line 2605 "moonshot-identity-manager-app.c"
		IdentityManagerApp* _tmp34_ = NULL;
#line 406 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp34_ = app;
#line 406 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		identity_manager_app_show (_tmp34_);
#line 2611 "moonshot-identity-manager-app.c"
	}
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_tmp35_ = headless;
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	if (_tmp35_) {
#line 2617 "moonshot-identity-manager-app.c"
		GMainLoop* loop = NULL;
		GMainLoop* _tmp36_ = NULL;
		GMainLoop* _tmp37_ = NULL;
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp36_ = g_main_loop_new (NULL, FALSE);
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		loop = _tmp36_;
#line 412 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_tmp37_ = loop;
#line 412 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		g_main_loop_run (_tmp37_);
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		_g_main_loop_unref0 (loop);
#line 2631 "moonshot-identity-manager-app.c"
	} else {
#line 415 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
		gtk_main ();
#line 2635 "moonshot-identity-manager-app.c"
	}
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	result = 0;
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	_identity_manager_app_unref0 (app);
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return result;
#line 2643 "moonshot-identity-manager-app.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 357 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-manager-app.vala"
	return _vala_main (argv, argc);
#line 2653 "moonshot-identity-manager-app.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



