// 
// DefaultInspectionCategories.cs
//  
// Author:
//       Mike Krüger <mkrueger@xamarin.com>
// 
// Copyright (c) 2012 Xamarin <http://xamarin.com>
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
using System;
using MonoDevelop.Core;

namespace MonoDevelop.CodeIssues
{
	/// <summary>
	/// Default code issue categories provide strings to common categories used in the code issue options panel.
	/// </summary>
	public static class DefaultCodeIssueCategories
	{
		public readonly static string Improvements      = GettextCatalog.GetString ("Code Improvements");
		public readonly static string CodeQualityIssues = GettextCatalog.GetString ("Code Quality Issues");
		public readonly static string ConstraintViolations = GettextCatalog.GetString ("Constraint Violations");
		public readonly static string Redundancies = GettextCatalog.GetString ("Redundancies");
		public readonly static string Opportunities = GettextCatalog.GetString ("Language Usage Opportunities");
		public readonly static string Notifications = GettextCatalog.GetString ("Code Notifications");
	}
}

