/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import sharpen.core.Configuration;
import sharpen.core.Sharpen;
import sharpen.core.SharpenConversion;
import sharpen.core.csharp.ast.CSCompilationUnit;
import sharpen.core.framework.ASTResolver;
import sharpen.core.framework.ConversionBatch;
import sharpen.core.framework.resources.WorkspaceUtilities;

public class SharpenConversionBatch
extends ConversionBatch {
    private IProject _targetProject;
    private final Configuration _configuration;

    public SharpenConversionBatch() {
        this(Sharpen.getDefault().configuration());
    }

    public SharpenConversionBatch(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration");
        }
        this._configuration = configuration;
    }

    public void setTargetProject(IProject project) {
        this._targetProject = project;
    }

    @Override
    protected void convertCompilationUnit(ASTResolver resolver, ICompilationUnit source, CompilationUnit ast) throws CoreException, IOException {
        SharpenConversion converter = new SharpenConversion(this._configuration);
        StringWriter writer = new StringWriter();
        converter.setTargetWriter(writer);
        converter.setSource(source);
        converter.setASTResolver(resolver);
        CSCompilationUnit result = converter.run(ast);
        if (writer.getBuffer().length() > 0) {
            this.saveConvertedFile(source, result, writer);
        }
    }

    private void saveConvertedFile(ICompilationUnit cu, CSCompilationUnit csModule, StringWriter convertedContents) throws JavaModelException, CoreException, UnsupportedEncodingException {
        String newName = csModule.elementName();
        if (newName == null) {
            newName = String.valueOf(this.getNameWithoutExtension(cu.getElementName())) + ".cs";
        }
        IFolder folder = this.targetFolderForCompilationUnit(cu, csModule.namespace());
        this.ensureFolder(folder);
        WorkspaceUtilities.writeText(folder.getFile(newName), convertedContents.getBuffer().toString());
    }

    private void ensureFolder(IFolder folder) throws CoreException {
        WorkspaceUtilities.initializeTree(folder, null);
    }

    IFolder targetFolderForCompilationUnit(ICompilationUnit cu, String generatedNamespace) throws CoreException {
        String packageName;
        if (this._targetProject == null) {
            return (IFolder)cu.getCorrespondingResource().getParent();
        }
        IPath basePath = cu.getAncestor(3).getResource().getProjectRelativePath();
        IFolder targetFolder = this._targetProject.getFolder(basePath);
        String string = packageName = generatedNamespace == null ? cu.getParent().getElementName() : SharpenConversionBatch.cleanupNamespace(generatedNamespace);
        if (packageName.length() > 0) {
            return this.getTargetPackageFolder(targetFolder, packageName);
        }
        return targetFolder;
    }

    public static String cleanupNamespace(String generatedNamespace) {
        return generatedNamespace.replace("@", "");
    }

    private IFolder getTargetPackageFolder(IFolder targetFolder, String packageName) throws CoreException {
        if (!this._configuration.flatNamespaceDirectoryStructure()) {
            packageName = packageName.replace('.', '/');
        }
        return targetFolder.getFolder(packageName);
    }

    private String getNameWithoutExtension(String name) {
        return name.split("\\.")[0];
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }
}

