/*
 * Copyright 2017 MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.bson.codecs.pojo.entities;

import java.util.Map;

public final class NestedGenericHolderMapModel {

    private GenericHolderModel<Map<String, SimpleModel>> nested;

    public NestedGenericHolderMapModel() {
    }

    public NestedGenericHolderMapModel(final GenericHolderModel<Map<String, SimpleModel>> nested) {
        this.nested = nested;
    }

    public GenericHolderModel<Map<String, SimpleModel>> getNested() {
        return nested;
    }

    public void setNested(final GenericHolderModel<Map<String, SimpleModel>> nested) {
        this.nested = nested;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NestedGenericHolderMapModel)) {
            return false;
        }

        NestedGenericHolderMapModel that = (NestedGenericHolderMapModel) o;

        if (getNested() != null ? !getNested().equals(that.getNested()) : that.getNested() != null) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = getNested() != null ? getNested().hashCode() : 0;
        return result;
    }

    @Override
    public String toString() {
        return "NestedGenericHolderMapModel{"
                + "nested=" + nested
                + "}";
    }
}
