#include <math.h>
#include "badminton.h"
#include "helpers.h"

// model constants  
#define BADMINTON_DRAG 	1.23 	// 0.5*c_w*A*rho/m
#define BADMINTON_GRAV 	-9.81 	// self-explanatory
  

EXPORT int badminton_model(igame, timediff, paddle_action)
struct gameplay *igame;
float timediff;
int (*paddle_action)(const float[2], struct gameball *);
{
	if (igame->status != gamestatus_running) return PONG_ARGINVALID;

	// save old values
	float pos_old[2];
	float dir_old[2];
	for (int idx= 0; idx <= 1; idx++) {
		pos_old[idx]= igame->ball.pos[idx];
		dir_old[idx]= igame->ball.dir[idx];
	}

	// motion
	// one step of Runge Kutta 4
	// I write the algorithm explicitly (for efficiency)
	float k[4][4],dir[2],dirnorm;
	//k[0]
	dir[0]= dir_old[0];
	dir[1]= dir_old[1];
	dirnorm= sqrtf(dir[0]*dir[0] + dir[1]*dir[1]);
	k[0][0]=      - BADMINTON_DRAG*dirnorm*dir[0];
	k[0][1]= BADMINTON_GRAV - BADMINTON_DRAG*dirnorm*dir[1];
	k[0][2]=                               dir[0];
	k[0][3]=                               dir[1];
	//k[1] & k[2]
	for (int idx= 1; idx <= 2; idx++) {
		dir[0]= dir_old[0] + 0.5 *timediff *k[idx-1][0];
		dir[1]= dir_old[1] + 0.5 *timediff *k[idx-1][1];
		dirnorm= sqrtf(dir[0]*dir[0] + dir[1]*dir[1]);
		k[idx][0]=                - BADMINTON_DRAG*dirnorm*dir[0];
		k[idx][1]= BADMINTON_GRAV - BADMINTON_DRAG*dirnorm*dir[1];
		k[idx][2]=                                         dir[0];
		k[idx][3]=                                         dir[1];
	}
	//k[3]  
	dir[0]= dir_old[0] + timediff*k[2][0];
	dir[1]= dir_old[1] + timediff*k[2][1];
	dirnorm= sqrtf(dir[0]*dir[0] + dir[1]*dir[1]);
	k[3][0]=                - BADMINTON_DRAG*dirnorm*dir[0];
	k[3][1]= BADMINTON_GRAV - BADMINTON_DRAG*dirnorm*dir[1];
	k[3][2]=                                         dir[0];
	k[3][3]=                                         dir[1];
	// now i can compute the new values.
	for (int idx= 0; idx< 2; idx++) {
		igame->ball.dir[idx]+= (k[0][idx] +k[1][idx] +k[2][idx] +k[3][idx]) *timediff/6.f;
		igame->ball.pos[idx]+= (k[0][idx+2] +k[1][idx+2] +k[2][idx+2] +k[3][idx+2]) *timediff/6.f;
	}

	// Check for bouncy things 
/*	while( distance(pos_old,igame->ball.pos) > GAME_NUM_EPS )
		bounce_ball_linear(igame,pos_old,dir_old,0.5,2.0,1.0); */

	// Check if ball is outside and handle the situation
	int out=outside(&igame->ball);
	if( out ){
		if( out == -1 ) igame->pad_attr[0].score++;
		if( out ==  1 ) igame->pad_attr[1].score++;
		return PONG_SCORE;
	}
	return PONG_SUCCESS;
}

