# SPDX-License-Identifier: LGPL-2.1+

from pathlib import Path

import pytest

from . import Image

pytestmark = pytest.mark.integration


def test_sysext(config: Image.Config) -> None:
    with Image(
        config,
        options=[
            "--incremental",
            "--clean-package-metadata=no",
            "--format=directory",
        ],
    ) as image:
        image.build()

        with Image(
            image.config,
            options=[
                "--directory", "",
                "--base-tree", Path(image.output_dir.name) / "image",
                "--overlay",
                "--package=dnsmasq",
                "--format=disk",
            ],
        ) as sysext:
            sysext.build()

