FEATURES_RE=_mkc_|efun|progname|strlc|dprintf|strndup|err

.PHONY : test_output
test_output:
	@set -e; \
	echo PROJECTNAME=${PROJECTNAME}; \
	${.OBJDIR}/client; \
	${.OBJDIR}/server; \
	rm -rf ${.OBJDIR}${PREFIX}; \
	MKCATPAGES=yes; export MKCATPAGES; \
	\
	echo =========== all ============; \
	find ${.OBJDIR} -type f | grep -Ev '${FEATURES_RE}' | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}"; \
	\
	echo ========= install ==========; \
	${MAKE} ${MAKEFLAGS} install -j3 DESTDIR=${.OBJDIR} \
		> /dev/null; \
	find ${.OBJDIR}${PREFIX} -type f -o -type d | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}"; \
	\
	echo ======== uninstall =========; \
	${MAKE} ${MAKEFLAGS} -j4 uninstall DESTDIR=${.OBJDIR} > /dev/null; \
	find ${.OBJDIR}${PREFIX} -type f | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}";\
	\
	echo ========== clean ===========; \
	${MAKE} ${MAKEFLAGS} clean > /dev/null; \
	find ${.OBJDIR} -type f | grep -Ev '${FEATURES_RE}' | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}";\
	\
	echo ========== depend ===========; \
	${MAKE} ${MAKEFLAGS} depend > /dev/null; \
	find ${.OBJDIR} -type f | grep -Ev '${FEATURES_RE}' | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}";\
	\
	echo ========== server ===========; \
	${MAKE} ${MAKEFLAGS} server > /dev/null; \
	find ${.OBJDIR} -type f | grep -Ev '${FEATURES_RE}' | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}";\
	\
	echo ========== client ===========; \
	${MAKE} ${MAKEFLAGS} clean > /dev/null; \
	${MAKE} ${MAKEFLAGS} client > /dev/null; \
	find ${.OBJDIR} -type f | grep -Ev '${FEATURES_RE}' | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}";\
	\
	echo ======= cleandir ==========; \
	${MAKE} ${MAKEFLAGS} cleandir DESTDIR=${.OBJDIR} > /dev/null; \
	find ${.OBJDIR} -type f | \
	mkc_test_helper "${PREFIX}" "${.OBJDIR}"

.include <mkc.minitest.mk>
