
;;; e0sucadd.scm

; This file depends on epsinulBasics.scm
; You could load it now:

;;;; Basic Definitions ;;;;;;;;;;;

;The basic definitions have been moved to the following file:

; (load "~/minlog/examples/ordinals/epsinulBasics.scm")

; We define the algebra of ordinals as follows:

; O ,   α,β  ->  ω^α + β

; for example:

;     O : Zero
;     1 : OP Zero Zero
;     2 : OP Zero (OP Zero Zero)
;   n+1 : OP Zero n

;    ω  : OP (OP Zero Zero) Zero
;   ω+1 : OP (OP Zero Zero) (OP Zero Zero)
; 1+ω+1 : OP Zero (OP (OP Zero Zero) (OP Zero Zero))
;   1+α : OP Zero α

; (display-constructors "ord")

; with ord-variables a, b, g, d, x, y, z, t

; Displaying stuff (for finite ordinals):

; (od (make-numeric-term 2))
; (is-numeric-term? (pt"OP (OP 11 22) (OP 33 44)"))


; Binary relation LESS and LE, < and ≤ :

; (display-program-constants "LESS")
; (display-program-constants "LE")


; (pnt "(OP 1 0) < (OP 0 (OP 1 0))")
; ω<1+ω = False
; (pnt "(OP 1 0) ≤ (OP 0 (OP 1 0))")
; ω≤1+ω = True

; with least element Zero:
; (display-theorems  "ZeroLeast")
; classical behaviour:
; (display-theorems "ClassicalLESS")
; linear order:
; (display "\n LESS is strict linear order: \n")
; (display-program-constants "LESS")
; (display-theorems "LESSantisym")
; (display-theorems "LESStrans")
; (display-theorems"LESSlinear")
; further properties:
; (display-theorems "LESSEQUtrans")
; (display-theorems "LESStrans")


; Binary relation TERMINEQU, ≠
; for term's inequality:

; (display-program-constants "TERMINEQU")



; Binary relation IC, ~ , for equality:

; (display-program-constants "IC")

; which is an equivalence relation:
; (display-theorems"ICsym")
; (display-theorems"ICtrans")


; And many more

; To summarise and see them all:
; (display-constructors)
; (display-program-constants)
; (display-tokens)
; (display-theorems)

;;;; End of Basic Definitions ;;;;


(display-program-constants "LESS")
(display-program-constants "NLESS")
(display-program-constants "LE")




; Successor Ordinal

; S: ∀α ∃β ∀γ α<β & (α≤γ<β -> γ~α)

(set-goal(pf"ex b all g.a<b & (g<b->(g<a->F)->g~a)"))

; Claim
(cut(pf"all a ex b all g .a<b & (g<b->(g<a->F)->(a<g->F))"))

; Goal follows from Claim
(assume "Claim" "a")
(inst-with "Claim" (pt"a"))
(by-assume-with 2 "b" 3)
(ex-intro (pt"b"))
(assume "g")
(split)

(use 3 (pt"g"))

(ng)
(casedist (pt"g=a"))
(search)

(strip 3)
(cut (pf"a<g -> F"))
(strip)
(simp 6)
(simp 7)
(prop)
(search)


; Proof of claim

; ?_3: all a ex b.a<b & (all g.g<b -> (g<a -> F) -> a<g -> F)

(ind); on a

; a=0
(ex-intro (pt"1"))
(cases)
(prop)
(search)

; a1,a2 -> OP a1 a2
(assume "a1" "a2")
(strip)
(by-assume-with 2 "d" "IH")
(strip)
(drop '1)
(ex-intro (pt"OP a1 d"))

(ind) ; on g
    (search)
(assume "g1" "g2")
(ng)

(casedist (pt"g1<a1"))
(strip 1)
(cut (pf"a1<g1->F"))
(strip 1)
(simp 5)
(prop)
(use "LESSantisym")
(use 4)

; ?_41: (g1<a1 -> F) ->
(casedist (pt"a1<g1"))
(search)
(search)

; ok, ?_48 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "S")
(display-theorems "S")

(animate "S")
(display-program-constants "cS")
(deanimate "S")

(add-rewrite-rule (pt"a<cS a")(pt"True"))

(display-program-constants "LESS")



; ¬ ( Sα < α )

(set-goal (pf"cS a<a -> F"))
(assume "a")
(use "LESSantisym")
(prop)

; ok, ?_3 is proved in minimal propositional logic.  Proof finished.

(add-rewrite-rule (pt"cS a<a")(pt"False"))
(add-rewrite-rule (pt"(Rec ord=>ord)1([a0,a1,a2]OP a0)a<a")(pt"False"))



; cS 0 < 1  -> F

(animate "S")

(set-goal(pf "cS 0<1 -> F"))
(search)

; ok, ?_1 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"cS 0<1")(pt"False"))

(deanimate "S")


; End of cS RW-rules

(display-program-constants "LESS")



; Test
(animate "S")
(begin (display" \n S(ω+2) = ")(ont"cS (OP 1 2)"))
; Answer: ω+3
(begin (display" \n S(1+ω+2) = ")(ont"cS (OP 0 (OP 1 2))"))
; Answer: 1+ω+3)
(begin (display" \n S(ω²³+99) = ")(ont"cS (OP 23 99)"))
; Answer: ω^(23)+100
(deanimate "S")



; We will use the following ordinal variables
; to denote finite ordinals

(av "i" "j" "k" "l" "m" "n" (py "ord"))


; Thms


; FinSucc: n<ω -> Sn=1+n

(animate "S")

(set-goal(pf"n<OP 1 0 -> cS n = OP 0 n"))
(ind)
    (search)
(assume "k" "l")
(strip)
(cut(pf"cS l=OP 0 l"))
(strip)
(cut(pf"k=0"))
(strip)
(simp 5)
(cut (pf"cS(OP 0 l)=OP 0 (cS l)"))
(strip)
(simp 6)
(simp 4)
(prop)
(search)

; ?_10: k=0

(cut(pf"OP k l<OP 1 0"))
(ng)
(casedist (pt"k=0"))
(search)
(search)
(search)
(cut(pf"l<OP 1 0"))
(search)
(use "LESSEQUtrans" (pt"OP k l"))
(auto)

; ok, ?_26 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "FinSucc")
(display-theorems "FinSucc")

(deanimate "S")




;; Ordinal Predicates SORD and LORD


; Successor Predicate SORD


(add-program-constant
 "SORD"
 (mk-arrow (py "ord") (py "boole"))
 1 'const 1
)

(add-computation-rule (pt"SORD Zero")(pt"F"))
(add-computation-rule (pt"SORD (OP Zero Zero)")(pt"T"))
(add-computation-rule (pt"SORD (OP (OP a1 a2) Zero)")(pt"F"))
(add-computation-rule (pt"SORD (OP a (OP b1 b2))")(pt"SORD (OP b1 b2)"))

(display-program-constants "SORD")




; Limit Predicate LORD


(add-program-constant
 "LORD"
 (mk-arrow (py "ord") (py "boole"))
 1 'const 1
)

(add-computation-rule (pt"LORD Zero")(pt"F"))
(add-computation-rule (pt"LORD (OP Zero Zero)")(pt"F"))
(add-computation-rule (pt"LORD (OP (OP a1 a2) Zero)")(pt"T"))
(add-computation-rule (pt"LORD (OP a (OP b1 b2))")(pt"LORD (OP b1 b2)"))

(display-program-constants "LORD")


; RW-rules for SORD

; SORD( cS α)

(animate "S")

(set-goal(pf"SORD(cS a)"))
(ind)
    (search)
(assume "a1")
(cases)
(auto)

; ok, ?_6 is proved by minimal quantifier logic.  Proof finished.

; (cdp)


(add-rewrite-rule (pt "SORD(cS a)") (pt "T"))
(add-rewrite-rule (pt "SORD((Rec ord=>ord)1([a0,a1,a2]OP a0)a)") (pt "T"))



; ¬LORD( cS α)

(set-goal(pf"LORD(cS a)->F"))
(ind)
    (search)
(assume "a1")
(cases)
(auto)

; ok, ?_6 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(add-rewrite-rule (pt "LORD(cS a)") (pt "F"))
(add-rewrite-rule (pt "LORD((Rec ord=>ord)1([a0,a1,a2]OP a0)a)") (pt "F"))

(deanimate "S")



; α=0 <-> SORD(ω^α)

(set-goal(pf "(SORD(OP a 0) -> a=0) & (a=0 -> SORD(OP a 0))"))
(cases)
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt "SORD(OP a 0)") (pt "a=0"))



; α≠0 <-> LORD(ω^α)

(set-goal(pf "(LORD(OP a 0) -> a=0 -> F) & ((a=0 -> F) -> LORD(OP a 0))"))
(cases)
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt "LORD(OP a 0)") (pt "a≠0"))



; LORD(α)  <-> LORD(1+α)

(set-goal (pf "(LORD a -> LORD(OP 0 a))  &  (LORD(OP 0 a) -> LORD a)"))
(cases)
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt "LORD(OP 0 a)") (pt "LORD a"))


; End of SORD's and LORD's RW-rules

(display-program-constants "SORD")
(display-program-constants "LORD")





; Test for SORD and LORD

(display "Test for SORD and LORD
First SORD then LORD
")
(display "0")
(pnt "SORD 0")
(pnt "LORD 0")
(display "1")
(pnt "SORD 1")
(pnt "LORD 1")
(display "2")
(pnt "SORD 2")
(pnt "LORD 2")
(display "ω+0")
(pnt "SORD (OP 1 0)")
(pnt "LORD (OP 1 0)")
(display "ω+1")
(pnt "SORD (OP 1 1)")
(pnt "LORD (OP 1 1)")
(display "3")
(pnt "SORD (OP 0 2)")
(pnt "LORD (OP 0 2)")
(display "ω+2")
(pnt "SORD (OP 1 2)")
(pnt "LORD (OP 1 2)")
(display "ω²+0")
(pnt "SORD (OP 2 0)")
(pnt "LORD (OP 2 0)")
(display "ω²+1")
(pnt "SORD (OP 2 1)")
(pnt "LORD (OP 2 1)")
(display "ω²+2")
(pnt "SORD (OP 2 2)")
(pnt "LORD (OP 2 2)")
(display "ω²+ω")
(pnt "SORD (OP 2 (OP 1 0))")
(pnt "LORD (OP 2 (OP 1 0))")
(display "ω²+(ω+1)")
(pnt "SORD (OP 2 (OP 1 1))")
(pnt "LORD (OP 2 (OP 1 1))")
(display "1+ω")
(pnt "SORD (OP 0 (OP 1 0))")
(pnt "LORD (OP 0 (OP 1 0))")
(display "ω+ω")
(pnt "SORD (OP 1 (OP 1 0))")
(pnt "LORD (OP 1 (OP 1 0))")
(display "ωʷ")
(pnt "SORD (OP(OP 1 0)0)")
(pnt "LORD (OP(OP 1 0)0)")
(display "ωʷ+1")
(pnt "SORD (OP(OP 1 0)1)")
(pnt "LORD (OP(OP 1 0)1)")
(display "ωʷ+2")
(pnt "SORD (OP(OP 1 0)2)")
(pnt "LORD (OP(OP 1 0)2)")
(display "ωʷ+ω")
(pnt "SORD (OP(OP 1 0)(OP 1 0))")
(pnt "LORD (OP(OP 1 0)(OP 1 0))")
(display "ωʷ+(ω+1)")
(pnt "SORD (OP(OP 1 0)(OP 1 1))")
(pnt "LORD (OP(OP 1 0)(OP 1 1))")
(display "1+(ω+1)")
(pnt "SORD (OP 0 (OP 1 1))")
(pnt "LORD (OP 0 (OP 1 1))")
(display "ω+(ω+1)")
(pnt "SORD (OP 1 (OP 1 1))")
(pnt "LORD (OP 1 (OP 1 1))")
(display "4")
(pnt "SORD (OP 0 3)")
(pnt "LORD (OP 0 3)")
(display "ω^( ωʷ⁺¹+(ω+1) ) + ωʷ⁺¹+(ω+1)")
(pnt "SORD (OP(OP (OP 1 1) (OP 1 1))(OP (OP 1 1) (OP 1 1)))")
(pnt "LORD (OP(OP (OP 1 1) (OP 1 1))(OP (OP 1 1) (OP 1 1)))")

(display" End of SORD & LORD test
")
; Test's end





; Thms for SORD and LORD

; SORD1:  SORD(ω^α+β) -> ¬SORD(β) -> (α=0 & β=0)

(set-goal(pf "SORD (OP a b) -> (SORD b -> F) -> (a=0 & b=0)"))
(cases); a
      (cases); b
      (auto)
(assume "a1" "a2")
(cases);b
(auto)

(save "SORD1")
(display-theorems "SORD1")





; notSORDandLORD:
; SORD α → LORD α → False

(set-goal(pf"SORD a -> LORD a -> False"))

(ind)
(search)

(cases)
(cases)
(auto)

(assume "a1" "a2")
(cases)
(auto)

; ok, ?_10 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "notSORDandLORD")
(display-theorems "notSORDandLORD")




; SORDorLORD: α≠0 → ¬(SORD α) → LORD α

(set-goal(pf"(a=Zero -> F) -> (SORD a -> F) -> LORD a"))

(ind)
(search)

(cases)
(cases)
(search)
(search)

(assume "a1" "a2")
(cases)
(search)
(search)

; ok, ?_10 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "SORDorLORD")
(display-theorems "SORDorLORD")





; onlySORD: 0≠α<ω -> SORD(α)

(set-goal(pf"a≠0 -> a<(OP 1 0) -> SORD a"))

(ind)
    (prop)
(cases)
(cases)
(prop)
(search)

(assume "a1" "a2")
(cases)
(prop)
(strip)
(prop); INTU

; ok, ?_11 is proved in intuitionistic propositional logic.  Proof finished.

; (cdp)

(save"onlySORD")
(display-theorems"onlySORD")



; cS β < ω^α  <->  ( β<ω^α & α≠0 )

(animate "S")

(set-goal(pf"all a. (b<OP a 0 & (a=0 -> F)) -> cS b < OP a 0 "))

(ca "all x,y.cS(OP x y)=OP x (cS y)" "Sdown")

(ind); b
(cases); a
      (search)
      (search)

(assume "b1" "b2" "IHb1" "IHb2")
(ind); a
      (search)
(assume "a1" "a2" "IHa1" "IHa2")
(inst-with-to "Sdown" (pt "b1") (pt "b2") "Sdownb1b2")
(simp "Sdownb1b2")
(ng)
(casedist(pt "b1<OP a1 a2"))
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(deanimate "S")


; The direction left->right of this RWrule is trivial:

(set-goal(pf"cS b<a -> b<a"))

(assume "b" "a")
(use "LESStrans")
(search)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

; So we can
(add-rewrite-rule (pt"cS b < OP a 0") (pt"[if (a=0) (F) (b<OP a 0)]") )
(add-rewrite-rule (pt"(Rec ord=>ord)1([a0,a1,a2]OP a0)b<OP a 0") (pt"[if (a=0) (F) (b<OP a 0)]") )





; limit ordinals closed under successor function:



; SclosedLORD: LORD(α)  ->  β<α  ->  Sβ < α

(animate "S")

(set-goal(pf"LORD a -> b<a -> cS b < a"))

(ind); a
    (assume "b")
    (prop); INTU
(cases); a1
(assume "a2" "IHa1" "IHa2")
(drop "IHa1")

; ?_8: all b.LORD(OP 0 a2) -> b<OP 0 a2 -> cS b<OP 0 a2

(ind); b
(assume "LORD(OP 0 a2)")
(ca "ex x,y.a2=OP x y" "a2=Exy")
(ex-elim "a2=Exy")
(assume "x" "a2=xEy")
(ex-elim "a2=xEy")
(assume "y" "a2=xy")
(simp "a2=xy")
(search)
(use "NonZeroConstructed")
(assume "a2=0")
(cut(pf"LORD(OP 0 a2)"))
(simp "a2=0")
(search)
(search)

(assume "b1" "b2" "IHb1" "IHb2")

; ?_25: LORD(OP 0 a2) -> OP b1 b2<OP 0 a2 -> cS(OP b1 b2)<OP 0 a2

(ng)
(casedist(pt "b1=0"))
     (assume "b1=0")
     (use "IHa2")
(cut(pf "LORD a2 -> OP b1 b2<a2 -> (Rec ord=>ord)1([a3,a4,a5]OP a3)(OP b1 b2)<a2"))
(search)
(use-with "IHa2" (pt"OP b1 b2"))


(assume "a1" "a3")

(assume "a2" "IHa1" "IHa2")
(casedist(pt"a2=0"))
(assume "a2=0")
(drop "IHa1" "IHa2")

; ?_37: all b.LORD(OP(OP a1 a3)a2) -> b<OP(OP a1 a3)a2 -> cS b<OP(OP a1 a3)a2

(cases); b
    (search)
(simp "a2=0")
(search)

(assume "a2≠0")

; ?_41: all b.LORD(OP(OP a1 a3)(OP a4 a6)) -> b<OP(OP a1 a3)(OP a4 a6) -> cS b<OP(OP a1 a3)(OP a4 a6) from

(ind); b
    (search)
(assume "b1" "b2" "IHb1" "IHb2" "L(a1a3a2)")
(cut(pf "LORD a2"))

; ?_45: LORD a2 -> OP b1 b2<OP(OP a1 a3)a2 -> cS(OP b1 b2)<OP(OP a1 a3)a2

(ng)
(casedist(pt"b1<OP a1 a3"))
(search)
(assume "OP a1 a3≤b1")
;(simp "Supb1b2")
(cut(pf "LORD a2 -> OP b1 b2<a2 -> (Rec ord=>ord)1([a3,a4,a5]OP a3)(OP b1 b2)<a2"))




(ng)
(casedist(pt"OP a1 a3<b1"))
(search)
(search)
(use-with "IHa2" (pt"OP b1 b2"))

; ?_46: LORD a2

(cut(pf"LORD(OP(OP a1 a3)a2)"))
(ca "ex x,y.a2=OP x y" "a2=Exy")
(ex-elim "a2=Exy")
(assume "x" "a2=xEy")
(ex-elim "a2=xEy")
(assume "y" "a2=xy")
(simp "a2=xy")
(search)
(use "NonZeroConstructed")
(auto)

; ok, ?_57 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(deanimate "S")

(save "SclosedLORD")
(display-theorems "SclosedLORD")






; ExpCont: LORD(α) -> β<ω^α -> (∃ξ<a) β<ω^ξ

(set-goal(pf "all a.LORD a -> b< OP a 0 -> ex x. x<a & b<OP x 0"))

(ind) ; b
    (assume "a" "lorda" "true")
    (ex-intro (pt "0"))
    (ng)
    (cas "a=0->F" "a≠0")
    (search)
    (assume "a=0")
    (cut(pf "LORD a"))
    (simp "a=0")
    (search)
    (search)
(assume "b1" "b2" "IHb1" "IHb2" "a" "lorda" "b<")
(drop "IHb1")

(ca "b1<a & b2<OP a 0" "b<a 0")

; ?_19: ex x.x<a & OP b1 b2<OP x 0

(casedist(pt "OP b1 0 < b2"))
(assume "b1 0<b2")
(ca "ex x.x<a & b2<OP x 0" "IHb2aR")
(ex-elim "IHb2aR")
(assume "x" "IHb2aRx")
(ex-intro (pt"cS x"))
(split)
(ng)
(use "SclosedLORD")
(search)
(search)

; ?_30: OP b1 b2<OP(cS x)0

(ng)
(cas "b1<cS x" "b1<Sx")
(ng)
(cut(pf "OP x 0 ≤ OP(cS x)0"))
(use "LESSEQUtrans2")
(auto)

; ?_36: b1<cS x

(use "LESStrans" (pt"x"))
(cut(pf "OP b1 0<OP x 0"))
(search)
(use "LESStrans" (pt"b2"))
(search)
(search)
(search)
(search)

; ?_18: (OP b1 0<b2 -> F) -> ...

(assume "b2≤b1 0")
(ex-intro (pt "cS b1"))
(cas "cS b1<a" "b1+1<a")
(split)
(search)
(ng)
(cut(pf "OP b1 0 < OP(cS b1)0"))
(use "LESSEQUtrans")
(search)
(search)
(use "SclosedLORD")
(auto)

; ?_18: a1<OP(℧g)0 & a2<OP(OP(℧g)0)0

(cut(pf "OP b1 b2<OP a 0"))
(ng)
(casedist(pt "b1<a"))
(search)
(prop) ; INTU
(search)

; ok, ?_64 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "ExpCont")
(display-theorems "ExpCont")







; SORD is successor predicate:


;; P: SORD(α) -> (∃β<α) S(β)=α

(animate "S")

(set-goal(pf"SORD a -> ex x. x<a & cS x=a"))

(ind); on a
     (prop) ; INTU

(cases)
(cases)
(strip)

; ?_8: ex x.x<1 & cS x=1

(ex-intro (pt"0"))
(prop)

(assume "b1" "b2")
(ng)
(strip)

; ?_12: ex x.x<OP 0(OP b1 b2) & cS x=OP 0(OP b1 b2)

(cut(pf"ex x.x<OP b1 b2 & cS x=OP b1 b2"))
(strip)
(ex-elim 4)
(assume "y")
(strip)
(ex-intro (pt"OP 0 y"))
(search)
(search)

(assume "a1" "a2")
(cases)
(prop); INTU

(assume "b1" "b2")
(ng)
(strip)

; ?_25: ex x.x<OP(OP a1 a2)(OP b1 b2) & cS x=OP(OP a1 a2)(OP b1 b2)

(cut(pf"ex x.x<OP b1 b2 & cS x=OP b1 b2"))
(strip)
(ex-elim 4)
(assume "y")
(strip)
(ex-intro (pt"OP (OP a1 a2) y"))
(search)
(search)

; ok, ?_27 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "P")
(display-theorems "P")

(animate "P")
(display-program-constants "cP")
(display-program-constants "cS")
(deanimate "P")
(deanimate "S")

; Properties just shown:
(display-theorems "P")
(aga "PredSmaller" (pf "all a. SORD a -> cP a < a"))
(aga "SuccPred" (pf "all a. SORD a -> cS(cP a) = a"))





; PredDown: SORD(β) -> cP(ω^α+β) = ω^α+(cP β)

(deanimate "S")
(animate "P")

(set-goal(pf"SORD b -> cP(OP a b) = OP a (cP b)"))
(ind) ; on b
     (assume "a")
     (search) ; INTU
(cases) ; b1
(cases) ; b2
(strip 2)
(cases) ; a
(search)
(search)

(assume "b4" "b6")
(strip 2)

; ?_13: all a.SORD(OP 0(OP b4 b6)) -> cP(OP a(OP 0(OP b4 b6)))=OP a(cP(OP 0(OP b4 b6)))

(cases) ; a
(auto)

(assume "b3" "b5")
(cases) ; b2
(strip 2)

; ?_19: all a.SORD(OP(OP b3 b5)0) -> cP(OP a(OP(OP b3 b5)0))=OP a(cP(OP(OP b3 b5)0))

(cases) ; a
(search)
(search)

(assume "b4" "b6")
(strip 2)
(cases) ; a
(auto)

; ok, ?_25 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save"PredDown")
(display-theorems"PredDown")

(deanimate "P")





; PredSucc: cP(cS α) = α

(animate "S")
(animate "P")
(set-goal(pf"cP(cS a) =a"))
(ind)
    (search)
(assume "a1" "a2" "IHa1" "IHa2")
(cut(pf "cS(OP a1 a2) = OP a1 (cS a2)"))
(assume "cS(OP a1 a2) = OP a1 (cS a2)")
(simp "cS(OP a1 a2) = OP a1 (cS a2)")
(cut(pf "cP(OP a1 (cS a2)) = OP a1 (cP (cS a2))"))
(assume "cP(OP a1 (cS a2)) = OP a1 (cP (cS a2))")
(simp "cP(OP a1 (cS a2)) = OP a1 (cP (cS a2))")
(search)
(use "PredDown")
(auto)

; ok, ?_6 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "PredSucc")
(display-theorems "PredSucc")
(deanimate "S")
(deanimate "P")







; Pbiggestsmaller: SORD α -> β<α -> β≤ cP α

(deanimate "P")




(set-goal(pf"SORD a -> b<a -> b≤ cP a"))
(ind) ; a

(ind) ; b
    (search)
(assume "b1" "b2" "IHb1" "IHb2")
(prop); INTU

(assume "a1" "a2" "IHa1" "IHa2")

; ?_7: all b.SORD(OP a1 a2) -> b<OP a1 a2 -> b≤cP(OP a1 a2)

(ind); b
     (search)
(assume "b1" "b2" "IHb1" "IHb2")

; ?_10: SORD(OP a1 a2) -> OP b1 b2<OP a1 a2 -> OP b1 b2≤cP(OP a1 a2)

(casedist(pt"SORD a2"))
(assume "sord a2")
(cut(pf"all g.cP(OP g a2)=OP g (cP a2)"))
(assume "cPequ")
(inst-with-to "cPequ" (pt"0") "cPequ0")
(inst-with-to "cPequ" (pt"a1") "cPequa1")
(casedist(pt"a1=0"))
(assume "a1=0")
(ng)
(simp "a1=0")
(simp "cPequ0")
(ng)
(casedist(pt"b1=0"))
(search)
(search)

; ?_22: (a1=0 -> F) -> ...

(assume "a1≠0")
(ng)
(simp "cPequa1")
(ng)
(casedist(pt "b1<a1"))
(assume "b1<a1")
(ng)
(cut( pf "a1<b1->F"))
(assume "b1≤a1")
(ng)
(simp "b1≤a1")
(ng)
(cut(pf"OP a1 (cP a2)=cP(OP a1 a2)"))
(assume "cPequR")
(simp "cPequR")
(use "IHb2")
(simp "cPequa1")
(search)
(use "LESSantisym")
(search)

; ?_35: (b1<a1 -> F) -> ...

(ng)
(assume "a1≤b1" "sord a1a2")
(casedist(pt "a1<b1"))
(auto)

; ?_15: all g cP(OP g a2)=OP g(cP a2)

(assume "g")
(use "PredDown")
(auto)

; ?_12: (SORD a2 -> F) -> ...

(assume "¬sord a2")
(assume "sord a1 a2")
(cut(pf"a1=0 & a2=0"))
(assume "a1a2=0")
(cut(pf "a1=0"))
(assume "a1=0")
(simp "a1=0")
(cut(pf "a2=0"))
(assume "a2=0")
(simp "a2=0")
(prop); INTU
(auto)

; ?_59: a1=0 & a2=0

(use "SORD1")
(auto)

; ok, ?_70 is proved by minimal quantifier logic.  Proof finished.

; (cdp)

(save "Pbiggestsmaller")
(display-theorems "Pbiggestsmaller")






;;; Ordinal Addition + : PLUS

(add-program-constant
 "PLUS"
 (mk-arrow (py "ord") (py "ord") (py "ord"))
 1 'const 2
)


(add-token
 "+"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "PLUS")) x y)))

(add-display
 (py "ord")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "PLUS"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "+"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules For PLUS

(add-computation-rule (pt "a+0")(pt "a"))
(add-computation-rule (pt "0+(OP b1 b2)")(pt "(OP b1 b2)"))
(add-computation-rule (pt "(OP a1 a2) + (OP b1 b2)")(pt "OP a1 (a2+(OP b1 b2))")) 

(display-program-constants "PLUS")



; RWrules for PLUS +

; 0+α = α
(set-goal(pf "(0+a) = a"))
(cases)
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"0+a") (pt"a"))


; α≤α+β

(set-goal(pf "(a+b)<a ->F"))

(ind); a
    (search)
(assume "a1" "a2" "IHa1" "IHa2")
(cases); B
(auto)

; ok, ?_6 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"(a+b)<a") (pt"F"))


; β<γ <-> α+β<α+γ

(set-goal(pf "all b,g.( b<g -> (a+b)<(a+g) ) & ( (a+b)<(a+g) -> b<g )"))

(ind); a
    (search)
(assume "a1" "a2" "IHa1" "IHa2")
(drop "IHa1")
(cases) ; b

(cases) ; g
      (search)
(assume "g1" "g2")
(use-with "IHa2" (pt"0") (pt"OP g1 g2"))

(assume "b1" "b2")

; ?_11: all g.(OP b1 b2<g -> OP a1 a2+OP b1 b2<OP a1 a2+g) & (OP a1 a2+OP b1 b2<OP a1 a2+g -> OP b1 b2<g)

(cases); g
      (search)
(assume "g1" "g2")
(use-with "IHa2" (pt"OP b1 b2") (pt"OP g1 g2"))

; ok, ?_14 is proved.  Proof finished.

(add-rewrite-rule (pt "(a+b)<(a+g)") (pt "b<g"))



; PLUS RW-rule's end

(display-program-constants "PLUS")




; Test for PLUS
(animate "S")
(pnt "4+5")
; 4+5=9
(pnt "12+87")
; 12+87 = 99
(ont "(OP 1 1)+(OP 2 2)")
; ANSWER: ω+1+ω^(2)+2
(pnt "IC ((OP 9 9)+1) (cS (OP 9 9))")
; ANSWER: True
(pnt "IC ((OP 8 9)+1) (cS (OP 9 9))")
; ANSWER: False
(deanimate "S")
; Test's end





;;; natMINUS: -


(add-program-constant
 "natMINUS"
 (mk-arrow (py "ord") (py "ord") (py "ord"))
 1 'const 2
)

;(remove-token "-")
(add-token
 "-"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "natMINUS")) x y)))

(add-display
 (py "ord")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "natMINUS"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "-"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules For natMINUS

;(remove-computation-rules-for (pt "(OP a1 a2)-(OP b1 b2)"))
(add-computation-rule (pt "a-0")(pt "a"))
(add-computation-rule (pt "0-(OP b1 b2)")(pt "0"))
(add-computation-rule (pt "(OP 0 a2)-(OP 0 b2)")(pt "a2-b2"))

(display-program-constants "natMINUS")



; Test for natMINUS
(pnt "100-0")
; 100-0=100
(pnt "0-100")
; 0-100=0
(pnt "87-12")
; 87-12 = 75
(pnt "12-87")
; 12-87 = 0
; Test's end





;;; Partial Multiplication * : natMULT

(add-program-constant
 "natMULT"
 (mk-arrow (py "ord") (py "ord") (py "ord"))
 1 'const 2
)

;(remove-token "*")
(add-token
 "*"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "natMULT")) x y)))

(add-display
 (py "ord")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "natMULT"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "*"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules For natMULT

(add-computation-rule (pt "a*0")(pt "0"))
(add-computation-rule (pt "a*(OP 0 b)")(pt "(a*b)+a"))
(add-computation-rule (pt "0*(OP (OP b1 b2) b3)")(pt "0"))
(add-computation-rule (pt "1*(OP (OP b1 b2) b3)")(pt "(OP (OP b1 b2) b3)"))

(display-program-constants "natMULT")





; Test for natMULT
(animate "S")
(pnt "4*5")
; 4*5=20
(pnt "2*87")
; 2*87 = 174
(ont "(OP 1 1)*2")
; ANSWER: ω+1+ω+1
(ont "(OP 2 2)*3")
; ANSWER: ω^(2)+1+1+ω^(2)+1+1+ω^(2)+2
(ont "IC ((OP 9 9)*1) (OP 9 9)")
; ANSWER: True
(ont "IC ((OP 8 9)*1) (OP 9 9)")
; ANSWER: False
(deanimate "S")
; Test's end







;;; 2-Exponentiation: EXP

; (remove-program-constant "EXP")

(add-program-constant
 "EXP"
 (mk-arrow (py "ord") (py "ord"))
 1 'const 1
)


; Computation Rules For natMULT

(add-computation-rule (pt "EXP 0")(pt "1"))
(add-computation-rule (pt "EXP (OP a b)")(pt "EXP(b)+EXP(b)"))

(display-program-constants "EXP")



; Test for natMULT

(ont "EXP 0")
; 2⁰=1
(ont "EXP(10)")
; 2¹⁰=1024
(ont "EXP(OP 1 1)")
; 2^(ω+1) = 4

; Test's end




;; THE END

(display "\n Global Assumptions: \n")
(display-global-assumptions)

(display"\n Ende \n")


; EOF
