#
# jffs2.py : Jffs2ImageCreator class for creating JFFS2 images
#
# Copyright 2010, Intel Inc.
# Copyright 2010, Marko Saukko <marko.saukko@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os
import subprocess

from mic.imgcreate.errors import *
from mic.imgcreate.creator import *
from mic.imgcreate.fs import *

class Jffs2ImageCreator(LoopImageCreator):
    def __init__(self, ks, name, fslabel = None):
        LoopImageCreator.__init__(self, ks, name, fslabel)
        if self.ks:
            self.image_size = (4*kickstart.get_image_size(self.ks, 200L * 1024 * 1024))
        else:
            self.image_size = 0
        self._set_image_size(self.image_size)
        self.img_done = False
        self._mkjffs2fs = find_binary_path("mkfs.jffs2")
        self._dep_checks.append("mkfs.jffs2")
        self._img_name = self.name + ".jffs2"

    def _genjffs2img(self):
        self.img_done = True
        rc = subprocess.call([self._mkjffs2fs, "-e", "128", "-l", "-n", "-r", self._instroot, "-o", self._outdir + "/" + self._img_name], stdout=sys.stdout, stderr=sys.stderr)
        if rc:
            raise CreatorError("Failed to make jffs2 image")

    def _unmount_instroot(self):
        try:
            if not self.img_done:
                self._genjffs2img()
        finally:
            LoopImageCreator._unmount_instroot(self)

    def _stage_final_image(self):
        return
