/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQZoom_H
#define MvQZoom_H

#include <QBrush>
#include <QGraphicsItem>
#include <QPen>

#include "MvQPlotItem.h"

class MgQLayoutItem;
class MgQSceneItem;

using namespace std;

class MvQZoom : public MvQPlotItem
{
    Q_OBJECT

public:
    enum CurrentAction
    {
        NoAction,
        ZoomAction
    };

    MvQZoom(MgQPlotScene*, MvQPlotView*, QGraphicsItem* parent = 0);
    ~MvQZoom();

    void paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*);
    QRectF boundingRect() const;

    void mousePressEventFromView(QMouseEvent*);
    void mouseMoveEventFromView(QMouseEvent*);
    void mouseReleaseEventFromView(QMouseEvent*);

    CurrentAction currentAction() { return currentAction_; }
    bool zoomWasPerformedAfterMouseRelease() { return zoomWasPerformedAfterMouseRelease_; }

signals:
    void zoomRectangleIsDefined(const string&, const string&);
    void zoomRectangleIsDefined(QString, double, double, double, double);
    void mousePressInSceneItem(MgQSceneItem*);

private:
    QPen pen_;
    QBrush brush_;
    QRectF zoomRect_;
    QPointF zoomRectOrigin_;
    CurrentAction currentAction_;
    MgQLayoutItem* zoomLayout_;
    bool zoomWasPerformedAfterMouseRelease_;
};


#endif
