/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef LEDP_H
#define LEDP_H

#include <Xm/XmP.h>
#include <Xm/PrimitiveP.h>

/* LED class : no new fileds */

typedef struct _LEDClassPart{
    int ignore;
} LEDClassPart;

typedef struct _LEDClassRec{
    CoreClassPart    core_class;
    XmPrimitiveClassPart  primitive_class;
    LEDClassPart  led_class;
} LEDClassRec;

extern LEDClassRec ledClassRec;

typedef struct _LEDPart {
	Pixel           color1;
	Pixel           color2;
	Pixel           color3;
	GC              gc1;
	GC              gc2;
	GC              gc3;
	Boolean         on;
	Boolean         state;
	XtIntervalId    timeout_id;
	int             timeout;
	int             speed;
} LEDPart;

typedef struct _LEDRec {
    CorePart          core;
    XmPrimitivePart  primitive;
    LEDPart        led;
} LEDRec;

#endif
