/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Parameter.h
// Baudouin Raoult - ECMWF Sep 99

#ifndef Parameter_H
#define Parameter_H

#include <string>
using std::string;

struct parameter;
struct value;

#include "Request.h"
class Parameter;

class ParameterScanner {
public:
	virtual void next(const Parameter&, const char*,const char*) = 0;
};

class Language;

class Parameter {
public:

// -- Exceptions
	// None

// -- Contructors

	Parameter(Language&,parameter*);

// -- Destructor

	~Parameter(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	const char* name() const;
	const char* help() const;
	const char* help_icon() const;
	const char* interface() const;

	Request interfaceRequest() const;

    const string& beautifiedName(const string&) const;
    const string& beautifiedName() const;

	void scan(ParameterScanner&) const;

	bool multiple() const;
	bool hasDefaults() const;

	const vector<string>& defaults() const;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Parameter(const Parameter&);
	Parameter& operator=(const Parameter&);

// -- Members

	Language&   lang_;
	parameter*  param_;
	bool        multiple_;
	bool        beautify_;
	map<string,string> beau_;
	string      name_;
	vector<string> defaults_;


// -- Methods

	const string& beautify(const string&) const;

	void scan(ParameterScanner&,const value*) const;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Parameter& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Parameter**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Parameter);
//#endif

#endif
