/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconClass_H
#define IconClass_H

#include <string>

#include "Metview.h"
#include "Action.h"

class Service;
class IconObject;
class Folder;
class Path;
class Language;

using std::string;


class IconClass;
struct ClassScanner {
	virtual void next(const IconClass&) = 0;
};

class IconClass {
public:

	IconClass(const string&,request*,const IconClass* = 0);
	virtual ~IconClass();
	
	virtual const string& name() const;
	virtual string editor() const;
	virtual string type() const;
	virtual string defaultName() const;
	virtual string iconBox() const;
	virtual string helpPage() const;
	virtual string doubleClickMethod() const;
	virtual string defaultMethod() const;
	virtual bool skipDepandancies(const string& action) const;
	virtual Path pixmap() const;
	virtual bool canBeCreated() const;
	virtual Path definitionFile() const;
	virtual Path rulesFile() const;
	virtual long expandFlags() const;

	virtual bool isSubClassOf(const IconClass&) const;
	virtual bool canBecome(const IconClass&) const;

	virtual Service* service(const Action&) const;
	virtual void service(const Action&,const IconClass*,Service*) const;
	virtual set<string> can() const;

	virtual IconObject* defaultObject() const;
	virtual IconObject* createOne(Folder*) const;
        virtual IconObject* createOneFromRequest(Folder*) const;
	
	virtual IconObject* createOne(Folder*,int x, int y) const;
        virtual IconObject* createOneFromRequest(Folder*,int x,int y) const;	
	
	virtual Language& language() const;

	virtual int priority() const;

	static bool isValid(const string& name);
	static const IconClass& find(const string&);
	static const IconClass& find(const string& name,const string& defaultType,bool);
	static void find(const string&,vector<const IconClass*>&,bool onlyCreatable=true);
	static void load(request*);
	static void globalService(const string&,Service*);

	static void scan(ClassScanner&);

	static const IconClass& guess(const Path&);
	static const IconClass& guess(const string&);
	static void guess(const std::string& fullName,std::string& icName,std::string& icType);

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();
private:

// No copy allowed
	IconClass(const IconClass&);
	IconClass& operator=(const IconClass&);
	set<string> generateCan() const;

	const IconClass*     super_;
	string               name_;
	request*             request_;
	
	map<Action,Service*> services_;
	set<const IconClass*>      outputs_;
	mutable set<string> can_;

	//friend ostream& operator<<(ostream& s,const IconClass& p)
	//	{ p.print(s); return s; }

};

inline void destroy(IconClass**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(IconClass);
//#endif

#endif
