# SPDX-license-identifier: Apache-2.0
# Copyright 2012-2021 The Meson development team
# Copyright © 2021 Intel Corporation

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Meson interpreter."""

__all__ = [
    'Interpreter',
    'permitted_dependency_kwargs',

    'CompilerHolder',

    'ExecutableHolder',
    'BuildTargetHolder',
    'CustomTargetHolder',
    'CustomTargetIndexHolder',
    'MachineHolder',
    'Test',
    'ConfigurationDataObject',
    'SubprojectHolder',
    'DependencyHolder',
    'GeneratedListHolder',
    'ExternalProgramHolder',
    'extract_required_kwarg',

    'ArrayHolder',
    'BooleanHolder',
    'DictHolder',
    'IntegerHolder',
    'StringHolder',
]

from .interpreter import Interpreter, permitted_dependency_kwargs
from .compiler import CompilerHolder
from .interpreterobjects import (ExecutableHolder, BuildTargetHolder, CustomTargetHolder,
                                 CustomTargetIndexHolder, MachineHolder, Test,
                                 ConfigurationDataObject, SubprojectHolder, DependencyHolder,
                                 GeneratedListHolder, ExternalProgramHolder,
                                 extract_required_kwarg)

from .primitives import (
    ArrayHolder,
    BooleanHolder,
    DictHolder,
    IntegerHolder,
    StringHolder,
)
