/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#include "mediascanner/dbustypes.h"
#include "mediascanner/settings.h"
#include "mediascanner/utilities.h"

// Test Suite
#include "testlib/testutils.h"

namespace mediascanner {

std::ostream& operator<<(std::ostream &os, const Settings::MediaFormat &f) {
    return os << "(format-name=" << f.name
              << ", caps=" << f.caps << ")";
}

std::ostream& operator<<(std::ostream &os, const Settings::MetadataSource &s) {
    return os << "(plugin-id=" << s.plugin_id
              << ", source-id=" << s.source_id
              << ", config=" << s.config << ")";
}

} // namespace mediascanner

int main(int argc, char **argv) {
    mediascanner::InitTests(&argc, argv);
    mediascanner::Settings settings;

    std::cout << settings.mandatory_containers() << std::endl;
    std::cout << settings.mandatory_decoders() << std::endl;
    std::cout << settings.media_root_urls() << std::endl;
    std::cout << settings.media_root_paths() << std::endl;
    std::cout << settings.metadata_sources() << std::endl;

    return 0;
}
