# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.exodus_ii_writer import ExodusIIWriter


class PExodusIIWriter(ExodusIIWriter):
    r"""
    PExodusIIWriter - Write Exodus II files
    
    Superclass: ExodusIIWriter
    
    This is a Writer that writes it's UnstructuredGrid
        input out to an Exodus II file.  Go to
    http://endo.sandia.gov/SEACAS/
        for more information about the Exodus II format.
    
    
        Exodus files contain much information that is not captured
        in a UnstructuredGrid, such as time steps, information
        lines, node sets, and side sets.  This information can be
        stored in a ModelMetadata object.
    
    
        The ExodusReader and PExodusReader can create
        a ModelMetadata object and embed it in a UnstructuredGrid
        in a series of field arrays.  This writer searches for these
        field arrays and will use the metadata contained in them
        when creating the new Exodus II file.
    
    
        You can also explicitly give the ExodusIIWriter a
        ModelMetadata object to use when writing the file.
    
    
        In the absence of the information provided by ModelMetadata,
        if this writer is not part of a parallel application, we will use
        reasonable defaults for all the values in the output Exodus file.
        If you don't provide a block ID element array, we'll create a
        block for each cell type that appears in the unstructured grid.
    
    
        However if this writer is part of a parallel application (hence
        writing out a distributed Exodus file), then we need at the very
        least a list of all the block IDs that appear in the file.  And
        we need the element array of block IDs for the input unstructured
    grid.
    
    
        In the absence of a ModelMetadata object, you can also provide
        time step information which we will include in the output Exodus
        file.
    
    @warning
        If the input floating point field arrays and point locations are
    all
        floats or all doubles, this class will operate more efficiently.
        Mixing floats and doubles will slow you down, because Exodus II
        requires that we write only floats or only doubles.
    
    @warning
        We use the terms "point" and "node" interchangeably.
        Also, we use the terms "element" and "cell" interchangeably.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPExodusIIWriter, obj, update, **traits)
    
    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('ignore_meta_data_warning', 'GetIgnoreMetaDataWarning'),
    ('write_all_time_steps', 'GetWriteAllTimeSteps'),
    ('write_out_block_id_array', 'GetWriteOutBlockIdArray'),
    ('write_out_global_element_id_array',
    'GetWriteOutGlobalElementIdArray'), ('write_out_global_node_id_array',
    'GetWriteOutGlobalNodeIdArray'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('block_id_array_name', 'GetBlockIdArrayName'), ('file_name',
    'GetFileName'), ('ghost_level', 'GetGhostLevel'), ('store_doubles',
    'GetStoreDoubles'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'ignore_meta_data_warning', 'release_data_flag',
    'write_all_time_steps', 'write_out_block_id_array',
    'write_out_global_element_id_array', 'write_out_global_node_id_array',
    'block_id_array_name', 'file_name', 'ghost_level', 'object_name',
    'progress_text', 'store_doubles'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PExodusIIWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PExodusIIWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['ignore_meta_data_warning', 'write_all_time_steps',
            'write_out_block_id_array', 'write_out_global_element_id_array',
            'write_out_global_node_id_array'], [], ['block_id_array_name',
            'file_name', 'ghost_level', 'object_name', 'store_doubles']),
            title='Edit PExodusIIWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PExodusIIWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

