# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class AdaptiveResampleToImage(DataObjectAlgorithm):
    r"""
    AdaptiveResampleToImage - samples a dataset with adaptive
    refinements.
    
    Superclass: DataObjectAlgorithm
    
    AdaptiveResampleToImage resamples any dataset to a
    `vtkpartitioned_data_set` comprising of `vtkimage_data`. Each partition
    may have different spacing thus spanning different spatial regions
    from the input dataset.
    
    AdaptiveResampleToImage builds a kd-tree with at least as many
    leaf nodes as requested using `set_number_of_images`. The kd tree is
    built by splitting the points in the input dataset. The bounds of
    each leaf are then used to determine the bounds (i.e. spacing and
    origin) for the image dataset for that leaf which will have the
    dimensions requested (set using `set_sampling_dimensions`).
    
    `number_of_images` is simply a hint and the tree will have exactly as
    many leaves as the nearest power of two not less than
    `number_of_images` (see `Math::nearest_power_of_two`). If set to 0, the
    number of images requested is assumed to be same as the number of
    parallel MPI ranks.
    
    When running in parallel, the leaf nodes of the kd-tree are assigned
    to individual ranks. If the leaf nodes is exactly same as the number
    of MPI ranks, then each rank gets a leaf. If the leaf nodes is less
    than the MPI ranks, the extra ranks will not be assigned any data and
    will generate an empty `vtkpartitioned_data_set` in the output. If the
    number of leaf nodes is greater than the number of ranks, then each
    rank my be assigned more than 1 block. The assignment algorithm,
    however, preserves the kd-tree across ranks i.e. a rank will always
    be assigned a complete sub-tree (which may be simply the leaf node).
    @sa `DIYkd_tree_utilities::create_assigner`,
    `DIYkd_tree_utilities::compute_assignments`.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAdaptiveResampleToImage, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    number_of_images = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Get/Set a hint to use to indicate how many different refinements
        to split the dataset into. This is just a hint. The actual number
        of images used to resample the input dataset is the nearest
        power-of-two not less than the requested value (@sa
        Math::NearestPowerOfTwo).
        """
    )

    def _number_of_images_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfImages,
                        self.number_of_images)

    sampling_dimensions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(64, 64, 64), cols=3, desc=\
        r"""
        Set/Get sampling dimensions along each axis. Each partition will
        be resampled using these dimensions.
        """
    )

    def _sampling_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSamplingDimensions,
                        self.sampling_dimensions)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_images', 'GetNumberOfImages'), ('sampling_dimensions',
    'GetSamplingDimensions'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'number_of_images', 'object_name',
    'progress_text', 'sampling_dimensions'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AdaptiveResampleToImage, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AdaptiveResampleToImage properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_images', 'object_name',
            'sampling_dimensions']),
            title='Edit AdaptiveResampleToImage properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AdaptiveResampleToImage properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

