package org.apache.maven.scm.repository;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.scm.provider.ScmProviderRepository;

/**
 * @author <a href="mailto:evenisse@apache.org">Emmanuel Venisse</a>
 * @version $Id: ScmRepository.java 685539 2008-08-13 13:27:27Z vsiveton $
 * @todo clarify need - should be able to merge with ScmProviderRepository?
 */
public class ScmRepository
{
    /** */
    private String provider;

    /** */
    private ScmProviderRepository providerRepository;

    public ScmRepository( String provider, ScmProviderRepository providerRepository )
    {
        this.provider = provider;

        this.providerRepository = providerRepository;
    }

    /**
     * @return Returns the provider.
     */
    public String getProvider()
    {
        return provider;
    }

    /**
     * @return Returns the provider repository.
     */
    public ScmProviderRepository getProviderRepository()
    {
        return providerRepository;
    }

    /** {@inheritDoc} */
    public String toString()
    {
        return provider.toString() + ":" + providerRepository.toString();
    }
}

